/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanicals.utility.lang;

import com.oierbravo.mechanicals.utility.MechanicalLangIdGenerator;
import com.oierbravo.mechanicals.utility.lang.MechanicalLangBuilder;
import com.tterrag.registrate.AbstractRegistrate;
import java.util.function.Supplier;

public class MechanicalRegistrateLangBuilder<R extends AbstractRegistrate<?>> {
    private final String namespace;
    private final R registrate;
    protected final Supplier<MechanicalLangBuilder> langBuilderSupplier;

    public MechanicalRegistrateLangBuilder(String namespace, R registrate, Supplier<MechanicalLangBuilder> langBuilder) {
        this.namespace = namespace;
        this.registrate = registrate;
        this.langBuilderSupplier = langBuilder;
    }

    public MechanicalLangBuilder add(String literal, String defaultTranslation) {
        return this.addRawLang(literal, defaultTranslation);
    }

    public MechanicalLangBuilder addCreativeTab(String defaultTranslation) {
        return this.add(MechanicalLangIdGenerator.creativeTabId("main"), defaultTranslation);
    }

    public MechanicalLangBuilder addJade(String defaultTranslation) {
        String key = MechanicalLangIdGenerator.jadeId(this.namespace);
        this.registrate.addRawLang(key, defaultTranslation);
        return this.langBuilderSupplier.get().key(key);
    }

    public MechanicalLangBuilder addRaw(String literal, String defaultTranslation) {
        this.registrate.addRawLang(literal, defaultTranslation);
        return this.langBuilderSupplier.get().key(literal);
    }

    protected MechanicalLangBuilder addRecipeRequirement(String variant, String id, String defaultTranslation) {
        String key = "mechanicals." + MechanicalLangIdGenerator.recipeRequirement(id, variant);
        this.registrate.addRawLang(key, defaultTranslation);
        return this.langBuilderSupplier.get().key(key);
    }

    public MechanicalLangBuilder addRecipeRequirementTitle(String id, String defaultTranslation) {
        return this.addRecipeRequirement("title", id, defaultTranslation);
    }

    public MechanicalLangBuilder addRecipeRequirementValue(String id, String defaultTranslation) {
        return this.addRecipeRequirement("value", id, defaultTranslation);
    }

    public MechanicalLangBuilder addRecipeRequirementMissing(String id, String defaultTranslation) {
        return this.addRecipeRequirement("missing", id, defaultTranslation);
    }

    protected MechanicalLangBuilder addTooltip(String id, String type, String variant, String defaultTranslation) {
        String key = type + "." + this.namespace + "." + id + ".tooltip." + variant;
        this.registrate.addRawLang(key, defaultTranslation);
        return this.langBuilderSupplier.get().key(key);
    }

    public MechanicalLangBuilder addItemTooltip(String id, String variant, String defaultTranslation) {
        return this.addTooltip(id, "item", variant, defaultTranslation);
    }

    public MechanicalLangBuilder addItemTooltipSummary(String id, String defaultTranslation) {
        return this.addItemTooltip(id, "summary", defaultTranslation);
    }

    public MechanicalLangBuilder addItemTooltipCondition(String id, int index, String defaultTranslation) {
        return this.addItemTooltip(id, "condition" + index, defaultTranslation);
    }

    public MechanicalLangBuilder addItemTooltipBehaviour(String id, int index, String defaultTranslation) {
        return this.addItemTooltip(id, "behaviour" + index, defaultTranslation);
    }

    protected MechanicalLangBuilder addBlockTooltip(String id, String variant, String defaultTranslation) {
        return this.addTooltip(id, "block", variant, defaultTranslation);
    }

    public MechanicalLangBuilder addBlockTooltipSummary(String id, String defaultTranslation) {
        return this.addBlockTooltip(id, "summary", defaultTranslation);
    }

    public MechanicalLangBuilder addBlockTooltipCondition(String id, int index, String defaultTranslation) {
        return this.addBlockTooltip(id, "condition" + index, defaultTranslation);
    }

    public MechanicalLangBuilder addBlockTooltipBehaviour(String id, int index, String defaultTranslation) {
        return this.addBlockTooltip(id, "behaviour" + index, defaultTranslation);
    }

    protected MechanicalLangBuilder addPonder(String id, String variant, String defaultTranslation) {
        String key = this.namespace + ".ponder." + id + "." + variant;
        this.registrate.addRawLang(key, defaultTranslation);
        return this.langBuilderSupplier.get().key(key);
    }

    public MechanicalLangBuilder addPonderHeader(String id, String defaultTranslation) {
        return this.addPonder(id, "header", defaultTranslation);
    }

    public MechanicalLangBuilder addPonderText(int index, String id, String defaultTranslation) {
        return this.addPonder(id, "text_" + index, defaultTranslation);
    }

    protected MechanicalLangBuilder addRawLang(String key, String defaultTranslation) {
        return this.addRawLang(key, defaultTranslation, false);
    }

    protected MechanicalLangBuilder addRawLang(String key, String defaultTranslation, boolean customNamespace) {
        this.registrate.addRawLang((String)(customNamespace ? key : this.namespace + "." + key), defaultTranslation);
        return this.langBuilderSupplier.get().key(key);
    }
}

