/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.MoltenVents.core.objects;

import com.Apothic0n.MoltenVents.MoltenVentsJsonReader;
import com.Apothic0n.MoltenVents.config.CommonConfig;
import com.Apothic0n.MoltenVents.core.objects.MoltenBlockEntities;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.loading.FMLPaths;

public class ActiveMoltenBlockEntity
extends BlockEntity {
    public static String configDir = String.valueOf(FMLPaths.CONFIGDIR.get()) + "/molten_vents";
    private static List<String> readBlocks = new ArrayList<String>(List.of());
    private static Map<String, List<String>> conductiveMap = new HashMap<String, List<String>>(Map.of());
    private static Map<String, List<String>> convertibleMap = new HashMap<String, List<String>>(Map.of());
    public static int spreadDistance = 5;

    public ActiveMoltenBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(ActiveMoltenBlockEntity.activeMoltenBlockEntity(blockState), blockPos, blockState);
    }

    private static BlockEntityType<?> activeMoltenBlockEntity(BlockState blockState) {
        List<Map<Block, BlockEntityType<?>>> moltenBlockEntities = MoltenBlockEntities.getMoltenBlockEntities();
        BlockEntityType<?> activeMoltenBlockEntity = null;
        for (int i = 0; i < moltenBlockEntities.size(); ++i) {
            BlockEntityType<?> activeBlockEntity = moltenBlockEntities.get(i).get(blockState.getBlock());
            if (activeBlockEntity == null) continue;
            activeMoltenBlockEntity = activeBlockEntity;
        }
        return activeMoltenBlockEntity;
    }

    public static void reload() {
        readBlocks = new ArrayList<String>(List.of());
        conductiveMap = new HashMap<String, List<String>>(Map.of());
        convertibleMap = new HashMap<String, List<String>>(Map.of());
    }

    private static Map<Integer, List<Block>> getLists(BlockState blockState) throws IOException {
        String name = blockState.getBlock().builtInRegistryHolder().key().location().getPath().substring(14);
        if (!readBlocks.contains(name)) {
            readBlocks.add(name);
            Gson gson = new Gson();
            Path conductive = Path.of(configDir + "/conductive/" + name + ".json", new String[0]);
            Path convertible = Path.of(configDir + "/convertible/" + name + ".json", new String[0]);
            MoltenVentsJsonReader.createConductive(gson, conductive, name);
            JsonReader reader = new JsonReader((Reader)new FileReader(conductive.toString()));
            JsonObject data = (JsonObject)gson.fromJson(reader, JsonObject.class);
            JsonArray conductiveBlockNames = data.get("values").getAsJsonArray();
            ArrayList<String> tempConductiveBlocks = new ArrayList<String>(List.of());
            for (int i = 0; i < conductiveBlockNames.size(); ++i) {
                tempConductiveBlocks.add(conductiveBlockNames.get(i).getAsString());
            }
            conductiveMap.put(name, tempConductiveBlocks);
            MoltenVentsJsonReader.createConvertible(gson, convertible);
            reader = new JsonReader((Reader)new FileReader(convertible.toString()));
            data = (JsonObject)gson.fromJson(reader, JsonObject.class);
            JsonArray convertibleBlockNames = data.get("values").getAsJsonArray();
            ArrayList<String> tempConvertibleBlocks = new ArrayList<String>(List.of());
            for (int i = 0; i < convertibleBlockNames.size(); ++i) {
                tempConvertibleBlocks.add(convertibleBlockNames.get(i).getAsString());
            }
            convertibleMap.put(name, tempConvertibleBlocks);
        }
        ArrayList<Block> conductiveBlocks = new ArrayList<Block>(List.of());
        ArrayList<Block> convertibleBlocks = new ArrayList<Block>(List.of());
        List<String> conductiveList = conductiveMap.get(name);
        for (String blockName : conductiveList) {
            conductiveBlocks.add((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)blockName)));
        }
        List<String> convertibleList = convertibleMap.get(name);
        for (String blockName : convertibleList) {
            convertibleBlocks.add((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)blockName)));
        }
        return Map.of(1, conductiveBlocks, 2, convertibleBlocks);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        if (!level.isClientSide) {
            ServerLevel serverLevel = Objects.requireNonNull(level.getServer()).getLevel(level.dimension());
            Map<Integer, List<Block>> lists = null;
            try {
                lists = ActiveMoltenBlockEntity.getLists(blockState);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            List<Block> conductiveBlocks = lists.get(1);
            List<Block> convertibleBlocks = lists.get(2);
            ActiveMoltenBlockEntity.spreadBlock(conductiveBlocks, convertibleBlocks, blockPos.above(), (WorldGenLevel)serverLevel);
            ActiveMoltenBlockEntity.spreadBlock(conductiveBlocks, convertibleBlocks, blockPos.below(), (WorldGenLevel)serverLevel);
            ActiveMoltenBlockEntity.spreadBlock(conductiveBlocks, convertibleBlocks, blockPos.north(), (WorldGenLevel)serverLevel);
            ActiveMoltenBlockEntity.spreadBlock(conductiveBlocks, convertibleBlocks, blockPos.east(), (WorldGenLevel)serverLevel);
            ActiveMoltenBlockEntity.spreadBlock(conductiveBlocks, convertibleBlocks, blockPos.south(), (WorldGenLevel)serverLevel);
            ActiveMoltenBlockEntity.spreadBlock(conductiveBlocks, convertibleBlocks, blockPos.west(), (WorldGenLevel)serverLevel);
        }
    }

    private static void spreadBlock(List<Block> conductiveBlocks, List<Block> convertibleBlocks, BlockPos pos, WorldGenLevel level) {
        BlockState[] contacts = new BlockState[]{level.getBlockState(pos.above()), level.getBlockState(pos.below()), level.getBlockState(pos.north()), level.getBlockState(pos.east()), level.getBlockState(pos.south()), level.getBlockState(pos.west())};
        Boolean isTouchingOrestone = false;
        for (int i = 0; i < contacts.length && !isTouchingOrestone.booleanValue(); ++i) {
            if (!conductiveBlocks.contains(contacts[i].getBlock())) continue;
            isTouchingOrestone = true;
        }
        if (isTouchingOrestone != false && !level.getBlockState(pos).liquid() && convertibleBlocks.contains(level.getBlockState(pos).getBlock()) || isTouchingOrestone != false && (Boolean)CommonConfig.useSource.get() == false && convertibleBlocks.contains(level.getBlockState(pos).getBlock()) || isTouchingOrestone != false && (Boolean)CommonConfig.useSource.get() != false && convertibleBlocks.contains(level.getBlockState(pos).getBlock()) && level.getBlockState(pos).getFluidState().isSource() || isTouchingOrestone.booleanValue() && conductiveBlocks.contains(level.getBlockState(pos).getBlock())) {
            List<BlockPos> convertedBlocks;
            if (!level.getBlockState(pos).liquid() && convertibleBlocks.contains(level.getBlockState(pos).getBlock()) || (Boolean)CommonConfig.useSource.get() == false && convertibleBlocks.contains(level.getBlockState(pos).getBlock()) || ((Boolean)CommonConfig.useSource.get()).booleanValue() && convertibleBlocks.contains(level.getBlockState(pos).getBlock()) && level.getBlockState(pos).getFluidState().isSource()) {
                level.setBlock(pos, conductiveBlocks.get(0).defaultBlockState(), 3);
                level.playSound(null, pos, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.getServer().getLevel(level.getLevel().dimension()).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.25, (double)pos.getZ() + 0.5, 8, 0.5, 0.25, 0.5, 0.0);
            }
            if ((convertedBlocks = ActiveMoltenBlockEntity.convertTouching(convertibleBlocks, conductiveBlocks, pos, level)) != null && !convertedBlocks.isEmpty() && spreadDistance >= 1) {
                ArrayList<BlockPos> secondaryConvertedBlocks = new ArrayList<BlockPos>(List.of());
                for (int i = 0; i < convertedBlocks.size(); ++i) {
                    List<BlockPos> minorConvertedBlocks = ActiveMoltenBlockEntity.convertTouching(convertibleBlocks, conductiveBlocks, convertedBlocks.get(i), level);
                    if (minorConvertedBlocks == null || !minorConvertedBlocks.isEmpty()) continue;
                    secondaryConvertedBlocks.addAll(minorConvertedBlocks);
                }
                if (secondaryConvertedBlocks != null && !secondaryConvertedBlocks.isEmpty() && spreadDistance >= 2) {
                    ArrayList<BlockPos> teritaryConvertedBlocks = new ArrayList<BlockPos>(List.of());
                    for (int i = 0; i < secondaryConvertedBlocks.size(); ++i) {
                        List<BlockPos> minorConvertedBlocks = ActiveMoltenBlockEntity.convertTouching(convertibleBlocks, conductiveBlocks, (BlockPos)secondaryConvertedBlocks.get(i), level);
                        if (minorConvertedBlocks == null || !minorConvertedBlocks.isEmpty()) continue;
                        teritaryConvertedBlocks.addAll(minorConvertedBlocks);
                    }
                    if (teritaryConvertedBlocks != null && !teritaryConvertedBlocks.isEmpty() && spreadDistance >= 3) {
                        ArrayList<BlockPos> quaternaryConvertedBlocks = new ArrayList<BlockPos>(List.of());
                        for (int i = 0; i < teritaryConvertedBlocks.size(); ++i) {
                            List<BlockPos> minorConvertedBlocks = ActiveMoltenBlockEntity.convertTouching(convertibleBlocks, conductiveBlocks, (BlockPos)teritaryConvertedBlocks.get(i), level);
                            if (minorConvertedBlocks == null || !minorConvertedBlocks.isEmpty()) continue;
                            quaternaryConvertedBlocks.addAll(minorConvertedBlocks);
                        }
                        if (quaternaryConvertedBlocks != null && !quaternaryConvertedBlocks.isEmpty() && spreadDistance >= 4) {
                            ArrayList<BlockPos> quinaryConvertedBlocks = new ArrayList<BlockPos>(List.of());
                            for (int i = 0; i < quaternaryConvertedBlocks.size(); ++i) {
                                List<BlockPos> minorConvertedBlocks = ActiveMoltenBlockEntity.convertTouching(convertibleBlocks, conductiveBlocks, (BlockPos)quaternaryConvertedBlocks.get(i), level);
                                if (minorConvertedBlocks == null || !minorConvertedBlocks.isEmpty()) continue;
                                quinaryConvertedBlocks.addAll(minorConvertedBlocks);
                            }
                            if (quinaryConvertedBlocks != null && !quinaryConvertedBlocks.isEmpty() && spreadDistance >= 5) {
                                ArrayList<BlockPos> senaryConvertedBlocks = new ArrayList<BlockPos>(List.of());
                                for (int i = 0; i < quinaryConvertedBlocks.size(); ++i) {
                                    List<BlockPos> minorConvertedBlocks = ActiveMoltenBlockEntity.convertTouching(convertibleBlocks, conductiveBlocks, (BlockPos)quinaryConvertedBlocks.get(i), level);
                                    if (minorConvertedBlocks == null || !minorConvertedBlocks.isEmpty()) continue;
                                    senaryConvertedBlocks.addAll(minorConvertedBlocks);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static List<BlockPos> convertTouching(List<Block> convertibleBlocks, List<Block> conductiveBlocks, BlockPos pos, WorldGenLevel level) {
        List<BlockPos> lavaBlocks = ActiveMoltenBlockEntity.getLavaTouching(convertibleBlocks, pos, level);
        List<BlockPos> touchingBlocks = ActiveMoltenBlockEntity.getLavaTouching(conductiveBlocks, pos, level);
        if (lavaBlocks != null && !lavaBlocks.isEmpty()) {
            for (int i = 0; i < lavaBlocks.size(); ++i) {
                BlockPos lavaPos = lavaBlocks.get(i);
                if (!(!level.getBlockState(lavaPos).liquid() && convertibleBlocks.contains(level.getBlockState(lavaPos).getBlock()) || (Boolean)CommonConfig.useSource.get() == false && convertibleBlocks.contains(level.getBlockState(lavaPos).getBlock())) && (!((Boolean)CommonConfig.useSource.get()).booleanValue() || !convertibleBlocks.contains(level.getBlockState(lavaPos).getBlock()) || !level.getBlockState(lavaPos).getFluidState().isSource())) continue;
                level.setBlock(lavaPos, conductiveBlocks.get(0).defaultBlockState(), 3);
                level.playSound(null, lavaPos, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.getServer().getLevel(level.getLevel().dimension()).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)lavaPos.getX() + 0.5, (double)lavaPos.getY() + 0.25, (double)lavaPos.getZ() + 0.5, 8, 0.5, 0.25, 0.5, 0.0);
            }
        }
        if (touchingBlocks.size() > 0) {
            return touchingBlocks;
        }
        return null;
    }

    private static List<BlockPos> getLavaTouching(List<Block> convertibleBlocks, BlockPos pos, WorldGenLevel level) {
        BlockPos[] contacts = new BlockPos[]{pos.above(), pos.below(), pos.north(), pos.east(), pos.south(), pos.west()};
        ArrayList<BlockPos> lavaBlocks = new ArrayList<BlockPos>(List.of());
        for (int i = 0; i < contacts.length; ++i) {
            if (!(!level.getBlockState(contacts[i]).liquid() && convertibleBlocks.contains(level.getBlockState(contacts[i]).getBlock()) || (Boolean)CommonConfig.useSource.get() == false && convertibleBlocks.contains(level.getBlockState(contacts[i]).getBlock()) || (Boolean)CommonConfig.useSource.get() != false && convertibleBlocks.contains(level.getBlockState(contacts[i]).getBlock()) && level.getBlockState(contacts[i]).getFluidState().isSource()) && !convertibleBlocks.contains(level.getBlockState(contacts[i]).getBlock())) continue;
            lavaBlocks.add(contacts[i]);
        }
        if (!lavaBlocks.isEmpty()) {
            return lavaBlocks;
        }
        return null;
    }
}

