/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.trades;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.trades.ModItemListing;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.trading.MerchantOffer;
import org.jetbrains.annotations.Nullable;

public record BiomeVariantItemListing(Map<VillagerType, ModItemListing> listingMap, ModItemListing defaultListing) implements ModItemListing
{
    public static final MapCodec<BiomeVariantItemListing> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap((Codec)BuiltInRegistries.VILLAGER_TYPE.byNameCodec(), ModItemListing.CODEC).fieldOf("trades_per_type").forGetter(BiomeVariantItemListing::listingMap), (App)ModItemListing.CODEC.fieldOf("default").forGetter(BiomeVariantItemListing::defaultListing)).apply((Applicative)instance, BiomeVariantItemListing::new)).validate(listing -> {
        int originalLevel = listing.defaultListing.getLevel();
        for (Map.Entry<VillagerType, ModItemListing> entry : listing.listingMap.entrySet()) {
            if (entry.getValue().getLevel() == originalLevel) continue;
            return DataResult.error(() -> "All listings must have the same level");
        }
        return DataResult.success((Object)listing);
    });

    @Override
    public MapCodec<? extends ModItemListing> getCodec() {
        return CODEC;
    }

    @Nullable
    public MerchantOffer getOffer(Entity trader, RandomSource random) {
        Villager villager;
        VillagerType villagerType;
        ModItemListing listing;
        if (trader instanceof Villager && (listing = this.listingMap.get(villagerType = (villager = (Villager)trader).getVillagerData().getType())) != null) {
            return listing.getOffer(trader, random);
        }
        return this.defaultListing.getOffer(trader, random);
    }

    @Override
    public int getLevel() {
        return this.defaultListing.getLevel();
    }
}

