/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.enchantment;

import com.almostreliable.morejs.features.enchantment.EnchantmentData;
import com.almostreliable.morejs.features.enchantment.EnchantmentMenuState;
import com.almostreliable.morejs.features.enchantment.EnchantmentTableEventJS;
import com.google.common.base.Preconditions;
import dev.latvian.mods.kubejs.event.EventResult;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;

public class EnchantmentTableServerEventJS
extends EnchantmentTableEventJS {
    protected final EnchantmentMenuState state;
    private final BlockPos pos;
    private boolean itemChanged;
    private final Int2ObjectOpenHashMap<EnchantmentData> enchantments = new Int2ObjectOpenHashMap();

    public EnchantmentTableServerEventJS(ItemStack item, ItemStack secondItem, Level level, BlockPos pos, Player player, EnchantmentMenuState state) {
        super(item, secondItem, level, player, state.getMenu());
        this.pos = pos;
        this.state = state;
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    public EnchantmentData get(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.getSize());
        return (EnchantmentData)this.enchantments.computeIfAbsent(index, i -> {
            List<EnchantmentInstance> eis = this.state.getEnchantments(i);
            return new EnchantmentData(eis, i, this.state.getMenu(), this.getLevel());
        });
    }

    public int getSize() {
        return this.state.getMenu().costs.length;
    }

    public void setItem(ItemStack item) {
        this.itemChanged = true;
        this.item = item;
    }

    public boolean itemWasChanged() {
        return this.itemChanged;
    }

    public void afterPosted(EventResult result) {
        super.afterPosted(result);
        this.enchantments.forEach((integer, data) -> {
            if (data.getEnchantments().isEmpty()) {
                data.setRequiredLevel(0);
                data.clearClue();
            }
        });
    }
}

