/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.potion;

import com.almostreliable.morejs.util.Utils;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;

public record CustomBrewingFilter(Optional<Ingredient> ingredient, Optional<Ingredient> input, Optional<Ingredient> output) implements Predicate<BrewingRecipe>
{
    @Override
    public boolean test(BrewingRecipe brewingRecipe) {
        if (this.input().isPresent() && this.input.filter(input -> Utils.matchesIngredient(input, brewingRecipe.getInput())).isEmpty()) {
            return false;
        }
        if (this.output().isPresent() && this.output.filter(output -> output.test(brewingRecipe.getOutput())).isEmpty()) {
            return false;
        }
        return this.ingredient().isEmpty() || this.ingredient.filter(ingredient -> Utils.matchesIngredient(ingredient, brewingRecipe.getIngredient())).isPresent();
    }
}

