/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.potion;

import com.almostreliable.morejs.util.Utils;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.HolderSet;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.Ingredient;

public record PotionBrewingFilter(Optional<Ingredient> ingredient, Optional<HolderSet<Potion>> input, Optional<HolderSet<Potion>> output) implements Predicate<PotionBrewing.Mix<Potion>>
{
    @Override
    public boolean test(PotionBrewing.Mix<Potion> potionMix) {
        if (this.input.isPresent() && this.input.filter(input -> input.contains(potionMix.from())).isEmpty()) {
            return false;
        }
        if (this.output.isPresent() && this.output.filter(output -> output.contains(potionMix.to())).isEmpty()) {
            return false;
        }
        return this.ingredient().isEmpty() || this.ingredient.filter(ingredient -> Utils.matchesIngredient(ingredient, potionMix.ingredient())).isPresent();
    }
}

