/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager;

import com.almostreliable.morejs.features.villager.IntRange;
import dev.latvian.mods.kubejs.bindings.ItemWrapper;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;

public class TradeItem {
    public static final TradeItem EMPTY = new TradeItem(ItemStack.EMPTY, null);
    private final ItemStack itemStack;
    @Nullable
    private final IntRange countRange;

    public static TradeItem of(ItemStack item) {
        return new TradeItem(ItemWrapper.of((ItemStack)item), null);
    }

    public static TradeItem of(ItemStack item, int price) {
        return TradeItem.of(item, price, price);
    }

    public static TradeItem of(ItemStack item, int min, int max) {
        return new TradeItem(ItemWrapper.of((ItemStack)item), new IntRange(min, max));
    }

    public TradeItem(ItemStack itemStack, @Nullable IntRange countRange) {
        this.itemStack = itemStack;
        this.countRange = countRange;
    }

    public ItemStack createItemStack(RandomSource random) {
        if (this.itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (this.countRange == null) {
            return this.itemStack.copy();
        }
        int c = this.countRange.getRandom(random);
        ItemStack stack = this.itemStack.copy();
        stack.setCount(c);
        return stack;
    }

    public ItemCost createItemCost(RandomSource random) {
        ItemStack copy = this.itemStack.copy();
        if (this.countRange != null) {
            copy.setCount(this.countRange.getRandom(random));
        }
        DataComponentPredicate dcp = DataComponentPredicate.allOf((DataComponentMap)copy.getComponents());
        return new ItemCost((Holder)copy.getItem().builtInRegistryHolder(), copy.getCount(), dcp, copy);
    }

    public boolean isEmpty() {
        return this.itemStack.isEmpty();
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public IntRange getCountRange() {
        if (this.countRange == null) {
            return new IntRange(1, 1);
        }
        return this.countRange;
    }
}

