/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager;

import com.almostreliable.morejs.MoreJSBinding;
import com.almostreliable.morejs.features.villager.TradeItem;
import com.almostreliable.morejs.features.villager.trades.CustomTrade;
import com.almostreliable.morejs.features.villager.trades.EnchantedItemTrade;
import com.almostreliable.morejs.features.villager.trades.PotionTrade;
import com.almostreliable.morejs.features.villager.trades.SimpleTrade;
import com.almostreliable.morejs.features.villager.trades.StewTrade;
import com.almostreliable.morejs.features.villager.trades.TransformableTrade;
import com.almostreliable.morejs.features.villager.trades.TreasureMapTrade;
import com.almostreliable.morejs.util.BlockPosFinder;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;

public class VillagerUtils {
    public static final Map<VillagerProfession, List<VillagerTrades.ItemListing>> CACHED_PROFESSION_TRADES = new HashMap<VillagerProfession, List<VillagerTrades.ItemListing>>();
    public static final Set<Class<? extends VillagerTrades.ItemListing>> VANILLA_TRADE_TYPES = Set.of(VillagerTrades.DyedArmorForEmeralds.class, VillagerTrades.EnchantBookForEmeralds.class, VillagerTrades.EnchantedItemForEmeralds.class, VillagerTrades.ItemsForEmeralds.class, VillagerTrades.ItemsAndEmeraldsToItems.class, VillagerTrades.EmeraldForItems.class, VillagerTrades.TippedArrowForItemsAndEmeralds.class, VillagerTrades.SuspiciousStewForEmerald.class, VillagerTrades.TreasureMapForEmeralds.class);

    public static boolean isVanillaTypedTrade(VillagerTrades.ItemListing listing) {
        return VANILLA_TRADE_TYPES.contains(listing.getClass());
    }

    public static boolean isModdedTypedTrade(VillagerTrades.ItemListing listing) {
        return !VillagerUtils.isVanillaTypedTrade(listing) && !VillagerUtils.isCustomTypedTrade(listing);
    }

    public static boolean isCustomTypedTrade(VillagerTrades.ItemListing listing) {
        return listing instanceof TransformableTrade || listing instanceof CustomTrade;
    }

    public static Collection<VillagerProfession> getProfessions() {
        return BuiltInRegistries.VILLAGER_PROFESSION.stream().filter(p -> !p.name().equals("none")).toList();
    }

    public static VillagerProfession getProfession(ResourceLocation id) {
        VillagerProfession villagerProfession = (VillagerProfession)BuiltInRegistries.VILLAGER_PROFESSION.get(id);
        if (villagerProfession == VillagerProfession.NONE) {
            throw new IllegalStateException("No profession with id " + String.valueOf(id));
        }
        return villagerProfession;
    }

    public static SimpleTrade createSimpleTrade(TradeItem[] inputs, TradeItem output) {
        return new SimpleTrade(inputs, output);
    }

    public static CustomTrade createCustomTrade(TransformableTrade.Transformer transformer) {
        return new CustomTrade(transformer);
    }

    public static TreasureMapTrade createStructureMapTrade(TradeItem[] inputs, HolderSet<Structure> structures) {
        return new TreasureMapTrade(inputs, (level, entity) -> MoreJSBinding.findStructure(entity.blockPosition(), level, structures, 100));
    }

    public static TreasureMapTrade createBiomeMapTrade(TradeItem[] inputs, HolderSet<Biome> biomes) {
        return new TreasureMapTrade(inputs, (level, entity) -> MoreJSBinding.findBiome(entity.blockPosition(), level, biomes, 250));
    }

    public static TreasureMapTrade createCustomMapTrade(TradeItem[] inputs, BlockPosFinder func) {
        return new TreasureMapTrade(inputs, func);
    }

    public static EnchantedItemTrade createEnchantedItemTrade(TradeItem[] inputs, ItemStack output) {
        return new EnchantedItemTrade(inputs, output, (TagKey<Enchantment>)EnchantmentTags.ON_TRADED_EQUIPMENT);
    }

    public static EnchantedItemTrade createEnchantedItemTrade(TradeItem[] inputs, ItemStack output, HolderSet<Enchantment> enchantments) {
        return new EnchantedItemTrade(inputs, output, enchantments);
    }

    public static StewTrade createStewTrade(TradeItem[] inputs) {
        return new StewTrade(inputs);
    }

    public static PotionTrade createPotionTrade(TradeItem[] inputs) {
        return new PotionTrade(inputs);
    }

    public static void setAbstractTrades(Map<Integer, VillagerTrades.ItemListing[]> tradeMap, int level, List<VillagerTrades.ItemListing> listings) {
        tradeMap.put(level, listings.toArray(new VillagerTrades.ItemListing[0]));
    }

    public static List<VillagerTrades.ItemListing> getAbstractTrades(Map<Integer, VillagerTrades.ItemListing[]> tradeMap, int level) {
        VillagerTrades.ItemListing[] listings = tradeMap.get(level);
        if (listings == null) {
            return new ArrayList<VillagerTrades.ItemListing>();
        }
        return new ArrayList<VillagerTrades.ItemListing>(Arrays.asList(listings));
    }

    public static List<VillagerTrades.ItemListing> getVillagerTrades(VillagerProfession profession) {
        return CACHED_PROFESSION_TRADES.computeIfAbsent(profession, p -> {
            Int2ObjectMap levelListings = (Int2ObjectMap)VillagerTrades.TRADES.get(p);
            if (levelListings == null) {
                return List.of();
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            ObjectIterator objectIterator = levelListings.values().iterator();
            while (objectIterator.hasNext()) {
                VillagerTrades.ItemListing[] listings;
                for (VillagerTrades.ItemListing listing : listings = (VillagerTrades.ItemListing[])objectIterator.next()) {
                    builder.add((Object)listing);
                }
            }
            return builder.build();
        });
    }

    public static List<VillagerTrades.ItemListing> getVillagerTrades(VillagerProfession profession, int level) {
        Int2ObjectMap levelListings = (Int2ObjectMap)VillagerTrades.TRADES.get(profession);
        if (levelListings == null) {
            return List.of();
        }
        VillagerTrades.ItemListing[] listings = (VillagerTrades.ItemListing[])levelListings.get(level);
        if (listings == null) {
            return List.of();
        }
        return Arrays.asList(listings);
    }

    public static VillagerTrades.ItemListing getRandomVillagerTrade(VillagerProfession profession) {
        List<VillagerTrades.ItemListing> trades = VillagerUtils.getVillagerTrades(profession);
        if (trades.isEmpty()) {
            throw new IllegalStateException("Profession " + String.valueOf(profession) + " has no trades");
        }
        return trades.get(ThreadLocalRandom.current().nextInt(trades.size()));
    }

    public static VillagerTrades.ItemListing getRandomVillagerTrade(VillagerProfession profession, int level) {
        List<VillagerTrades.ItemListing> trades = VillagerUtils.getVillagerTrades(profession, level);
        if (trades.isEmpty()) {
            throw new IllegalStateException("Profession " + String.valueOf(profession) + " on level " + level + " has no trades");
        }
        return trades.get(ThreadLocalRandom.current().nextInt(trades.size()));
    }

    public static List<VillagerTrades.ItemListing> getWandererTrades(int level) {
        VillagerTrades.ItemListing[] listings = (VillagerTrades.ItemListing[])VillagerTrades.WANDERING_TRADER_TRADES.get(level);
        if (listings == null) {
            return List.of();
        }
        return Arrays.asList(listings);
    }

    public static VillagerTrades.ItemListing getRandomWandererTrade(int level) {
        List<VillagerTrades.ItemListing> trades = VillagerUtils.getWandererTrades(level);
        if (trades.isEmpty()) {
            throw new IllegalStateException("Wanderer on level " + level + " has no trades");
        }
        return trades.get(ThreadLocalRandom.current().nextInt(trades.size()));
    }
}

