/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager.events;

import com.almostreliable.morejs.features.villager.VillagerUtils;
import dev.latvian.mods.kubejs.entity.KubeLivingEntityEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;

public abstract class UpdateOfferEventJS
implements KubeLivingEntityEvent {
    private final AbstractVillager villager;
    private final MerchantOffers allOffers;
    @Nullable
    private List<VillagerTrades.ItemListing> cachedWandererTrades;

    public UpdateOfferEventJS(AbstractVillager villager, MerchantOffers allOffers) {
        this.villager = villager;
        this.allOffers = allOffers;
    }

    public RandomSource getRandom() {
        return this.villager.getRandom();
    }

    public LivingEntity getEntity() {
        return this.villager;
    }

    @Nullable
    public VillagerData getVillagerData() {
        AbstractVillager abstractVillager = this.villager;
        if (abstractVillager instanceof VillagerDataHolder) {
            VillagerDataHolder v = (VillagerDataHolder)abstractVillager;
            return v.getVillagerData();
        }
        return null;
    }

    public boolean isProfession(VillagerProfession profession) {
        AbstractVillager abstractVillager = this.villager;
        if (abstractVillager instanceof VillagerDataHolder) {
            VillagerDataHolder v = (VillagerDataHolder)abstractVillager;
            return v.getVillagerData().getProfession() == profession;
        }
        return false;
    }

    public int getVillagerLevel() {
        AbstractVillager abstractVillager = this.villager;
        if (abstractVillager instanceof VillagerDataHolder) {
            VillagerDataHolder v = (VillagerDataHolder)abstractVillager;
            return v.getVillagerData().getLevel();
        }
        return -1;
    }

    public VillagerProfession getProfession() {
        AbstractVillager abstractVillager = this.villager;
        if (abstractVillager instanceof VillagerDataHolder) {
            VillagerDataHolder v = (VillagerDataHolder)abstractVillager;
            return v.getVillagerData().getProfession();
        }
        return VillagerProfession.NONE;
    }

    public boolean isVillager() {
        return this.villager instanceof Villager;
    }

    public boolean isWanderer() {
        return this.villager instanceof WanderingTrader;
    }

    public boolean isUnknownTrader() {
        return !this.isVillager() && !this.isWanderer();
    }

    public MerchantOffers getAllOffers() {
        return this.allOffers;
    }

    @Nullable
    public MerchantOffer createRandomOffer(List<VillagerTrades.ItemListing> possibleTrades) {
        if (possibleTrades.isEmpty()) {
            return null;
        }
        int i = this.getLevel().getRandom().nextInt(possibleTrades.size());
        VillagerTrades.ItemListing randomListing = possibleTrades.get(i);
        return randomListing.getOffer((Entity)this.getEntity(), this.getLevel().getRandom());
    }

    public List<VillagerTrades.ItemListing> getVillagerTrades(VillagerProfession profession) {
        return VillagerUtils.getVillagerTrades(profession);
    }

    public List<VillagerTrades.ItemListing> getVillagerTrades(VillagerProfession profession, int level) {
        return VillagerUtils.getVillagerTrades(profession, level);
    }

    public List<VillagerTrades.ItemListing> getWandererTrades() {
        if (this.cachedWandererTrades == null) {
            this.cachedWandererTrades = new ArrayList<VillagerTrades.ItemListing>();
            for (VillagerTrades.ItemListing[] listings : VillagerTrades.WANDERING_TRADER_TRADES.values()) {
                this.cachedWandererTrades.addAll(Arrays.asList(listings));
            }
        }
        return this.cachedWandererTrades;
    }

    public List<VillagerTrades.ItemListing> getWandererTrades(int level) {
        return VillagerUtils.getWandererTrades(level);
    }
}

