/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.mixin.structure;

import com.almostreliable.morejs.features.structure.StructureBlockInfoModification;
import com.almostreliable.morejs.util.Utils;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={StructureTemplate.StructureBlockInfo.class})
public class StructureBlockInfoMixin
implements StructureBlockInfoModification {
    @Mutable
    @Shadow
    @Final
    private CompoundTag nbt;
    @Mutable
    @Shadow
    @Final
    private BlockState state;
    @Shadow
    @Final
    public BlockPos pos;

    @Override
    public String getId() {
        return BuiltInRegistries.BLOCK.getKey((Object)this.state.getBlock()).toString();
    }

    @Override
    public Block getBlock() {
        return this.state.getBlock();
    }

    @Override
    public void setBlock(ResourceLocation id) {
        Block block = (Block)BuiltInRegistries.BLOCK.getOptional(id).orElseThrow(() -> new IllegalArgumentException("Block not found: " + String.valueOf(id)));
        this.state = block.defaultBlockState();
    }

    @Override
    public void setBlock(ResourceLocation id, Map<String, Object> properties) {
        this.setBlock(id);
        if (properties.isEmpty()) {
            return;
        }
        this.state = this.getBlock().defaultBlockState();
        for (Property property : this.state.getProperties()) {
            Object newValue = properties.get(property.getName());
            if (newValue == null) continue;
            try {
                this.state = (BlockState)this.state.setValue(property, (Comparable)Utils.cast(newValue));
            }
            catch (Exception ignored) {
                property.getValue(newValue.toString()).ifPresent(v -> {
                    this.state = (BlockState)this.state.setValue(property, (Comparable)Utils.cast(v));
                });
            }
        }
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (Property property : this.state.getProperties()) {
            Comparable value = this.state.getValue(property);
            properties.put(property.getName(), value);
        }
        return properties;
    }

    @Override
    public boolean hasNbt() {
        return this.nbt != null;
    }

    @Override
    @Nullable
    public CompoundTag getNbt() {
        return this.nbt;
    }

    @Override
    public void setNbt(@Nullable CompoundTag nbt) {
        this.nbt = nbt;
    }

    @Override
    public BlockPos getPosition() {
        return this.pos;
    }

    @Override
    @HideFromJS
    public void setVanillaBlockState(BlockState state) {
        this.state = state;
    }
}

