/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.block;

import com.calemi.nexus.block.entity.NexusPortalCoreBlockEntity;
import com.calemi.nexus.client.model.NexusPortalCoreBakedModel;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCamoBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;

    public AbstractCamoBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public abstract Optional<BlockState> getCamoState(BlockGetter var1, BlockPos var2);

    public abstract Optional<NexusPortalCoreBlockEntity> getPortalCore(BlockGetter var1, BlockPos var2);

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        if (level instanceof ServerLevel) {
            return this.getCamoState((BlockGetter)level, pos).map(s -> s.getAppearance(level, pos, side, queryState, queryPos)).orElse(super.getAppearance(state, level, pos, side, queryState, queryPos));
        }
        ModelData data = level.getModelData(pos);
        if (data == ModelData.EMPTY) {
            return super.getAppearance(state, level, pos, side, queryState, queryPos);
        }
        BlockState heldState = (BlockState)data.get(NexusPortalCoreBakedModel.CAMO_STATE);
        if (heldState == null) {
            return super.getAppearance(state, level, pos, side, queryState, queryPos);
        }
        return heldState.getAppearance(level, pos, side, queryState, queryPos);
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    protected int getLightBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoState(level, pos).map(s -> s.getLightBlock(level, pos)).orElse(level.getMaxLightLevel());
    }

    protected float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoState(level, pos).map(s -> Float.valueOf(s.getShadeBrightness(level, pos))).orElse(Float.valueOf(super.getShadeBrightness(state, level, pos))).floatValue();
    }

    public boolean collisionExtendsVertically(BlockState state, BlockGetter level, BlockPos pos, Entity collidingEntity) {
        return this.getCamoState(level, pos).map(s -> s.collisionExtendsVertically(level, pos, collidingEntity)).orElse(super.collisionExtendsVertically(state, level, pos, collidingEntity));
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        return this.getCamoState((BlockGetter)level, pos).map(s -> Float.valueOf(s.getFriction(level, pos, entity))).orElse(Float.valueOf(super.getFriction(state, level, pos, entity))).floatValue();
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean hasDynamicLightEmission(BlockState state) {
        return true;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return Optional.ofNullable(level.getAuxLightManager(pos)).map(lm -> lm.getLightAt(pos)).orElse(0);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        return this.getCamoState((BlockGetter)level, pos).map(s -> s.getSoundType(level, pos, entity)).orElse(super.getSoundType(state, level, pos, entity));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        BlockState placedOnState = context.getLevel().getBlockState(context.getClickedPos().relative(direction.getOpposite()));
        BlockState placedState = (BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)context.getHorizontalDirection().getClockWise().getAxis());
        return placedOnState.is((Block)this) && placedOnState.getValue((Property)FACING) == direction ? (BlockState)placedState.setValue((Property)FACING, (Comparable)direction.getOpposite()) : (BlockState)placedState.setValue((Property)FACING, (Comparable)direction);
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, AXIS});
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected boolean triggerEvent(BlockState state, Level level, BlockPos pos, int id, int param) {
        super.triggerEvent(state, level, pos, id, param);
        BlockEntity blockentity = level.getBlockEntity(pos);
        return blockentity != null && blockentity.triggerEvent(id, param);
    }
}

