/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.block;

import com.calemi.ccore.api.location.BlockLocation;
import com.calemi.nexus.block.NexusPortalBlock;
import com.calemi.nexus.block.entity.NexusPortalBlockEntity;
import com.calemi.nexus.block.entity.NexusPortalCoreBlockEntity;
import com.calemi.nexus.main.Nexus;
import com.calemi.nexus.util.scanner.PortalScanner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;

public class DyeNexusPortalBlockAction {
    @SubscribeEvent
    public void useItemOnBlockEvent(UseItemOnBlockEvent event) {
        if (event.getUsePhase() == UseItemOnBlockEvent.UsePhase.ITEM_BEFORE_BLOCK) {
            BlockEntity blockEntity;
            Level level = event.getLevel();
            if (event.getLevel().isClientSide()) {
                return;
            }
            BlockPos pos = event.getPos();
            BlockState state = level.getBlockState(pos);
            if (!(state.getBlock() instanceof NexusPortalBlock)) {
                return;
            }
            Player player = event.getPlayer();
            if (player == null) {
                return;
            }
            ItemStack stack = event.getItemStack();
            Item item = stack.getItem();
            if (!(item instanceof DyeItem)) {
                return;
            }
            DyeItem dyeItem = (DyeItem)item;
            Block dyedPortalBlock = NexusPortalBlock.fromDye(dyeItem.getDyeColor());
            if (dyedPortalBlock != null && !state.getBlock().equals(dyedPortalBlock)) {
                if (player.isCrouching()) {
                    this.dyePortalBlock(dyedPortalBlock, pos, state, level);
                } else {
                    PortalScanner scanner = new PortalScanner(new BlockLocation(level, pos), (Direction.Axis)state.getValue(NexusPortalBlock.AXIS), false, 1000);
                    scanner.start();
                    scanner.getCollectedPositions().forEach(blockPos -> this.dyePortalBlock(dyedPortalBlock, (BlockPos)blockPos, state, level));
                }
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                event.cancelWithResult(ItemInteractionResult.SUCCESS);
            }
            if (!((blockEntity = level.getBlockEntity(pos)) instanceof NexusPortalBlockEntity)) {
                return;
            }
            NexusPortalBlockEntity portalBlockEntity = (NexusPortalBlockEntity)blockEntity;
            BlockEntity blockEntity2 = level.getBlockEntity(portalBlockEntity.getCorePosition());
            if (!(blockEntity2 instanceof NexusPortalCoreBlockEntity)) {
                return;
            }
            NexusPortalCoreBlockEntity portalCoreBlockEntity = (NexusPortalCoreBlockEntity)blockEntity2;
            portalCoreBlockEntity.savePortalColorPattern(portalCoreBlockEntity.getPortalPositions());
            Nexus.LOGGER.debug("SAVING PATTERN");
        }
    }

    private void dyePortalBlock(Block dyedPortalBlock, BlockPos pos, BlockState originalState, Level level) {
        CompoundTag tag = level.getBlockEntity(pos).saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
        level.setBlock(pos, (BlockState)dyedPortalBlock.defaultBlockState().setValue(NexusPortalBlock.AXIS, (Comparable)((Direction.Axis)originalState.getValue(NexusPortalBlock.AXIS))), 3);
        level.getBlockEntity(pos).loadCustomOnly(tag, (HolderLookup.Provider)level.registryAccess());
    }
}

