/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.block;

import com.calemi.nexus.block.AcceleriteOreBlock;
import com.calemi.nexus.block.BuddingChronoBlock;
import com.calemi.nexus.block.ChargedAcceleriteBlock;
import com.calemi.nexus.block.ChronowarpedGrassBlock;
import com.calemi.nexus.block.JumpPadBlock;
import com.calemi.nexus.block.NexusPortalBlock;
import com.calemi.nexus.block.NexusPortalCoreBlock;
import com.calemi.nexus.block.RoadBlock;
import com.calemi.nexus.block.RoadSlabBlock;
import com.calemi.nexus.block.WarpblossomLeavesBlock;
import com.calemi.nexus.block.WarpslateBlock;
import com.calemi.nexus.block.family.NexusBlockSetTypes;
import com.calemi.nexus.block.wood.NexusWoodTypes;
import com.calemi.nexus.client.partclie.NexusParticles;
import com.calemi.nexus.config.NexusConfig;
import com.calemi.nexus.item.NexusItems;
import com.calemi.nexus.main.Nexus;
import com.calemi.nexus.main.NexusRef;
import com.calemi.nexus.world.feature.tree.NexusTreeGrowers;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ColorRGBA;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.ColoredFallingBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.PinkPetalsBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NexusBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"nexus");
    public static final DeferredBlock<Block> NEXUS_PORTAL_CORE = NexusBlocks.regBlock("nexus_portal_core", () -> new NexusPortalCoreBlock(NexusConfig.server.nexusPortalCoreCoordinateScale));
    public static final DeferredBlock<Block> IRON_NEXUS_PORTAL_CORE = NexusBlocks.regBlock("iron_nexus_portal_core", () -> new NexusPortalCoreBlock(NexusConfig.server.ironPortalCoreCoordinateScale));
    public static final DeferredBlock<Block> GOLD_NEXUS_PORTAL_CORE = NexusBlocks.regBlock("gold_nexus_portal_core", () -> new NexusPortalCoreBlock(NexusConfig.server.goldPortalCoreCoordinateScale));
    public static final DeferredBlock<Block> DIAMOND_NEXUS_PORTAL_CORE = NexusBlocks.regBlock("diamond_nexus_portal_core", () -> new NexusPortalCoreBlock(NexusConfig.server.diamondPortalCoreCoordinateScale));
    public static final DeferredBlock<Block> NETHERITE_NEXUS_PORTAL_CORE = NexusBlocks.regBlock("netherite_nexus_portal_core", () -> new NexusPortalCoreBlock(NexusConfig.server.netheritePortalCoreCoordinateScale));
    public static final DeferredBlock<Block> STARLIGHT_NEXUS_PORTAL_CORE = NexusBlocks.regBlock("starlight_nexus_portal_core", () -> new NexusPortalCoreBlock(NexusConfig.server.starlightPortalCoreCoordinateScale));
    public static final DeferredBlock<Block> WHITE_NEXUS_PORTAL = NexusBlocks.regBlockSolo("white_nexus_portal", () -> new NexusPortalBlock(DyeColor.WHITE, NexusParticles.WHITE_PORTAL_PARTICLES));
    public static final DeferredBlock<Block> ORANGE_NEXUS_PORTAL = NexusBlocks.regBlockSolo("orange_nexus_portal", () -> new NexusPortalBlock(DyeColor.ORANGE, NexusParticles.ORANGE_PORTAL_PARTICLES));
    public static final DeferredBlock<Block> MAGENTA_NEXUS_PORTAL = NexusBlocks.regBlockSolo("magenta_nexus_portal", () -> new NexusPortalBlock(DyeColor.MAGENTA, NexusParticles.MAGENTA_PORTAL_PARTICLES));
    public static final DeferredBlock<Block> LIGHT_BLUE_NEXUS_PORTAL = NexusBlocks.regBlockSolo("light_blue_nexus_portal", () -> new NexusPortalBlock(DyeColor.LIGHT_BLUE, NexusParticles.LIGHT_BLUE_PORTAL_PARTICLES));
    public static final DeferredBlock<Block> YELLOW_NEXUS_PORTAL = NexusBlocks.regBlockSolo("yellow_nexus_portal", () -> new NexusPortalBlock(DyeColor.YELLOW, NexusParticles.YELLOW_PORTAL_PARTICLES));
    public static final DeferredBlock<Block> LIME_NEXUS_PORTAL = NexusBlocks.regBlockSolo("lime_nexus_portal", () -> new NexusPortalBlock(DyeColor.LIME, NexusParticles.LIME_PORTAL_PARTICLES));
    public static final DeferredBlock<Block> PINK_NEXUS_PORTAL = NexusBlocks.regBlockSolo("pink_nexus_portal", () -> new NexusPortalBlock(DyeColor.PINK, NexusParticles.PINK_PORTAL_PARTICLES));
    public static final DeferredBlock<Block> GRAY_NEXUS_PORTAL = NexusBlocks.regBlockSolo("gray_nexus_portal", () -> new NexusPortalBlock(DyeColor.GRAY, NexusParticles.GRAY_PORTAL_PARTICLES));
    public static final DeferredBlock<Block> LIGHT_GRAY_NEXUS_PORTAL = NexusBlocks.regBlockSolo("light_gray_nexus_portal", () -> new NexusPortalBlock(DyeColor.LIGHT_GRAY, NexusParticles.LIGHT_GRAY_PORTAL_PARTICLES));
    public static final DeferredBlock<Block> CYAN_NEXUS_PORTAL = NexusBlocks.regBlockSolo("cyan_nexus_portal", () -> new NexusPortalBlock(DyeColor.CYAN, NexusParticles.CYAN_PORTAL_PARTICLES));
    public static final DeferredBlock<Block> PURPLE_NEXUS_PORTAL = NexusBlocks.regBlockSolo("purple_nexus_portal", () -> new NexusPortalBlock(DyeColor.PURPLE, NexusParticles.PURPLE_PORTAL_PARTICLES));
    public static final DeferredBlock<Block> BLUE_NEXUS_PORTAL = NexusBlocks.regBlockSolo("blue_nexus_portal", () -> new NexusPortalBlock(DyeColor.BLUE, NexusParticles.BLUE_PORTAL_PARTICLES));
    public static final DeferredBlock<Block> BROWN_NEXUS_PORTAL = NexusBlocks.regBlockSolo("brown_nexus_portal", () -> new NexusPortalBlock(DyeColor.BROWN, NexusParticles.BROWN_PORTAL_PARTICLES));
    public static final DeferredBlock<Block> GREEN_NEXUS_PORTAL = NexusBlocks.regBlockSolo("green_nexus_portal", () -> new NexusPortalBlock(DyeColor.GREEN, NexusParticles.GREEN_PORTAL_PARTICLES));
    public static final DeferredBlock<Block> RED_NEXUS_PORTAL = NexusBlocks.regBlockSolo("red_nexus_portal", () -> new NexusPortalBlock(DyeColor.RED, NexusParticles.RED_PORTAL_PARTICLES));
    public static final DeferredBlock<Block> BLACK_NEXUS_PORTAL = NexusBlocks.regBlockSolo("black_nexus_portal", () -> new NexusPortalBlock(DyeColor.BLACK, NexusParticles.BLACK_PORTAL_PARTICLES));
    public static final DeferredBlock<Block> ROAD = NexusBlocks.regBlock("road", () -> new RoadBlock(BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).sound(SoundType.COPPER).strength(1.0f, 6.0f)));
    public static final DeferredBlock<Block> ROAD_SLAB = NexusBlocks.regBlock("road_slab", () -> new RoadSlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)ROAD.get()))));
    public static final DeferredBlock<Block> JUMP_PAD = NexusBlocks.regBlock("jump_pad", () -> new JumpPadBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)ROAD.get()))));
    public static final DeferredBlock<Block> CHRONOWARPED_GRASS = NexusBlocks.regBlock("chronowarped_grass", ChronowarpedGrassBlock::new);
    public static final DeferredBlock<Block> CHRONOWARPED_DIRT = NexusBlocks.regBlock("chronowarped_dirt", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).mapColor(MapColor.TERRACOTTA_BLUE)));
    public static final DeferredBlock<Block> CHRONOWARPED_SAND = NexusBlocks.regBlock("chronowarped_sand", () -> new ColoredFallingBlock(new ColorRGBA(5324121), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SAND).mapColor(MapColor.TERRACOTTA_BLUE)));
    public static final DeferredBlock<Block> CHRONO_BLOCK = NexusBlocks.regBlock("chrono_block", () -> new AmethystBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK)));
    public static final DeferredBlock<Block> BUDDING_CHRONO = NexusBlocks.regBlock("budding_chrono", () -> new BuddingChronoBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BUDDING_AMETHYST)));
    public static final DeferredBlock<Block> SMALL_CHRONO_BUD = NexusBlocks.regBlock("small_chrono_bud", () -> new AmethystClusterBlock(3.0f, 4.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SMALL_AMETHYST_BUD).lightLevel(state -> 2)));
    public static final DeferredBlock<Block> MEDIUM_CHRONO_BUD = NexusBlocks.regBlock("medium_chrono_bud", () -> new AmethystClusterBlock(4.0f, 3.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MEDIUM_AMETHYST_BUD).lightLevel(state -> 4)));
    public static final DeferredBlock<Block> LARGE_CHRONO_BUD = NexusBlocks.regBlock("large_chrono_bud", () -> new AmethystClusterBlock(5.0f, 3.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LARGE_AMETHYST_BUD).lightLevel(state -> 6)));
    public static final DeferredBlock<Block> CHRONO_CLUSTER = NexusBlocks.regBlock("chrono_cluster", () -> new AmethystClusterBlock(7.0f, 3.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_CLUSTER).lightLevel(state -> 8)));
    public static final DeferredBlock<Block> POLISHED_CALCITE = NexusBlocks.regBlock("polished_calcite", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CALCITE)));
    public static final DeferredBlock<Block> POLISHED_CALCITE_STAIRS = NexusBlocks.regBlock("polished_calcite_stairs", () -> NexusBlocks.stair((Block)POLISHED_CALCITE.get()));
    public static final DeferredBlock<Block> POLISHED_CALCITE_SLAB = NexusBlocks.regBlock("polished_calcite_slab", () -> NexusBlocks.slab((Block)POLISHED_CALCITE.get()));
    public static final DeferredBlock<Block> POLISHED_CALCITE_WALL = NexusBlocks.regBlock("polished_calcite_wall", () -> NexusBlocks.wall((Block)POLISHED_CALCITE.get()));
    public static final DeferredBlock<Block> CALCITE_PILLAR = NexusBlocks.regBlock("calcite_pillar", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)POLISHED_CALCITE.get()))));
    public static final DeferredBlock<Block> CHISELED_CALCITE = NexusBlocks.regBlock("chiseled_calcite", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CALCITE)));
    public static final DeferredBlock<Block> CALCITE_BRICKS = NexusBlocks.regBlock("calcite_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)POLISHED_CALCITE.get()))));
    public static final DeferredBlock<Block> CRACKED_CALCITE_BRICKS = NexusBlocks.regBlock("cracked_calcite_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CALCITE_BRICKS.get()))));
    public static final DeferredBlock<Block> CALCITE_BRICK_STAIRS = NexusBlocks.regBlock("calcite_brick_stairs", () -> NexusBlocks.stair((Block)CALCITE_BRICKS.get()));
    public static final DeferredBlock<Block> CALCITE_BRICK_SLAB = NexusBlocks.regBlock("calcite_brick_slab", () -> NexusBlocks.slab((Block)CALCITE_BRICKS.get()));
    public static final DeferredBlock<Block> CALCITE_BRICK_WALL = NexusBlocks.regBlock("calcite_brick_wall", () -> NexusBlocks.wall((Block)CALCITE_BRICKS.get()));
    public static final DeferredBlock<Block> CALCITE_TILES = NexusBlocks.regBlock("calcite_tiles", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CALCITE_BRICKS.get()))));
    public static final DeferredBlock<Block> CRACKED_CALCITE_TILES = NexusBlocks.regBlock("cracked_calcite_tiles", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CALCITE_TILES.get()))));
    public static final DeferredBlock<Block> CALCITE_TILE_STAIRS = NexusBlocks.regBlock("calcite_tile_stairs", () -> NexusBlocks.stair((Block)CALCITE_TILES.get()));
    public static final DeferredBlock<Block> CALCITE_TILE_SLAB = NexusBlocks.regBlock("calcite_tile_slab", () -> NexusBlocks.slab((Block)CALCITE_TILES.get()));
    public static final DeferredBlock<Block> CALCITE_TILE_WALL = NexusBlocks.regBlock("calcite_tile_wall", () -> NexusBlocks.wall((Block)CALCITE_TILES.get()));
    public static final DeferredBlock<Block> WARPSLATE = NexusBlocks.regBlock("warpslate", () -> new WarpslateBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE).strength(1.25f, 6.0f).mapColor(MapColor.TERRACOTTA_CYAN)));
    public static final DeferredBlock<Block> COBBLED_WARPSLATE = NexusBlocks.regBlock("cobbled_warpslate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLED_DEEPSLATE).strength(1.75f, 6.0f).mapColor(MapColor.TERRACOTTA_CYAN)));
    public static final DeferredBlock<Block> COBBLED_WARPSLATE_STAIRS = NexusBlocks.regBlock("cobbled_warpslate_stairs", () -> NexusBlocks.stair((Block)COBBLED_WARPSLATE.get()));
    public static final DeferredBlock<Block> COBBLED_WARPSLATE_SLAB = NexusBlocks.regBlock("cobbled_warpslate_slab", () -> NexusBlocks.slab((Block)COBBLED_WARPSLATE.get()));
    public static final DeferredBlock<Block> COBBLED_WARPSLATE_WALL = NexusBlocks.regBlock("cobbled_warpslate_wall", () -> NexusBlocks.wall((Block)COBBLED_WARPSLATE.get()));
    public static final DeferredBlock<Block> CHISELED_WARPSLATE = NexusBlocks.regBlock("chiseled_warpslate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)COBBLED_WARPSLATE.get())).sound(SoundType.DEEPSLATE_BRICKS)));
    public static final DeferredBlock<Block> POLISHED_WARPSLATE = NexusBlocks.regBlock("polished_warpslate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)COBBLED_WARPSLATE.get())).sound(SoundType.POLISHED_DEEPSLATE)));
    public static final DeferredBlock<Block> POLISHED_WARPSLATE_STAIRS = NexusBlocks.regBlock("polished_warpslate_stairs", () -> NexusBlocks.stair((Block)POLISHED_WARPSLATE.get()));
    public static final DeferredBlock<Block> POLISHED_WARPSLATE_SLAB = NexusBlocks.regBlock("polished_warpslate_slab", () -> NexusBlocks.slab((Block)POLISHED_WARPSLATE.get()));
    public static final DeferredBlock<Block> POLISHED_WARPSLATE_WALL = NexusBlocks.regBlock("polished_warpslate_wall", () -> NexusBlocks.wall((Block)POLISHED_WARPSLATE.get()));
    public static final DeferredBlock<Block> WARPSLATE_BRICKS = NexusBlocks.regBlock("warpslate_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)COBBLED_WARPSLATE.get())).sound(SoundType.DEEPSLATE_TILES)));
    public static final DeferredBlock<Block> CRACKED_WARPSLATE_BRICKS = NexusBlocks.regBlock("cracked_warpslate_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)WARPSLATE_BRICKS.get()))));
    public static final DeferredBlock<Block> WARPSLATE_BRICK_STAIRS = NexusBlocks.regBlock("warpslate_brick_stairs", () -> NexusBlocks.stair((Block)POLISHED_WARPSLATE.get()));
    public static final DeferredBlock<Block> WARPSLATE_BRICK_SLAB = NexusBlocks.regBlock("warpslate_brick_slab", () -> NexusBlocks.slab((Block)POLISHED_WARPSLATE.get()));
    public static final DeferredBlock<Block> WARPSLATE_BRICK_WALL = NexusBlocks.regBlock("warpslate_brick_wall", () -> NexusBlocks.wall((Block)POLISHED_WARPSLATE.get()));
    public static final DeferredBlock<Block> WARPSLATE_TILES = NexusBlocks.regBlock("warpslate_tiles", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)COBBLED_WARPSLATE.get())).sound(SoundType.DEEPSLATE_TILES)));
    public static final DeferredBlock<Block> CRACKED_WARPSLATE_TILES = NexusBlocks.regBlock("cracked_warpslate_tiles", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)WARPSLATE_TILES.get()))));
    public static final DeferredBlock<Block> WARPSLATE_TILE_STAIRS = NexusBlocks.regBlock("warpslate_tile_stairs", () -> NexusBlocks.stair((Block)POLISHED_WARPSLATE.get()));
    public static final DeferredBlock<Block> WARPSLATE_TILE_SLAB = NexusBlocks.regBlock("warpslate_tile_slab", () -> NexusBlocks.slab((Block)POLISHED_WARPSLATE.get()));
    public static final DeferredBlock<Block> WARPSLATE_TILE_WALL = NexusBlocks.regBlock("warpslate_tile_wall", () -> NexusBlocks.wall((Block)POLISHED_WARPSLATE.get()));
    public static final DeferredBlock<Block> WARPSLATE_ACCELERITE_ORE = NexusBlocks.regBlock("warpslate_accelerite_ore", () -> new AcceleriteOreBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)WARPSLATE.get())).requiresCorrectToolForDrops().lightLevel(state -> 9)));
    public static final DeferredBlock<Block> RAW_ACCELERITE_BLOCK = NexusBlocks.regBlock("raw_accelerite_block", () -> new ChargedAcceleriteBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RAW_GOLD_BLOCK).requiresCorrectToolForDrops().lightLevel(state -> 9)));
    public static final DeferredBlock<Block> DORMANT_ACCELERITE_BLOCK = NexusBlocks.regBlock("dormant_accelerite_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GOLD_BLOCK).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> CHARGED_ACCELERITE_BLOCK = NexusBlocks.regBlock("charged_accelerite_block", () -> new ChargedAcceleriteBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DORMANT_ACCELERITE_BLOCK.get())).requiresCorrectToolForDrops().lightLevel(state -> 9)));
    public static final DeferredBlock<Block> WARPBLOSSOM_LOG = NexusBlocks.regBlock("warpblossom_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG)));
    public static final DeferredBlock<Block> WARPBLOSSOM_WOOD = NexusBlocks.regBlock("warpblossom_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD)));
    public static final DeferredBlock<Block> STRIPPED_WARPBLOSSOM_LOG = NexusBlocks.regBlock("stripped_warpblossom_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG)));
    public static final DeferredBlock<Block> STRIPPED_WARPBLOSSOM_WOOD = NexusBlocks.regBlock("stripped_warpblossom_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_WOOD)));
    public static final DeferredBlock<Block> WARPBLOSSOM_LEAVES = NexusBlocks.regBlock("warpblossom_leaves", WarpblossomLeavesBlock::new);
    public static final DeferredBlock<Block> WARPBLOSSOM_SAPLING = NexusBlocks.regBlock("warpblossom_sapling", () -> new SaplingBlock(NexusTreeGrowers.WARPBLOSSOM, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_SAPLING)));
    public static final DeferredBlock<Block> POTTED_WARPBLOSSOM_SAPLING = NexusBlocks.regBlock("potted_warpblossom_sapling", () -> NexusBlocks.flowerPot((Block)WARPBLOSSOM_SAPLING.get()));
    public static final DeferredBlock<Block> PURPLE_PETALS = NexusBlocks.regBlock("purple_petals", () -> new PinkPetalsBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PINK_PETALS)));
    public static final DeferredBlock<Block> WARPBLOSSOM_PLANKS = NexusBlocks.regBlock("warpblossom_planks", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_PLANKS)));
    public static final DeferredBlock<Block> WARPBLOSSOM_STAIRS = NexusBlocks.regBlock("warpblossom_stairs", () -> NexusBlocks.stair((Block)WARPBLOSSOM_PLANKS.get()));
    public static final DeferredBlock<Block> WARPBLOSSOM_SLAB = NexusBlocks.regBlock("warpblossom_slab", () -> NexusBlocks.slab((Block)WARPBLOSSOM_PLANKS.get()));
    public static final DeferredBlock<Block> WARPBLOSSOM_FENCE = NexusBlocks.regBlock("warpblossom_fence", () -> NexusBlocks.fence((Block)WARPBLOSSOM_PLANKS.get()));
    public static final DeferredBlock<Block> WARPBLOSSOM_FENCE_GATE = NexusBlocks.regBlock("warpblossom_fence_gate", () -> NexusBlocks.fenceGate((Block)WARPBLOSSOM_PLANKS.get(), NexusWoodTypes.WARPBLOSSOM));
    public static final DeferredBlock<Block> WARPBLOSSOM_DOOR = NexusBlocks.regBlockSolo("warpblossom_door", () -> NexusBlocks.door((Block)WARPBLOSSOM_PLANKS.get(), NexusBlockSetTypes.WARPBLOSSOM));
    public static final DeferredBlock<Block> WARPBLOSSOM_TRAPDOOR = NexusBlocks.regBlock("warpblossom_trapdoor", () -> NexusBlocks.trapdoor((Block)WARPBLOSSOM_PLANKS.get(), NexusBlockSetTypes.WARPBLOSSOM));
    public static final DeferredBlock<Block> WARPBLOSSOM_PRESSURE_PLATE = NexusBlocks.regBlock("warpblossom_pressure_plate", () -> NexusBlocks.pressurePlate((Block)WARPBLOSSOM_PLANKS.get(), NexusBlockSetTypes.WARPBLOSSOM));
    public static final DeferredBlock<Block> WARPBLOSSOM_BUTTON = NexusBlocks.regBlock("warpblossom_button", () -> NexusBlocks.button((Block)WARPBLOSSOM_PLANKS.get(), 30, NexusBlockSetTypes.WARPBLOSSOM));
    public static final DeferredBlock<Block> WARPBLOSSOM_SIGN = NexusBlocks.regBlockSolo("warpblossom_sign", () -> NexusBlocks.sign((Block)WARPBLOSSOM_PLANKS.get(), NexusWoodTypes.WARPBLOSSOM));
    public static final DeferredBlock<Block> WARPBLOSSOM_WALL_SIGN = NexusBlocks.regBlockSolo("warpblossom_wall_sign", () -> NexusBlocks.wallSign((Block)WARPBLOSSOM_PLANKS.get(), (Block)WARPBLOSSOM_SIGN.get(), NexusWoodTypes.WARPBLOSSOM));
    public static final DeferredBlock<Block> WARPBLOSSOM_HANGING_SIGN = NexusBlocks.regBlockSolo("warpblossom_hanging_sign", () -> NexusBlocks.hangingSign((Block)WARPBLOSSOM_PLANKS.get(), NexusWoodTypes.WARPBLOSSOM));
    public static final DeferredBlock<Block> WARPBLOSSOM_WALL_HANGING_SIGN = NexusBlocks.regBlockSolo("warpblossom_wall_hanging_sign", () -> NexusBlocks.wallHangingSign((Block)WARPBLOSSOM_PLANKS.get(), (Block)WARPBLOSSOM_HANGING_SIGN.get(), NexusWoodTypes.WARPBLOSSOM));

    private static DeferredBlock<Block> regBlock(String name, Supplier<Block> supplier) {
        DeferredBlock registeredBlock = BLOCKS.register(name, supplier);
        NexusItems.ITEMS.register(name, () -> new BlockItem((Block)registeredBlock.get(), new Item.Properties()));
        return registeredBlock;
    }

    private static DeferredBlock<Block> regBlockSolo(String name, Supplier<Block> supplier) {
        return BLOCKS.register(name, supplier);
    }

    private static Block stair(Block baseBlock) {
        return new StairBlock(baseBlock.defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock));
    }

    private static Block slab(Block baseBlock) {
        return new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock));
    }

    private static Block wall(Block baseBlock) {
        return new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock).forceSolidOn());
    }

    private static Block fence(Block baseBlock) {
        return new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock).forceSolidOn());
    }

    private static Block fenceGate(Block baseBlock, WoodType woodType) {
        return new FenceGateBlock(woodType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock).forceSolidOn());
    }

    private static Block door(Block baseBlock, BlockSetType blockSetType) {
        return new DoorBlock(blockSetType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock).strength(3.0f).noOcclusion().pushReaction(PushReaction.DESTROY));
    }

    private static Block trapdoor(Block baseBlock, BlockSetType blockSetType) {
        return new TrapDoorBlock(blockSetType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock).strength(3.0f).noOcclusion().isValidSpawn(Blocks::never));
    }

    private static Block pressurePlate(Block baseBlock, BlockSetType blockSetType) {
        return new PressurePlateBlock(blockSetType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock).strength(0.5f).noCollission().forceSolidOn().pushReaction(PushReaction.DESTROY));
    }

    private static Block button(Block baseBlock, int ticksToStayPressed, BlockSetType blockSetType) {
        return new ButtonBlock(blockSetType, ticksToStayPressed, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock).strength(0.5f).noCollission().pushReaction(PushReaction.DESTROY));
    }

    private static Block sign(Block baseBlock, WoodType woodType) {
        return new StandingSignBlock(woodType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock).strength(1.0f).noCollission().forceSolidOn());
    }

    private static Block wallSign(Block baseBlock, Block standingSign, WoodType woodType) {
        return new WallSignBlock(woodType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock).strength(1.0f).dropsLike(standingSign).noCollission().forceSolidOn());
    }

    private static Block hangingSign(Block baseBlock, WoodType woodType) {
        return new CeilingHangingSignBlock(woodType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock).strength(1.0f).noCollission().forceSolidOn());
    }

    private static Block wallHangingSign(Block baseBlock, Block ceilingSign, WoodType woodType) {
        return new WallHangingSignBlock(woodType, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)baseBlock).strength(1.0f).dropsLike(ceilingSign).noCollission().forceSolidOn());
    }

    private static Block flowerPot(Block plant) {
        return new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, () -> plant, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT));
    }

    public static void init() {
        Nexus.LOGGER.info("Registering: Blocks - Start");
        BLOCKS.register(Nexus.MOD_EVENT_BUS);
        ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(NexusRef.rl("warpblossom_sapling"), POTTED_WARPBLOSSOM_SAPLING);
        Nexus.LOGGER.debug((Object)BuiltInRegistries.BLOCK.wrapAsHolder((Object)Blocks.CALCITE));
        Nexus.LOGGER.info("Registering: Blocks - End");
    }
}

