/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.block;

import com.calemi.nexus.block.entity.NexusPortalBlockEntity;
import com.calemi.nexus.block.entity.NexusPortalCoreBlockEntity;
import com.calemi.nexus.client.partclie.NexusParticles;
import com.calemi.nexus.config.NexusConfig;
import com.calemi.nexus.util.NexusLists;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.registries.DeferredHolder;

public class NexusPortalBlock
extends BaseEntityBlock
implements Portal {
    public static final MapCodec<NexusPortalBlock> CODEC = NexusPortalBlock.simpleCodec(NexusPortalBlock::new);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    protected static final int AABB_OFFSET = 2;
    protected static final VoxelShape X_AXIS_AABB = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    protected static final VoxelShape Y_AXIS_AABB = Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    private final DyeColor color;
    private final DeferredHolder<ParticleType<?>, SimpleParticleType> particleType;

    public NexusPortalBlock(DyeColor color, DeferredHolder<ParticleType<?>, SimpleParticleType> particleType) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHER_PORTAL).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.X));
        this.color = color;
        this.particleType = particleType;
    }

    public NexusPortalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.color = DyeColor.WHITE;
        this.particleType = NexusParticles.WHITE_PORTAL_PARTICLES;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public static Block fromDye(DyeColor color) {
        return NexusLists.NEXUS_PORTAL_BLOCKS.stream().map(block -> (NexusPortalBlock)((Object)block)).filter(block -> block.getColor() == color).findFirst().orElse(null);
    }

    public static NexusPortalCoreBlockEntity getPortalCore(Level level, BlockPos pos) {
        BlockEntity blockEntity;
        NexusPortalBlockEntity portalBlockEntity;
        BlockPos corePosition;
        BlockEntity blockEntity2 = level.getBlockEntity(pos);
        if (blockEntity2 instanceof NexusPortalBlockEntity && (corePosition = (portalBlockEntity = (NexusPortalBlockEntity)blockEntity2).getCorePosition()) != null && (blockEntity = level.getBlockEntity(corePosition)) instanceof NexusPortalCoreBlockEntity) {
            NexusPortalCoreBlockEntity coreBlockEntity = (NexusPortalCoreBlockEntity)blockEntity;
            return coreBlockEntity;
        }
        return null;
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity.canUsePortal(false)) {
            entity.setAsInsidePortal((Portal)this, pos);
        }
    }

    @Nullable
    public DimensionTransition getPortalDestination(ServerLevel level, Entity entity, BlockPos pos) {
        NexusPortalCoreBlockEntity coreBlockEntity = NexusPortalBlock.getPortalCore((Level)level, pos);
        if (coreBlockEntity == null) {
            return null;
        }
        coreBlockEntity.teleportEntity(entity);
        return null;
    }

    public Portal.Transition getLocalTransition() {
        return Portal.Transition.CONFUSION;
    }

    public int getPortalTransitionTime(ServerLevel level, Entity entity) {
        int n;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            n = player.getAbilities().invulnerable ? 1 : (Integer)NexusConfig.server.portalTransitionTime.get();
        } else {
            n = 0;
        }
        return n;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        for (int i = 0; i < 4; ++i) {
            double x = (double)pos.getX() + random.nextDouble();
            double y = (double)pos.getY() + random.nextDouble();
            double z = (double)pos.getZ() + random.nextDouble();
            double speedX = ((double)random.nextFloat() - 0.5) * 0.5;
            double speedY = ((double)random.nextFloat() - 0.5) * 0.5;
            double speedZ = ((double)random.nextFloat() - 0.5) * 0.5;
            int j = random.nextInt(2) * 2 - 1;
            if (state.getValue(AXIS) == Direction.Axis.Z) {
                x = (double)pos.getX() + 0.5 + 0.25 * (double)j;
                speedX = random.nextFloat() * 2.0f * (float)j;
            } else if (state.getValue(AXIS) == Direction.Axis.X) {
                z = (double)pos.getZ() + 0.5 + 0.25 * (double)j;
                speedZ = random.nextFloat() * 2.0f * (float)j;
            } else {
                y = (double)pos.getY() + 0.5 + 0.25 * (double)j;
                speedY = random.nextFloat() * 2.0f * (float)j;
            }
            level.addParticle((ParticleOptions)this.particleType.get(), x, y, z, speedX, speedY, speedZ);
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
        }
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction.Axis)state.getValue(AXIS)) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> X_AXIS_AABB;
            case Direction.Axis.Z -> Z_AXIS_AABB;
            case Direction.Axis.Y -> Y_AXIS_AABB;
        };
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS);
        if (axis.isVertical()) {
            BlockPos north = pos.relative(Direction.NORTH);
            BlockPos south = pos.relative(Direction.SOUTH);
            BlockPos east = pos.relative(Direction.EAST);
            BlockPos west = pos.relative(Direction.WEST);
            return this.isSuitableNeighbor(level, north) && this.isSuitableNeighbor(level, south) && this.isSuitableNeighbor(level, east) && this.isSuitableNeighbor(level, west);
        }
        BlockPos up = pos.above();
        BlockPos down = pos.below();
        BlockPos left = pos.relative(Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE));
        BlockPos right = pos.relative(Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
        return this.isSuitableNeighbor(level, up) && this.isSuitableNeighbor(level, down) && this.isSuitableNeighbor(level, left) && this.isSuitableNeighbor(level, right);
    }

    private boolean isSuitableNeighbor(LevelReader level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return state.getBlock() instanceof NexusPortalBlock || state.isCollisionShapeFullBlock((BlockGetter)level, pos);
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (!state.canSurvive((LevelReader)level, currentPos)) {
            level.scheduleTick(currentPos, (Block)this, 0);
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.getValue(AXIS)) {
                    case Z: {
                        yield (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS});
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return ItemStack.EMPTY;
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    protected boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.getBlock() instanceof NexusPortalBlock || super.skipRendering(state, adjacentBlockState, side);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new NexusPortalBlockEntity(pos, state);
    }

    public MapCodec<NexusPortalBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }
}

