/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.block;

import com.calemi.ccore.api.location.BlockLocation;
import com.calemi.ccore.api.string.StringHelper;
import com.calemi.nexus.block.AbstractCamoBlock;
import com.calemi.nexus.block.NexusPortalBlock;
import com.calemi.nexus.block.entity.NexusBlockEntities;
import com.calemi.nexus.block.entity.NexusPortalCoreBlockEntity;
import com.calemi.nexus.main.Nexus;
import com.calemi.nexus.util.NexusScreenHelper;
import com.calemi.nexus.util.NexusSoundHelper;
import com.calemi.nexus.world.dimension.NexusDimensionHelper;
import com.calemi.nexus.world.dimension.NexusDimensions;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

public class NexusPortalCoreBlock
extends AbstractCamoBlock {
    public static final MapCodec<NexusPortalCoreBlock> CODEC = NexusPortalCoreBlock.simpleCodec(NexusPortalCoreBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private ModConfigSpec.ConfigValue<Integer> configOption;

    public NexusPortalCoreBlock(ModConfigSpec.ConfigValue<Integer> configOption) {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.QUARTZ).requiresCorrectToolForDrops().noOcclusion().strength(1.5f, 6.0f));
        this.configOption = configOption;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)AXIS, (Comparable)Direction.Axis.X)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public NexusPortalCoreBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public int getCoordinateScale() {
        return (Integer)this.configOption.get();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"hover_text.nexus.nexus_portal_core").append(": x" + StringHelper.insertCommas((int)this.getCoordinateScale())).withStyle(ChatFormatting.GRAY));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.has(DataComponents.CUSTOM_NAME) && (blockEntity = level.getBlockEntity(pos)) instanceof NexusPortalCoreBlockEntity) {
            NexusPortalCoreBlockEntity blockEntity2 = (NexusPortalCoreBlockEntity)blockEntity;
            blockEntity2.setPoiName((Component)stack.get(DataComponents.CUSTOM_NAME));
        }
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        NexusPortalCoreBlockEntity blockEntity;
        List drops = super.getDrops(state, builder);
        Object object = builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof NexusPortalCoreBlockEntity && (blockEntity = (NexusPortalCoreBlockEntity)((Object)object)).getPoiName() != null) {
            ItemStack drop = new ItemStack((ItemLike)this);
            drop.set(DataComponents.CUSTOM_NAME, (Object)blockEntity.getPoiName());
            drops.clear();
            drops.add(drop);
        }
        return drops;
    }

    protected void onPlace(BlockState originState, Level level, BlockPos originPos, BlockState oldState, boolean movedByPiston) {
        BlockEntity blockEntity;
        super.onPlace(originState, level, originPos, oldState, movedByPiston);
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(originPos)) instanceof NexusPortalCoreBlockEntity) {
            NexusPortalCoreBlockEntity originBlockEntity = (NexusPortalCoreBlockEntity)blockEntity;
            if (originBlockEntity.getDestinationDimensionRL() != null) {
                return;
            }
            if (NexusDimensionHelper.isInNexus(level)) {
                originBlockEntity.setDestinationDimensionRL(ResourceLocation.withDefaultNamespace((String)"overworld"));
            } else {
                originBlockEntity.setDestinationDimensionRL(NexusDimensions.NEXUS_RL);
            }
        }
    }

    protected InteractionResult useWithoutItem(BlockState originState, Level level, BlockPos originPos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(originPos);
        if (blockEntity instanceof NexusPortalCoreBlockEntity) {
            NexusPortalCoreBlockEntity originBlockEntity = (NexusPortalCoreBlockEntity)blockEntity;
            if (player.isCrouching() && originBlockEntity.getCamoState() != null) {
                originBlockEntity.setCamoState(null);
                originBlockEntity.setChanged();
                NexusSoundHelper.playTeleportSound(new BlockLocation(level, originPos));
                Nexus.LOGGER.debug("Removed camo state.");
            } else if (level.isClientSide()) {
                NexusScreenHelper.openNexusPortalCoreScreen(originBlockEntity);
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockItem blockItem = (BlockItem)item;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof NexusPortalCoreBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        NexusPortalCoreBlockEntity portalCoreBlockEntity = (NexusPortalCoreBlockEntity)blockEntity;
        BlockPlaceContext context = new BlockPlaceContext(player, hand, stack, hitResult);
        BlockState heldState = blockItem.getBlock().getStateForPlacement(context);
        if (!portalCoreBlockEntity.isValidCamoState(heldState)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        portalCoreBlockEntity.setCamoState(heldState);
        portalCoreBlockEntity.setChanged();
        NexusSoundHelper.playTeleportSound(portalCoreBlockEntity.getLocation());
        Nexus.LOGGER.debug("Set camo state: {}", (Object)heldState);
        return ItemInteractionResult.SUCCESS;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (level.isClientSide()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof NexusPortalCoreBlockEntity) {
            boolean isPowered;
            NexusPortalCoreBlockEntity blockEntity2 = (NexusPortalCoreBlockEntity)blockEntity;
            Block block = level.getBlockState(blockEntity2.getProjectionPosition()).getBlock();
            if (block instanceof NexusPortalBlock) {
                NexusPortalBlock portal = (NexusPortalBlock)block;
                blockEntity2.setPortalColorBase(portal.getColor());
                blockEntity2.setChanged();
            }
            if ((isPowered = level.hasNeighborSignal(pos)) != (Boolean)state.getValue((Property)POWERED)) {
                level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered)), 2);
                if (isPowered) {
                    blockEntity2.togglePortal(null);
                }
            }
        }
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new NexusPortalCoreBlockEntity(pos, state);
    }

    @Override
    public Optional<BlockState> getCamoState(BlockGetter world, BlockPos pos) {
        return this.getPortalCore(world, pos).map(NexusPortalCoreBlockEntity::getCamoState);
    }

    @Override
    public Optional<NexusPortalCoreBlockEntity> getPortalCore(BlockGetter world, BlockPos pos) {
        if (world == null || pos == null) {
            return Optional.empty();
        }
        return world.getBlockEntity(pos, NexusBlockEntities.NEXUS_PORTAL_CORE.get());
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof NexusPortalCoreBlockEntity)) {
            return 0;
        }
        NexusPortalCoreBlockEntity blockEntity2 = (NexusPortalCoreBlockEntity)blockEntity;
        return blockEntity2.isPortalActive() ? 15 : 0;
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED});
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

