/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.block;

import com.calemi.nexus.block.NexusBlockStateProperties;
import com.calemi.nexus.block.RoadBlock;
import com.calemi.nexus.tag.NexusTags;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.Vec3;

public class RoadSlabBlock
extends SlabBlock {
    public static final BooleanProperty CHARGED = NexusBlockStateProperties.CHARGED;

    public RoadSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)CHARGED, (Comparable)Boolean.valueOf(false)));
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            RoadBlock.giveRoadEffect(level, pos, livingEntity);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)CHARGED, (Comparable)Boolean.valueOf(context.getLevel().getBlockState(context.getClickedPos().below()).is(NexusTags.Blocks.UPGRADES_ROAD_BLOCK)));
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CHARGED, (Comparable)Boolean.valueOf(level.getBlockState(pos.below()).is(NexusTags.Blocks.UPGRADES_ROAD_BLOCK))));
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)CHARGED)).booleanValue()) {
            RoadSlabBlock.spawnParticles(level, pos);
        }
    }

    private static void spawnParticles(Level level, BlockPos pos) {
        double randomOffset = 0.5625;
        RandomSource randomsource = level.random;
        for (Direction direction : Direction.values()) {
            double zOffset;
            BlockPos blockpos = pos.relative(direction);
            if (level.getBlockState(blockpos).isSolidRender((BlockGetter)level, blockpos)) continue;
            Direction.Axis direction$axis = direction.getAxis();
            double xOffset = direction$axis == Direction.Axis.X ? 0.5 + randomOffset * (double)direction.getStepX() : (double)randomsource.nextFloat();
            double yOffset = direction$axis == Direction.Axis.Y ? 0.5 + randomOffset * (double)direction.getStepY() : (double)randomsource.nextFloat();
            double d = zOffset = direction$axis == Direction.Axis.Z ? 0.5 + randomOffset * (double)direction.getStepZ() : (double)randomsource.nextFloat();
            if (!((SlabType)level.getBlockState(pos).getValue((Property)TYPE)).equals((Object)SlabType.DOUBLE)) {
                yOffset *= 0.5;
            }
            if (((SlabType)level.getBlockState(pos).getValue((Property)TYPE)).equals((Object)SlabType.TOP)) {
                yOffset += 0.5;
            }
            level.addParticle((ParticleOptions)new DustParticleOptions(Vec3.fromRGB24((int)36095).toVector3f(), 1.0f), (double)pos.getX() + xOffset, (double)pos.getY() + yOffset, (double)pos.getZ() + zOffset, 0.0, 0.0, 0.0);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CHARGED});
    }
}

