/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.block.entity;

import com.calemi.ccore.api.block.entity.BaseBlockEntity;
import com.calemi.nexus.block.entity.NexusBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;

public class NexusPortalBlockEntity
extends BaseBlockEntity {
    private BlockPos corePosition;

    public NexusPortalBlockEntity(BlockPos pos, BlockState state) {
        super(NexusBlockEntities.NEXUS_PORTAL.get(), pos, state);
    }

    public BlockPos getCorePosition() {
        return this.corePosition;
    }

    public void setCorePosition(BlockPos corePosition) {
        this.corePosition = corePosition;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.corePosition != null) {
            tag.putInt("PortalCorePosX", this.corePosition.getX());
            tag.putInt("PortalCorePosY", this.corePosition.getY());
            tag.putInt("PortalCorePosZ", this.corePosition.getZ());
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.corePosition = tag.contains("PortalCorePosX") && tag.contains("PortalCorePosY") && tag.contains("PortalCorePosZ") ? new BlockPos(tag.getInt("PortalCorePosX"), tag.getInt("PortalCorePosY"), tag.getInt("PortalCorePosZ")) : null;
    }
}

