/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.block.entity;

import com.calemi.ccore.api.block.entity.BaseBlockEntity;
import com.calemi.ccore.api.location.BlockLocation;
import com.calemi.nexus.block.NexusPortalBlock;
import com.calemi.nexus.block.NexusPortalCoreBlock;
import com.calemi.nexus.block.entity.NexusBlockEntities;
import com.calemi.nexus.block.entity.NexusPortalBlockEntity;
import com.calemi.nexus.capability.NexusCapabilityHandler;
import com.calemi.nexus.client.model.NexusPortalCoreBakedModel;
import com.calemi.nexus.config.NexusConfig;
import com.calemi.nexus.util.NexusSoundHelper;
import com.calemi.nexus.util.TeleportHelper;
import com.calemi.nexus.util.message.NexusMessengers;
import com.calemi.nexus.util.scanner.PortalScanner;
import com.calemi.nexus.util.scanner.PortalSpaceScanner;
import com.calemi.nexus.world.dimension.NexusDimensionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import org.jetbrains.annotations.Nullable;

public class NexusPortalCoreBlockEntity
extends BaseBlockEntity {
    private ResourceLocation destinationDimensionRL;
    private BlockPos destinationPos;
    private Component poiName;
    private BlockState camoState;
    private DyeColor portalColorBase = DyeColor.PURPLE;
    private final HashMap<BlockPos, DyeColor> portalColorPattern = new HashMap();

    public NexusPortalCoreBlockEntity(BlockPos pos, BlockState blockState) {
        super(NexusBlockEntities.NEXUS_PORTAL_CORE.get(), pos, blockState);
    }

    public ResourceLocation getDestinationDimensionRL() {
        return this.destinationDimensionRL;
    }

    public void setDestinationDimensionRL(ResourceLocation destinationDimensionRL) {
        this.destinationDimensionRL = destinationDimensionRL;
    }

    public BlockPos getDestinationPos() {
        return this.destinationPos;
    }

    public void setDestinationPos(@Nullable BlockPos destinationPos) {
        this.destinationPos = destinationPos;
        if (destinationPos == null && this.isPortalActive()) {
            this.unlightPortal();
        }
    }

    public Component getPoiName() {
        return this.poiName;
    }

    public void setPoiName(Component poiName) {
        this.poiName = poiName;
    }

    public BlockState getCamoState() {
        return this.camoState;
    }

    public void setCamoState(BlockState camoState) {
        this.camoState = camoState;
    }

    public boolean isValidCamoState(BlockState state) {
        if (!((Boolean)NexusConfig.server.nexusPortalCoreCamo.get()).booleanValue()) {
            return false;
        }
        if (state == null) {
            return true;
        }
        if (state.getBlock() == Blocks.AIR) {
            return false;
        }
        if (state.getBlock() instanceof NexusPortalCoreBlock) {
            return false;
        }
        if (state.getRenderShape() != RenderShape.MODEL) {
            return false;
        }
        if (this.getCamoState() != null && this.getCamoState().is(state.getBlock())) {
            return false;
        }
        return state.isCollisionShapeFullBlock((BlockGetter)this.getLevel(), this.getBlockPos());
    }

    public DyeColor getPortalColorBase() {
        return this.portalColorBase;
    }

    public void setPortalColorBase(DyeColor portalColorBase) {
        this.portalColorBase = portalColorBase;
    }

    public ResourceKey<Level> getDestinationDimensionRK() {
        ResourceLocation destinationDimensionRL = this.getDestinationDimensionRL();
        if (destinationDimensionRL == null) {
            return null;
        }
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)destinationDimensionRL);
    }

    public Level getDestinationLevel() {
        Level originLevel = this.getLevel();
        if (originLevel == null) {
            return null;
        }
        if (!(originLevel instanceof ServerLevel)) {
            return null;
        }
        ServerLevel originServerLevel = (ServerLevel)originLevel;
        ResourceKey<Level> destinationDimensionRK = this.getDestinationDimensionRK();
        if (destinationDimensionRK == null) {
            return null;
        }
        return originServerLevel.getServer().getLevel(destinationDimensionRK);
    }

    public NexusPortalCoreBlockEntity getDestinationPortalCore() {
        BlockPos destinationPos = this.getDestinationPos();
        if (destinationPos == null) {
            return null;
        }
        Level destinationLevel = this.getDestinationLevel();
        if (destinationLevel == null) {
            return null;
        }
        BlockEntity blockEntity = destinationLevel.getBlockEntity(this.getDestinationPos());
        if (!(blockEntity instanceof NexusPortalCoreBlockEntity)) {
            return null;
        }
        NexusPortalCoreBlockEntity destinationBlockEntity = (NexusPortalCoreBlockEntity)blockEntity;
        return destinationBlockEntity;
    }

    public boolean hasPortalCoreAtDestination() {
        return this.getDestinationPortalCore() != null;
    }

    public Direction getProjectionDirection() {
        BlockState state = this.getBlockState();
        if (!(state.getBlock() instanceof NexusPortalCoreBlock)) {
            return Direction.UP;
        }
        return (Direction)this.getBlockState().getValue((Property)NexusPortalCoreBlock.FACING);
    }

    public Direction.Axis getProjectionAxis() {
        Direction projectionDirection = this.getProjectionDirection();
        if (projectionDirection.getAxis().isHorizontal()) {
            return Direction.Axis.Y;
        }
        BlockState state = this.getBlockState();
        if (!(state.getBlock() instanceof NexusPortalCoreBlock)) {
            return Direction.Axis.X;
        }
        return (Direction.Axis)state.getValue((Property)NexusPortalCoreBlock.AXIS);
    }

    public BlockPos getProjectionPosition() {
        return this.getBlockPos().relative(this.getProjectionDirection());
    }

    public boolean hasValidDestination(@Nullable Entity feedbackEntity) {
        if (!NexusDimensionHelper.isDestinationValid(this.getDestinationLevel(), this.getDestinationPos())) {
            this.setDestinationPos(null);
            this.setChanged();
            NexusMessengers.NEXUS_PORTAL_CORE.send(Component.translatable((String)"message.nexus.invalid_destination").withStyle(ChatFormatting.RED), new Entity[]{feedbackEntity});
            NexusSoundHelper.playErrorSound(this.getLocation());
            return false;
        }
        NexusPortalCoreBlockEntity destinationPortalCore = this.getDestinationPortalCore();
        if (destinationPortalCore == null) {
            this.setDestinationPos(null);
            this.setChanged();
            NexusMessengers.NEXUS_PORTAL_CORE.send(Component.translatable((String)"message.nexus.no_core").withStyle(ChatFormatting.RED), new Entity[]{feedbackEntity});
            NexusSoundHelper.playErrorSound(this.getLocation());
            return false;
        }
        NexusPortalCoreBlockEntity destinationPortalCoreDestination = destinationPortalCore.getDestinationPortalCore();
        if (destinationPortalCoreDestination == null || !((Object)((Object)destinationPortalCoreDestination)).equals((Object)this)) {
            this.setDestinationPos(null);
            this.setChanged();
            NexusMessengers.NEXUS_PORTAL_CORE.send(Component.translatable((String)"message.nexus.no_link").withStyle(ChatFormatting.RED), new Entity[]{feedbackEntity});
            NexusSoundHelper.playErrorSound(this.getLocation());
            return false;
        }
        return true;
    }

    public boolean isPortalActive() {
        return this.level.getBlockState(this.getProjectionPosition()).getBlock() instanceof NexusPortalBlock;
    }

    public List<BlockPos> getPortalPositions() {
        PortalScanner scanner = new PortalScanner(new BlockLocation(this.level, this.getProjectionPosition()), this.getProjectionAxis(), true, (Integer)NexusConfig.server.maxPortalSize.get());
        scanner.start();
        return scanner.getCollectedPositions();
    }

    public void savePortalColorPattern(List<BlockPos> portalLocations) {
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        this.portalColorPattern.clear();
        portalLocations.forEach(blockPos -> {
            Block patt0$temp = level.getBlockState(blockPos).getBlock();
            if (patt0$temp instanceof NexusPortalBlock) {
                NexusPortalBlock portal = (NexusPortalBlock)patt0$temp;
                this.portalColorPattern.put((BlockPos)blockPos, portal.getColor());
            }
        });
    }

    public void togglePortal(@Nullable Entity feedbackEntity) {
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        BlockPos projectionPosition = this.getProjectionPosition();
        BlockState projectionState = level.getBlockState(projectionPosition);
        if (!(projectionState.getBlock() instanceof NexusPortalBlock) && !level.getBlockState(projectionPosition).isAir()) {
            NexusMessengers.NEXUS_PORTAL_CORE.send(Component.translatable((String)"message.nexus.light_portal.obstructed").withStyle(ChatFormatting.RED), new Entity[]{feedbackEntity});
            NexusSoundHelper.playErrorSound(this.getLocation());
            return;
        }
        if (this.isPortalActive()) {
            this.unlightPortal();
        } else {
            this.lightPortal(feedbackEntity);
        }
    }

    public void unlightPortal() {
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        List<BlockPos> portalPositions = this.getPortalPositions();
        this.savePortalColorPattern(portalPositions);
        portalPositions.forEach(blockPos -> level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 2));
    }

    public void lightPortal(@Nullable Entity feedbackEntity) {
        if (!this.hasValidDestination(feedbackEntity)) {
            return;
        }
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        BlockPos projectionPosition = this.getProjectionPosition();
        Direction.Axis projectionAxis = this.getProjectionAxis();
        PortalSpaceScanner scanner = new PortalSpaceScanner(new BlockLocation(level, projectionPosition), projectionAxis, (Integer)NexusConfig.server.maxPortalSize.get() + 1);
        scanner.start();
        ArrayList collectedPositions = scanner.getCollectedPositions();
        if (scanner.isHalted()) {
            NexusMessengers.NEXUS_PORTAL_CORE.send(Component.translatable((String)"message.nexus.light_portal.invalid_frame").withStyle(ChatFormatting.RED), new Entity[]{feedbackEntity});
            NexusSoundHelper.playErrorSound(this.getLocation());
        } else if (collectedPositions.size() > scanner.getMaxCollectionSize() - 1) {
            NexusMessengers.NEXUS_PORTAL_CORE.send(Component.translatable((String)"message.nexus.light_portal.overflowing_frame").withStyle(ChatFormatting.RED), new Entity[]{feedbackEntity});
            NexusSoundHelper.playErrorSound(this.getLocation());
        } else {
            scanner.getCollectedPositions().forEach(blockPos -> {
                Block portalBlock = NexusPortalBlock.fromDye(this.portalColorPattern.getOrDefault(blockPos, this.getPortalColorBase()));
                level.setBlock(blockPos, (BlockState)portalBlock.defaultBlockState().setValue(NexusPortalBlock.AXIS, (Comparable)scanner.getAxis()), 3);
                BlockEntity patt0$temp = level.getBlockEntity(blockPos);
                if (patt0$temp instanceof NexusPortalBlockEntity) {
                    NexusPortalBlockEntity portalBlockEntity = (NexusPortalBlockEntity)patt0$temp;
                    portalBlockEntity.setCorePosition(this.getBlockPos());
                }
            });
            NexusMessengers.NEXUS_PORTAL_CORE.send(Component.translatable((String)"message.nexus.light_portal.success").withStyle(ChatFormatting.GREEN), new Entity[]{feedbackEntity});
            NexusSoundHelper.playSuccessSound(this.getLocation());
        }
    }

    public void teleportEntity(Entity feedbackEntity) {
        if (!this.hasValidDestination(feedbackEntity)) {
            return;
        }
        Player player = null;
        if (feedbackEntity instanceof Player) {
            player = (Player)feedbackEntity;
        }
        if (player != null) {
            ResourceLocation destinationDimensionRL = this.getDestinationDimensionRL();
            if (!NexusConfig.isDestinationDimensionAllowed(destinationDimensionRL)) {
                feedbackEntity.sendSystemMessage((Component)Component.translatable((String)"message.nexus.teleport.prohibited_dimension").withStyle(ChatFormatting.RED));
                NexusSoundHelper.playErrorSound(new BlockLocation(feedbackEntity));
                return;
            }
            if (!NexusCapabilityHandler.isDimensionUnlocked(player, destinationDimensionRL)) {
                feedbackEntity.sendSystemMessage((Component)Component.translatable((String)"message.nexus.teleport.locked_dimension").withStyle(ChatFormatting.RED));
                NexusSoundHelper.playErrorSound(new BlockLocation(feedbackEntity));
                return;
            }
        }
        NexusPortalCoreBlockEntity destinationPortalCore = this.getDestinationPortalCore();
        if (player != null) {
            NexusSoundHelper.playTeleportSound(new BlockLocation(feedbackEntity));
        }
        TeleportHelper.teleportToWorld(feedbackEntity, destinationPortalCore.getProjectionPosition(), this.getDestinationDimensionRK());
        if (player != null) {
            NexusSoundHelper.playTeleportSound(new BlockLocation(feedbackEntity));
        }
    }

    public static MutableComponent getFormattedCurrentDestinationText() {
        return Component.translatable((String)"screen.nexus.nexus_portal_core.text.current_destination").withStyle(ChatFormatting.LIGHT_PURPLE);
    }

    public static MutableComponent getFormattedDestinationNameText(String destinationPOIName, String destinationDimensionPath, ChatFormatting highlight, ChatFormatting normal) {
        if (!destinationPOIName.isEmpty()) {
            return Component.empty().append(String.valueOf(highlight) + destinationPOIName).append(" (").append((Component)NexusPortalCoreBlockEntity.getFormattedDestinationDimensionText(destinationDimensionPath)).append(")").withStyle(normal);
        }
        return NexusPortalCoreBlockEntity.getFormattedDestinationDimensionText(destinationDimensionPath).withStyle(highlight);
    }

    public static MutableComponent getFormattedDestinationDimensionText(String destinationDimensionPath) {
        return Component.literal((String)destinationDimensionPath.toUpperCase().replaceAll("_", " "));
    }

    public static MutableComponent getFormattedDestinationPositionText(BlockPos destinationPos, ChatFormatting highlight, ChatFormatting normal) {
        return Component.literal((String)"[x").append(String.valueOf(highlight) + destinationPos.getX()).append(", y").append(String.valueOf(highlight) + destinationPos.getY()).append(", z").append(String.valueOf(highlight) + destinationPos.getZ()).append("]").withStyle(normal);
    }

    public ModelData getModelData() {
        return ModelData.builder().with(NexusPortalCoreBakedModel.CAMO_STATE, (Object)this.camoState).build();
    }

    public void setChanged() {
        AuxiliaryLightManager auxLightManager;
        super.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            this.level.getLightEngine().checkBlock(this.getBlockPos());
        }
        this.requestModelDataUpdate();
        AuxiliaryLightManager auxiliaryLightManager = auxLightManager = this.level != null ? this.level.getAuxLightManager(this.worldPosition) : null;
        if (auxLightManager == null) {
            return;
        }
        auxLightManager.setLightAt(this.worldPosition, this.camoState != null ? this.camoState.getLightEmission((BlockGetter)this.level, this.worldPosition) : 0);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.destinationDimensionRL != null) {
            tag.putString("DestinationDimNamespace", this.destinationDimensionRL.getNamespace());
            tag.putString("DestinationDimPath", this.destinationDimensionRL.getPath());
        }
        if (this.destinationPos != null) {
            tag.putInt("DestinationPosX", this.destinationPos.getX());
            tag.putInt("DestinationPosY", this.destinationPos.getY());
            tag.putInt("DestinationPosZ", this.destinationPos.getZ());
        }
        if (this.poiName != null) {
            tag.putString("POIName", Component.Serializer.toJson((Component)this.poiName, (HolderLookup.Provider)registries));
        }
        if (this.camoState != null) {
            tag.put("CamoState", (Tag)NbtUtils.writeBlockState((BlockState)this.camoState));
        }
        tag.putInt("PortalColorBaseId", this.portalColorBase.getId());
        ListTag portalColorPatternList = new ListTag();
        for (Map.Entry<BlockPos, DyeColor> entry : this.portalColorPattern.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.putInt("PosX", entry.getKey().getX());
            entryTag.putInt("PosY", entry.getKey().getY());
            entryTag.putInt("PosZ", entry.getKey().getZ());
            entryTag.putInt("ColorId", entry.getValue().getId());
            portalColorPatternList.add((Object)entryTag);
        }
        tag.put("PortalColorPattern", (Tag)portalColorPatternList);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("DestinationDimNamespace") && tag.contains("DestinationDimPath")) {
            this.destinationDimensionRL = ResourceLocation.fromNamespaceAndPath((String)tag.getString("DestinationDimNamespace"), (String)tag.getString("DestinationDimPath"));
        }
        this.destinationPos = tag.contains("DestinationPosX") && tag.contains("DestinationPosY") && tag.contains("DestinationPosZ") ? new BlockPos(tag.getInt("DestinationPosX"), tag.getInt("DestinationPosY"), tag.getInt("DestinationPosZ")) : null;
        if (tag.contains("POIName", 8)) {
            this.poiName = NexusPortalCoreBlockEntity.parseCustomNameSafe((String)tag.getString("POIName"), (HolderLookup.Provider)registries);
        }
        this.camoState = tag.contains("CamoState") ? NbtUtils.readBlockState((HolderGetter)(this.level != null ? this.level.holderLookup(Registries.BLOCK) : BuiltInRegistries.BLOCK.asLookup()), (CompoundTag)tag.getCompound("CamoState")) : null;
        this.portalColorBase = DyeColor.byId((int)tag.getInt("PortalColorBaseId"));
        this.portalColorPattern.clear();
        ListTag list = tag.getList("PortalColorPattern", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag entryTag = list.getCompound(i);
            int x = entryTag.getInt("PosX");
            int y = entryTag.getInt("PosY");
            int z = entryTag.getInt("PosZ");
            int colorId = entryTag.getInt("ColorId");
            this.portalColorPattern.put(new BlockPos(x, y, z), DyeColor.byId((int)colorId));
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.poiName = (Component)componentInput.get(DataComponents.CUSTOM_NAME);
    }
}

