/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.capability;

import com.calemi.nexus.capability.NexusAttachments;
import com.calemi.nexus.capability.UnlockedDimensionsList;
import com.calemi.nexus.main.NexusRef;
import com.calemi.nexus.packet.UnlockedDimensionsListSyncPayload;
import com.calemi.nexus.util.message.NexusMessengers;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber(modid="nexus")
public class NexusCapabilityHandler {
    public static final EntityCapability<UnlockedDimensionsList, Void> unlockedDimensionsCapability = EntityCapability.createVoid((ResourceLocation)NexusRef.rl("unlocked_dimensions"), UnlockedDimensionsList.class);

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        NexusCapabilityHandler.tryUnlockDimension(event.getEntity());
        NexusCapabilityHandler.syncUnlockedDimensionList(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        NexusCapabilityHandler.tryUnlockDimension(event.getEntity());
        NexusCapabilityHandler.syncUnlockedDimensionList(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        NexusCapabilityHandler.syncUnlockedDimensionList(event.getEntity());
    }

    private static void tryUnlockDimension(Player player) {
        Level level = player.level();
        UnlockedDimensionsList unlockedDimensions = UnlockedDimensionsList.get(player);
        if (unlockedDimensions.unlock(player.level().dimension().location()) && !level.isClientSide()) {
            NexusMessengers.MAIN.send(Component.translatable((String)"message.nexus.unlock_dimension").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC), new Entity[]{player});
        }
    }

    public static boolean isDimensionUnlocked(Player player, ResourceLocation dimensionRL) {
        UnlockedDimensionsList unlockedDimensions = UnlockedDimensionsList.get(player);
        return unlockedDimensions.isUnlocked(dimensionRL);
    }

    public static void syncUnlockedDimensionList(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer target = (ServerPlayer)player;
            target.connection.send((CustomPacketPayload)new UnlockedDimensionsListSyncPayload(UnlockedDimensionsList.get(player), (HolderLookup.Provider)player.registryAccess()));
        }
    }

    @EventBusSubscriber(modid="nexus", bus=EventBusSubscriber.Bus.MOD)
    private static final class Setup {
        private Setup() {
        }

        @SubscribeEvent
        public static void registerCapabilities(RegisterCapabilitiesEvent event) {
            event.registerEntity(unlockedDimensionsCapability, EntityType.PLAYER, (player, ctx) -> (UnlockedDimensionsList)player.getData(NexusAttachments.UNLOCKED_DIMENSIONS_ATTACHMENT.get()));
        }
    }
}

