/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.capability;

import com.calemi.nexus.capability.NexusAttachments;
import com.calemi.nexus.config.NexusConfig;
import com.calemi.nexus.world.dimension.NexusDimensions;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.UnknownNullability;

public class UnlockedDimensionsList
implements INBTSerializable<CompoundTag> {
    private final Set<ResourceLocation> unlockedDimensions = new HashSet<ResourceLocation>();

    public UnlockedDimensionsList() {
        this.unlockedDimensions.add(Level.OVERWORLD.location());
        this.unlockedDimensions.add(NexusDimensions.NEXUS_RL);
    }

    public static UnlockedDimensionsList get(Player player) {
        return (UnlockedDimensionsList)player.getData(NexusAttachments.UNLOCKED_DIMENSIONS_ATTACHMENT);
    }

    public Set<ResourceLocation> getUnlockedDimensions() {
        return this.unlockedDimensions;
    }

    public boolean isUnlocked(ResourceLocation dimensionResourceLocation) {
        return this.unlockedDimensions.contains(dimensionResourceLocation);
    }

    public boolean unlock(ResourceLocation dimensionResourceLocation) {
        if (!this.isUnlocked(dimensionResourceLocation) && NexusConfig.isDestinationDimensionAllowed(dimensionResourceLocation)) {
            this.unlockedDimensions.add(dimensionResourceLocation);
            return true;
        }
        return false;
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        ListTag listTag = new ListTag();
        for (ResourceLocation location : this.unlockedDimensions) {
            listTag.add((Object)StringTag.valueOf((String)location.toString()));
        }
        tag.put("UnlockedDimensions", (Tag)listTag);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        this.unlockedDimensions.clear();
        if (tag.contains("UnlockedDimensions")) {
            ListTag listTag = tag.getList("UnlockedDimensions", 8);
            for (int i = 0; i < listTag.size(); ++i) {
                this.unlockedDimensions.add(ResourceLocation.parse((String)listTag.getString(i)));
            }
        }
    }
}

