/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.client;

import com.calemi.ccore.api.list.ListHelper;
import com.calemi.nexus.block.NexusBlocks;
import com.calemi.nexus.client.color.CamoBlockColor;
import com.calemi.nexus.client.model.NexusPortalCoreBakedModel;
import com.calemi.nexus.client.partclie.ColoredPortalParticleProvider;
import com.calemi.nexus.client.partclie.NexusParticles;
import com.calemi.nexus.client.partclie.WarpblossomParticleProvider;
import com.calemi.nexus.main.Nexus;
import com.calemi.nexus.util.NexusLists;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;

@EventBusSubscriber(modid="nexus", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class NexusClient {
    @SubscribeEvent
    public static void onBlockColorHandlersRegistry(RegisterColorHandlersEvent.Block event) {
        Nexus.LOGGER.info("Registering: Block Colors - Start");
        event.register((BlockColor)new CamoBlockColor(), ListHelper.toBlockArray(NexusLists.NEXUS_PORTAL_CORE_BLOCKS));
        event.register((state, blockAndTintGetter, pos, tintIndex) -> {
            if (tintIndex != 0) {
                return blockAndTintGetter != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)blockAndTintGetter, (BlockPos)pos) : GrassColor.getDefaultColor();
            }
            return -1;
        }, new Block[]{(Block)NexusBlocks.PURPLE_PETALS.get()});
        Nexus.LOGGER.info("Registering: Block Colors - End");
    }

    @SubscribeEvent
    public static void onModelBake(ModelEvent.ModifyBakingResult event) {
        Nexus.LOGGER.info("Registering: Block Models - Start");
        event.getModels().entrySet().stream().filter(entry -> ((ModelResourceLocation)entry.getKey()).id().getNamespace().equals("nexus") && ((ModelResourceLocation)entry.getKey()).id().getPath().contains("nexus_portal_core")).forEach(entry -> event.getModels().put((ModelResourceLocation)entry.getKey(), new NexusPortalCoreBakedModel((BakedModel)entry.getValue())));
        Nexus.LOGGER.info("Registering: Block Models - End");
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)NexusParticles.WHITE_PORTAL_PARTICLES.get(), sprites -> new ColoredPortalParticleProvider(sprites, 1.0f, 1.0f, 1.0f));
        event.registerSpriteSet((ParticleType)NexusParticles.ORANGE_PORTAL_PARTICLES.get(), sprites -> new ColoredPortalParticleProvider(sprites, 1.0f, 0.5f, 0.0f));
        event.registerSpriteSet((ParticleType)NexusParticles.YELLOW_PORTAL_PARTICLES.get(), sprites -> new ColoredPortalParticleProvider(sprites, 1.0f, 1.0f, 0.0f));
        event.registerSpriteSet((ParticleType)NexusParticles.PURPLE_PORTAL_PARTICLES.get(), sprites -> new ColoredPortalParticleProvider(sprites, 0.5f, 0.0f, 1.0f));
        event.registerSpriteSet((ParticleType)NexusParticles.CYAN_PORTAL_PARTICLES.get(), sprites -> new ColoredPortalParticleProvider(sprites, 0.0f, 1.0f, 1.0f));
        event.registerSpriteSet((ParticleType)NexusParticles.LIGHT_GRAY_PORTAL_PARTICLES.get(), sprites -> new ColoredPortalParticleProvider(sprites, 0.75f, 0.75f, 0.75f));
        event.registerSpriteSet((ParticleType)NexusParticles.GRAY_PORTAL_PARTICLES.get(), sprites -> new ColoredPortalParticleProvider(sprites, 0.5f, 0.5f, 0.5f));
        event.registerSpriteSet((ParticleType)NexusParticles.PINK_PORTAL_PARTICLES.get(), sprites -> new ColoredPortalParticleProvider(sprites, 1.0f, 0.5f, 1.0f));
        event.registerSpriteSet((ParticleType)NexusParticles.LIME_PORTAL_PARTICLES.get(), sprites -> new ColoredPortalParticleProvider(sprites, 0.5f, 1.0f, 0.5f));
        event.registerSpriteSet((ParticleType)NexusParticles.LIGHT_BLUE_PORTAL_PARTICLES.get(), sprites -> new ColoredPortalParticleProvider(sprites, 0.4f, 0.4f, 0.9f));
        event.registerSpriteSet((ParticleType)NexusParticles.MAGENTA_PORTAL_PARTICLES.get(), sprites -> new ColoredPortalParticleProvider(sprites, 0.75f, 0.5f, 1.0f));
        event.registerSpriteSet((ParticleType)NexusParticles.GREEN_PORTAL_PARTICLES.get(), sprites -> new ColoredPortalParticleProvider(sprites, 0.0f, 0.5f, 0.0f));
        event.registerSpriteSet((ParticleType)NexusParticles.BLUE_PORTAL_PARTICLES.get(), sprites -> new ColoredPortalParticleProvider(sprites, 0.25f, 0.25f, 1.0f));
        event.registerSpriteSet((ParticleType)NexusParticles.RED_PORTAL_PARTICLES.get(), sprites -> new ColoredPortalParticleProvider(sprites, 1.0f, 0.0f, 0.0f));
        event.registerSpriteSet((ParticleType)NexusParticles.BROWN_PORTAL_PARTICLES.get(), sprites -> new ColoredPortalParticleProvider(sprites, 0.5f, 0.25f, 0.0f));
        event.registerSpriteSet((ParticleType)NexusParticles.BLACK_PORTAL_PARTICLES.get(), sprites -> new ColoredPortalParticleProvider(sprites, 0.0f, 0.0f, 0.0f));
        event.registerSpriteSet((ParticleType)NexusParticles.WARPBLOSSOM_PARTICLES.get(), WarpblossomParticleProvider::new);
    }
}

