/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.client.render;

import com.calemi.nexus.block.NexusPortalCoreBlock;
import com.calemi.nexus.config.NexusConfig;
import com.calemi.nexus.world.dimension.NexusDimensionHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

public class RenderNexusPortalCoreWorldOverlay {
    @SubscribeEvent
    public void onRenderLevelStageEvent(RenderLevelStageEvent event) {
        if (!((Boolean)NexusConfig.client.portalCoreWorldOverlay.get()).booleanValue()) {
            return;
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            BlockItem blockItem;
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer player = mc.player;
            if (player == null) {
                return;
            }
            if (NexusDimensionHelper.isInNexus((Entity)player)) {
                return;
            }
            Item item = player.getMainHandItem().getItem();
            if (!(item instanceof BlockItem) || !((item = (blockItem = (BlockItem)item).getBlock()) instanceof NexusPortalCoreBlock)) {
                return;
            }
            NexusPortalCoreBlock originBlock = (NexusPortalCoreBlock)item;
            BlockPos destinationPosition = NexusDimensionHelper.getDynamicBlockDestination(player.level(), player.blockPosition(), originBlock.getCoordinateScale());
            int coordinateScale = originBlock.getCoordinateScale();
            if (coordinateScale == 1) {
                return;
            }
            PoseStack poseStack = event.getPoseStack();
            Camera activeRenderInfo = mc.getEntityRenderDispatcher().camera;
            Vec3 projectedView = activeRenderInfo.getPosition();
            poseStack.pushPose();
            poseStack.translate((double)(destinationPosition.getX() * coordinateScale) - projectedView.x, 0.0, (double)(destinationPosition.getZ() * coordinateScale) - projectedView.z);
            this.renderLine(0.0f, 0.0f, 1.0f, RenderType.debugLineStrip((double)2.0), poseStack, mc);
            this.renderLine(0.0f, coordinateScale, 1.0f, RenderType.debugLineStrip((double)2.0), poseStack, mc);
            this.renderLine(coordinateScale, 0.0f, 1.0f, RenderType.debugLineStrip((double)2.0), poseStack, mc);
            this.renderLine(coordinateScale, coordinateScale, 1.0f, RenderType.debugLineStrip((double)2.0), poseStack, mc);
            poseStack.popPose();
        }
    }

    private void renderLine(float x, float z, float alpha, RenderType lineRenderType, PoseStack poseStack, Minecraft mc) {
        VertexConsumer buffer = mc.renderBuffers().bufferSource().getBuffer(lineRenderType);
        Matrix4f matrix = poseStack.last().pose();
        buffer.addVertex(matrix, x, -100.0f, z).setColor(1.0f, 1.0f, 1.0f, alpha);
        buffer.addVertex(matrix, x, 100.0f, z).setColor(1.0f, 1.0f, 1.0f, alpha);
        mc.renderBuffers().bufferSource().endBatch(lineRenderType);
    }
}

