/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.client.screen;

import com.calemi.ccore.api.client.screen.BaseScreen;
import com.calemi.ccore.api.client.screen.ScreenHelper;
import com.calemi.nexus.block.entity.NexusPortalCoreBlockEntity;
import com.calemi.nexus.capability.UnlockedDimensionsList;
import com.calemi.nexus.config.NexusConfig;
import com.calemi.nexus.packet.NexusPortalCoreDestinationDimensionSyncPayload;
import com.calemi.nexus.packet.NexusPortalCoreDestinationNameSyncPayload;
import com.calemi.nexus.packet.NexusPortalCoreFindLinkPayload;
import com.calemi.nexus.packet.NexusPortalCoreGenerateLinkPayload;
import com.calemi.nexus.packet.NexusPortalCoreLightPortalPayload;
import com.calemi.nexus.packet.NexusPortalCoreTeleportPayload;
import com.calemi.nexus.packet.NexusPortalCoreUnlinkPayload;
import com.calemi.nexus.world.dimension.NexusDimensionHelper;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;

public class NexusPortalCoreScreen
extends BaseScreen {
    private final NexusPortalCoreBlockEntity originBlockEntity;
    private CycleButton<ResourceLocation> dimensionSelectButton;
    private Button unlinkButton;
    private Button lightPortalButton;
    private Button teleportButton;
    private Button findLinkButton;
    private Button generateLinkButton;
    private String destinationName;

    public NexusPortalCoreScreen(NexusPortalCoreBlockEntity portalCoreBlockEntity) {
        super((Component)Component.translatable((String)"screen.nexus.nexus_portal_core.title"));
        this.originBlockEntity = portalCoreBlockEntity;
        this.destinationName = "";
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    protected void init() {
        super.init();
        PacketDistributor.sendToServer((CustomPacketPayload)new NexusPortalCoreDestinationNameSyncPayload(this.originBlockEntity.getBlockPos(), ""), (CustomPacketPayload[])new CustomPacketPayload[0]);
        ArrayList<ResourceLocation> dimensions = new ArrayList<ResourceLocation>(UnlockedDimensionsList.get(this.player).getUnlockedDimensions());
        dimensions.removeIf(dimension -> !NexusConfig.isDestinationDimensionAllowed(dimension));
        dimensions.remove(this.player.level().dimension().location());
        this.dimensionSelectButton = (CycleButton)this.addRenderableWidget((GuiEventListener)CycleButton.builder(dimension -> Component.literal((String)dimension.getPath().toUpperCase().replaceAll("_", " "))).withValues(dimensions).withInitialValue((Object)this.originBlockEntity.getDestinationDimensionRL()).create(this.getScreenX() - 100, this.getScreenY() - 10 - 26, 200, 20, (Component)Component.translatable((String)"screen.nexus.nexus_portal_core.button.dimension_select.title"), (btn, selected) -> PacketDistributor.sendToServer((CustomPacketPayload)new NexusPortalCoreDestinationDimensionSyncPayload(this.originBlockEntity.getBlockPos(), (ResourceLocation)selected), (CustomPacketPayload[])new CustomPacketPayload[0])));
        this.lightPortalButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), btn -> this.lightPortalButtonPress()).bounds(this.getScreenX() - 100, this.getScreenY() - 10, 20, 20).build());
        this.teleportButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"screen.nexus.nexus_portal_core.button.teleport.title").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GOLD), btn -> this.teleportButtonPress()).bounds(this.getScreenX() - 100 + 26, this.getScreenY() - 10, 148, 20).build());
        this.unlinkButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), btn -> this.unlinkButtonPress()).bounds(this.getScreenX() + 100 - 20, this.getScreenY() - 10, 20, 20).build());
        this.findLinkButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"screen.nexus.nexus_portal_core.button.find_link.title").withStyle(ChatFormatting.GOLD), btn -> this.findLinkButtonPress()).bounds(this.getScreenX() - 100, this.getScreenY() - 10 + 26, 97, 20).build());
        this.generateLinkButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"screen.nexus.nexus_portal_core.button.generate_link.title").withStyle(ChatFormatting.GOLD), btn -> this.generateLinkPress()).bounds(this.getScreenX() + 3, this.getScreenY() - 10 + 26, 97, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"screen.nexus.nexus_portal_core.button.close.title"), btn -> this.onClose()).bounds(this.getScreenX() - 100, this.getScreenY() - 10 + 26 + 26, 200, 20).build());
        this.buttonUpdate();
    }

    private void lightPortalButtonPress() {
        PacketDistributor.sendToServer((CustomPacketPayload)new NexusPortalCoreLightPortalPayload(this.originBlockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.onClose();
    }

    private void teleportButtonPress() {
        PacketDistributor.sendToServer((CustomPacketPayload)new NexusPortalCoreTeleportPayload(this.originBlockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.onClose();
    }

    private void unlinkButtonPress() {
        PacketDistributor.sendToServer((CustomPacketPayload)new NexusPortalCoreUnlinkPayload(this.originBlockEntity.getBlockPos(), NexusPortalCoreScreen.hasShiftDown()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.onClose();
    }

    private void findLinkButtonPress() {
        PacketDistributor.sendToServer((CustomPacketPayload)new NexusPortalCoreFindLinkPayload(this.originBlockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.onClose();
    }

    private void generateLinkPress() {
        PacketDistributor.sendToServer((CustomPacketPayload)new NexusPortalCoreGenerateLinkPayload(this.originBlockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.onClose();
    }

    private void buttonUpdate() {
        if (this.originBlockEntity.getDestinationPos() == null) {
            this.dimensionSelectButton.active = NexusDimensionHelper.isInNexus((Entity)this.player);
            this.lightPortalButton.active = false;
            this.teleportButton.active = false;
            this.unlinkButton.active = false;
            this.findLinkButton.active = true;
            this.generateLinkButton.active = this.player.getInventory().countItem(this.originBlockEntity.getBlockState().getBlock().asItem()) >= 1 || this.player.isCreative();
            this.teleportButton.setMessage((Component)this.teleportButton.getMessage().copy().withStyle(ChatFormatting.GRAY));
        } else {
            this.dimensionSelectButton.active = false;
            this.lightPortalButton.active = true;
            this.teleportButton.active = true;
            this.unlinkButton.active = true;
            this.findLinkButton.active = false;
            this.generateLinkButton.active = false;
            this.findLinkButton.setMessage((Component)this.findLinkButton.getMessage().copy().withStyle(ChatFormatting.GRAY));
            this.generateLinkButton.setMessage((Component)this.generateLinkButton.getMessage().copy().withStyle(ChatFormatting.GRAY));
        }
    }

    public void tick() {
        super.tick();
        if (this.player.level().getGameTime() % 10L == 0L) {
            this.buttonUpdate();
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        ResourceLocation destinationDimResourceLocation = this.originBlockEntity.getDestinationDimensionRL();
        BlockPos destinationPos = this.originBlockEntity.getDestinationPos();
        if (destinationPos == null) {
            graphics.drawCenteredString(this.mc.font, (Component)Component.translatable((String)"screen.nexus.nexus_portal_core.text.no_destination").withStyle(ChatFormatting.RED), this.getScreenX(), this.getScreenY() - 50, 0xFFFFFF);
            if (!NexusDimensionHelper.isInNexus((Entity)this.player)) {
                ScreenHelper.drawTooltipHoverRect((GuiGraphics)graphics, (ScreenRectangle)this.dimensionSelectButton.getRectangle(), (int)mouseX, (int)mouseY, (Component[])new Component[]{Component.translatable((String)"screen.nexus.nexus_portal_core.button.dimension_select.cant_set").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC)});
            }
            ScreenHelper.drawTooltipHoverRect((GuiGraphics)graphics, (ScreenRectangle)this.findLinkButton.getRectangle(), (int)mouseX, (int)mouseY, (Component[])new Component[]{Component.translatable((String)"screen.nexus.nexus_portal_core.button.find_link.info")});
            ScreenHelper.drawTooltipHoverRect((GuiGraphics)graphics, (ScreenRectangle)this.generateLinkButton.getRectangle(), (int)mouseX, (int)mouseY, (Component[])new Component[]{Component.translatable((String)"screen.nexus.nexus_portal_core.button.generate_link.info"), Component.translatable((String)"screen.nexus.nexus_portal_core.button.generate_link.requires").append(": ").append("1x ").append((Component)this.originBlockEntity.getBlockState().getBlock().getName()).withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.ITALIC)});
        } else if (destinationDimResourceLocation != null) {
            graphics.drawCenteredString(this.mc.font, (Component)NexusPortalCoreBlockEntity.getFormattedCurrentDestinationText().withStyle(ChatFormatting.UNDERLINE), this.getScreenX(), this.getScreenY() - 76, 0xFFFFFF);
            graphics.drawCenteredString(this.mc.font, (Component)NexusPortalCoreBlockEntity.getFormattedDestinationNameText(this.destinationName, destinationDimResourceLocation.getPath(), ChatFormatting.GOLD, ChatFormatting.WHITE), this.getScreenX(), this.getScreenY() - 64, 0xFFFFFF);
            graphics.drawCenteredString(this.mc.font, (Component)NexusPortalCoreBlockEntity.getFormattedDestinationPositionText(destinationPos, ChatFormatting.GOLD, ChatFormatting.WHITE), this.getScreenX(), this.getScreenY() - 52, 0xFFFFFF);
        }
        Item lightPortalItem = Items.FLINT_AND_STEEL;
        int xOffset = 1;
        MutableComponent lightPortalInfo = Component.translatable((String)"screen.nexus.nexus_portal_core.button.light_portal.light_info");
        if (this.originBlockEntity.isPortalActive()) {
            lightPortalItem = Items.WATER_BUCKET;
            xOffset = 2;
            lightPortalInfo = Component.translatable((String)"screen.nexus.nexus_portal_core.button.light_portal.destroy_info");
        }
        graphics.renderItem(new ItemStack((ItemLike)lightPortalItem), this.lightPortalButton.getX() + xOffset, this.lightPortalButton.getY() + 2);
        graphics.renderItem(new ItemStack((ItemLike)Items.BARRIER), this.unlinkButton.getX() + 2, this.unlinkButton.getY() + 2);
        if (destinationPos != null) {
            ScreenHelper.drawTooltipHoverRect((GuiGraphics)graphics, (ScreenRectangle)this.lightPortalButton.getRectangle(), (int)mouseX, (int)mouseY, (Component[])new Component[]{lightPortalInfo});
            ScreenHelper.drawTooltipHoverRect((GuiGraphics)graphics, (ScreenRectangle)this.unlinkButton.getRectangle(), (int)mouseX, (int)mouseY, (Component[])new Component[]{Component.translatable((String)"screen.nexus.nexus_portal_core.button.unlink.info_1"), Component.translatable((String)"screen.nexus.nexus_portal_core.button.unlink.info_2").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC)});
        }
    }

    protected boolean canCloseWithInvKey() {
        return true;
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected int getGuiSizeX() {
        return 0;
    }

    protected int getGuiSizeY() {
        return 0;
    }
}

