/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.compat;

import com.calemi.ccore.api.list.ListHelper;
import com.calemi.nexus.block.NexusBlocks;
import com.calemi.nexus.config.NexusConfig;
import com.calemi.nexus.item.NexusItems;
import com.calemi.nexus.main.Nexus;
import com.calemi.nexus.main.NexusRef;
import com.calemi.nexus.util.NexusLists;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class NexusJEIPlugin
implements IModPlugin {
    public void registerRecipes(IRecipeRegistration registration) {
        registration.addIngredientInfo((ItemLike)NexusItems.CHRONO_UPGRADE_SMITHING_TEMPLATE.get(), new Component[]{Component.translatable((String)"description.nexus.chrono_upgrade_smithing_template")});
        registration.addIngredientInfo(ListHelper.toItemStackListFromBlock(NexusLists.NEXUS_PORTAL_CORE_BLOCKS), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.nexus.nexus_portal_core")});
        registration.addIngredientInfo((ItemLike)NexusBlocks.WARPSLATE_ACCELERITE_ORE.asItem(), new Component[]{Component.translatable((String)"description.nexus.accelerite_ore")});
        double acceleriteOreFromMovingWarpslateChance = (Double)NexusConfig.server.acceleriteOreFromMovingWarpslateChance.get();
        if (acceleriteOreFromMovingWarpslateChance > 0.0) {
            registration.addIngredientInfo(List.of(new ItemStack((ItemLike)NexusBlocks.WARPSLATE_ACCELERITE_ORE.get()), new ItemStack((ItemLike)NexusBlocks.WARPSLATE.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.nexus.accelerite_ore_from_warpslate", (Object[])new Object[]{acceleriteOreFromMovingWarpslateChance * 100.0})});
        }
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)NexusItems.DORMANT_ACCELERITE_INGOT.get()), new ItemStack((ItemLike)NexusItems.CHARGED_ACCELERITE_INGOT.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.nexus.accelerite_ingot")});
        registration.addIngredientInfo(ListHelper.toItemStackListFromItem(NexusLists.ACCELERITE_TOOLS), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.nexus.accelerite_tools_acceleration")});
        registration.addIngredientInfo(ListHelper.toItemStackListFromItem(NexusLists.ACCELERITE_ARMOR), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.nexus.accelerite_armor_acceleration")});
        registration.addIngredientInfo(ListHelper.toItemStackListFromItem(NexusLists.ACCELERITE_EQUIPMENT), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.nexus.accelerite_equipment_repair")});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)NexusBlocks.ROAD.get()), new ItemStack((ItemLike)NexusBlocks.ROAD_SLAB.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.nexus.road")});
        int roadAcceleriteArmorEffectStackAdd = (Integer)NexusConfig.server.roadAcceleriteArmorEffectStackAdd.get();
        Nexus.LOGGER.debug("CONFIGURATION " + roadAcceleriteArmorEffectStackAdd);
        if (roadAcceleriteArmorEffectStackAdd > 0) {
            ArrayList<ItemStack> roadArmor = new ArrayList<ItemStack>();
            roadArmor.add(new ItemStack((ItemLike)NexusBlocks.ROAD.get()));
            roadArmor.add(new ItemStack((ItemLike)NexusBlocks.ROAD_SLAB.get()));
            roadArmor.addAll(ListHelper.toItemStackListFromItem(NexusLists.ACCELERITE_ARMOR));
            registration.addIngredientInfo(roadArmor, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.nexus.road_armor", (Object[])new Object[]{roadAcceleriteArmorEffectStackAdd})});
        }
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)NexusBlocks.JUMP_PAD.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.nexus.jump_pad")});
        int roadUpgradeEffectStackPerBlock = (Integer)NexusConfig.server.roadUpgradeEffectStackPerBlock.get();
        int jumpPadUpgradeEffectStackPerBlock = (Integer)NexusConfig.server.jumpPadUpgradeEffectStackPerBlock.get();
        if (roadUpgradeEffectStackPerBlock > 0 || jumpPadUpgradeEffectStackPerBlock > 0) {
            registration.addIngredientInfo(List.of(new ItemStack((ItemLike)NexusBlocks.ROAD.get()), new ItemStack((ItemLike)NexusBlocks.ROAD_SLAB.get()), new ItemStack((ItemLike)NexusBlocks.JUMP_PAD.get()), new ItemStack((ItemLike)NexusBlocks.CHARGED_ACCELERITE_BLOCK.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"description.nexus.road_upgrade", (Object[])new Object[]{roadUpgradeEffectStackPerBlock, jumpPadUpgradeEffectStackPerBlock})});
        }
    }

    public ResourceLocation getPluginUid() {
        return NexusRef.rl("jei_plugin");
    }
}

