/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.compat;

import com.calemi.nexus.block.entity.NexusPortalCoreBlockEntity;
import com.calemi.nexus.compat.NexusJadePlugin;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum NexusJadePortalCoreProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    @OnlyIn(value=Dist.CLIENT)
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        NexusJadePortalCoreProvider.getTooltip(tooltip, accessor, config);
    }

    public static void getTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag tag = accessor.getServerData();
        if (tag.getBoolean("HasPortalCoreAtDestination")) {
            if (tag.contains("DestinationPosX") && tag.contains("DestinationPosY") && tag.contains("DestinationPosZ") && tag.contains("DestinationDimPath")) {
                BlockPos destinationPos = new BlockPos(tag.getInt("DestinationPosX"), tag.getInt("DestinationPosY"), tag.getInt("DestinationPosZ"));
                tooltip.add((Component)NexusPortalCoreBlockEntity.getFormattedCurrentDestinationText().append(": "));
                tooltip.add((Component)Component.literal((String)"- ").append((Component)NexusPortalCoreBlockEntity.getFormattedDestinationNameText(tag.getString("DestinationPOIName"), tag.getString("DestinationDimPath"), ChatFormatting.GOLD, ChatFormatting.GRAY)));
                tooltip.add((Component)Component.literal((String)"- ").append((Component)NexusPortalCoreBlockEntity.getFormattedDestinationPositionText(destinationPos, ChatFormatting.GOLD, ChatFormatting.GRAY)));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"screen.nexus.nexus_portal_core.text.no_destination"));
        }
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        NexusJadePortalCoreProvider.getServerData(data, (NexusPortalCoreBlockEntity)accessor.getBlockEntity());
    }

    public static void getServerData(CompoundTag data, NexusPortalCoreBlockEntity coreBlockEntity) {
        data.putBoolean("HasPortalCoreAtDestination", coreBlockEntity.hasPortalCoreAtDestination());
        if (coreBlockEntity.hasPortalCoreAtDestination()) {
            NexusPortalCoreBlockEntity destinationBlockEntity;
            if (coreBlockEntity.getDestinationPos() != null) {
                data.putInt("DestinationPosX", coreBlockEntity.getDestinationPos().getX());
                data.putInt("DestinationPosY", coreBlockEntity.getDestinationPos().getY());
                data.putInt("DestinationPosZ", coreBlockEntity.getDestinationPos().getZ());
            }
            if (coreBlockEntity.getDestinationDimensionRL() != null) {
                data.putString("DestinationDimPath", coreBlockEntity.getDestinationDimensionRL().getPath());
            }
            if ((destinationBlockEntity = coreBlockEntity.getDestinationPortalCore()) != null && destinationBlockEntity.getPoiName() != null) {
                data.putString("DestinationPOIName", destinationBlockEntity.getPoiName().getString());
            }
        }
    }

    public ResourceLocation getUid() {
        return NexusJadePlugin.NEXUS_PORTAL_CORE;
    }
}

