/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.config;

import com.calemi.ccore.api.string.StringHelper;
import com.calemi.nexus.main.Nexus;
import com.calemi.nexus.world.dimension.NexusDimensions;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class NexusConfig {
    private static final ModConfigSpec.Builder CLIENT_BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.Builder SERVER_BUILDER = new ModConfigSpec.Builder();
    public static final CategoryClient client = new CategoryClient(CLIENT_BUILDER);
    public static final CategoryServer server = new CategoryServer(SERVER_BUILDER);

    public static void init() {
        Nexus.MOD_CONTAINER.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_BUILDER.build());
        Nexus.MOD_CONTAINER.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_BUILDER.build());
    }

    private static ModConfigSpec.IntValue portalCoreCoordinateScale(ModConfigSpec.Builder builder, String typeKey, int defaultValue) {
        String camelCaseName = typeKey + "PortalCoreCoordinateScale";
        String titleName = StringHelper.camelToTitle((String)camelCaseName);
        return NexusConfig.intValue(builder, camelCaseName, defaultValue, 1, 1000000, "The distance in the Nexus, that will be multiplied by this value when determining the outside destination.", "For example: setting this value to 8 and placing the core in the Nexus at x100, z100 will bring you to x800, z800 in the outside dimension.");
    }

    private static ModConfigSpec.IntValue maxAccelerationEffectStack(ModConfigSpec.Builder builder, String toolTypeTitle, int defaultValue) {
        String camelCaseName = "maxAccelerite" + toolTypeTitle + "EffectStack";
        return NexusConfig.intValue(builder, camelCaseName, defaultValue, 0, 256, "The maximum Acceleration effect stacks that can be obtained by Accelerite " + toolTypeTitle + ".", "Set to 0 to disable the effect being applied from this item.");
    }

    private static ModConfigSpec.IntValue accelerationEffectDuration(ModConfigSpec.Builder builder, String toolTypeTitle, int defaultValue) {
        String camelCaseName = "accelerite" + toolTypeTitle + "EffectDuration";
        return NexusConfig.intValue(builder, camelCaseName, defaultValue, 0, Integer.MAX_VALUE, "The duration of the Acceleration effect obtained by Accelerite " + toolTypeTitle + ".", "Set to 0 to disable the effect being applied from this item.");
    }

    private static ModConfigSpec.DoubleValue acceleriteRepairSpeedRequirement(ModConfigSpec.Builder builder, String toolTypeTitle, double defaultValue) {
        String camelCaseName = "accelerite" + toolTypeTitle + "RepairSpeedRequirement";
        return NexusConfig.doubleValue(builder, camelCaseName, defaultValue, 0.0, Double.MAX_VALUE, "The player's speed requirement in order to repair Accelerite " + toolTypeTitle + ".", "Set to 0 to prevent repairing by speed charging for this item.");
    }

    private static ModConfigSpec.BooleanValue booleanValue(ModConfigSpec.Builder builder, String camelCaseName, boolean defaultValue, String ... desc) {
        return NexusConfig.startBuilder(builder, camelCaseName, desc).define(camelCaseName, defaultValue);
    }

    private static ModConfigSpec.IntValue intValue(ModConfigSpec.Builder builder, String camelCaseName, int defaultValue, int min, int max, String ... desc) {
        return NexusConfig.startBuilder(builder, camelCaseName, desc).defineInRange(camelCaseName, defaultValue, min, max);
    }

    private static ModConfigSpec.DoubleValue doubleValue(ModConfigSpec.Builder builder, String camelCaseName, double defaultValue, double min, double max, String ... desc) {
        return NexusConfig.startBuilder(builder, camelCaseName, desc).defineInRange(camelCaseName, defaultValue, min, max);
    }

    private static ModConfigSpec.ConfigValue<List<? extends String>> stringListValue(ModConfigSpec.Builder builder, String camelCaseName, List<String> defaultValues, String ... desc) {
        return NexusConfig.startBuilder(builder, camelCaseName, desc).defineListAllowEmpty(camelCaseName, () -> defaultValues, () -> "", obj -> obj instanceof String);
    }

    private static ModConfigSpec.Builder startBuilder(ModConfigSpec.Builder builder, String camelCaseName, String ... desc) {
        return builder.translation(NexusConfig.getPrefixedKey(StringHelper.camelToSnake((String)camelCaseName))).comment(StringHelper.camelToTitle((String)camelCaseName)).comment(desc);
    }

    private static String getPrefixedKey(String suffix) {
        return "config.nexus." + suffix;
    }

    public static boolean isDestinationDimensionAllowed(ResourceLocation outsideDimensionRL) {
        if (outsideDimensionRL.equals((Object)NexusDimensions.NEXUS_RL)) {
            return true;
        }
        boolean isInList = ((List)NexusConfig.server.outsideDimensionList.get()).contains(outsideDimensionRL.toString());
        return (Boolean)NexusConfig.server.outsideDimensionBlacklist.get() != isInList;
    }

    public static class CategoryServer {
        public final ModConfigSpec.ConfigValue<List<? extends String>> outsideDimensionList;
        public final ModConfigSpec.ConfigValue<Boolean> outsideDimensionBlacklist;
        public final ModConfigSpec.ConfigValue<Integer> maxPortalSize;
        public final ModConfigSpec.ConfigValue<Integer> portalTransitionTime;
        public final ModConfigSpec.ConfigValue<Boolean> nexusPortalCoreCamo;
        public final ModConfigSpec.ConfigValue<Integer> nexusPortalCoreCoordinateScale;
        public final ModConfigSpec.ConfigValue<Integer> ironPortalCoreCoordinateScale;
        public final ModConfigSpec.ConfigValue<Integer> goldPortalCoreCoordinateScale;
        public final ModConfigSpec.ConfigValue<Integer> diamondPortalCoreCoordinateScale;
        public final ModConfigSpec.ConfigValue<Integer> netheritePortalCoreCoordinateScale;
        public final ModConfigSpec.ConfigValue<Integer> starlightPortalCoreCoordinateScale;
        public final ModConfigSpec.ConfigValue<Integer> roadBaseEffectStack;
        public final ModConfigSpec.ConfigValue<Integer> roadSprintEffectStackAdd;
        public final ModConfigSpec.ConfigValue<Integer> roadAcceleriteArmorEffectStackAdd;
        public final ModConfigSpec.ConfigValue<Integer> roadUpgradeEffectStackPerBlock;
        public final ModConfigSpec.ConfigValue<Integer> jumpPadBaseEffectStack;
        public final ModConfigSpec.ConfigValue<Integer> jumpPadUpgradeEffectStackPerBlock;
        public final ModConfigSpec.ConfigValue<Double> acceleriteOreFromMovingWarpslateChance;
        public final ModConfigSpec.ConfigValue<Double> dormantAcceleriteIngotChargeSpeedRequirement;
        public final ModConfigSpec.ConfigValue<Integer> maxAcceleriteSwordEffectStack;
        public final ModConfigSpec.ConfigValue<Integer> maxAcceleriteShovelEffectStack;
        public final ModConfigSpec.ConfigValue<Integer> maxAcceleritePickaxeEffectStack;
        public final ModConfigSpec.ConfigValue<Integer> maxAcceleriteAxeEffectStack;
        public final ModConfigSpec.ConfigValue<Integer> maxAcceleriteHoeEffectStack;
        public final ModConfigSpec.ConfigValue<Integer> maxAcceleriteArmorEffectStack;
        public final ModConfigSpec.ConfigValue<Integer> maxAccelerationEnchantEffectStack;
        public final ModConfigSpec.ConfigValue<Integer> acceleriteSwordEffectDuration;
        public final ModConfigSpec.ConfigValue<Integer> acceleriteShovelEffectDuration;
        public final ModConfigSpec.ConfigValue<Integer> acceleritePickaxeEffectDuration;
        public final ModConfigSpec.ConfigValue<Integer> acceleriteAxeEffectDuration;
        public final ModConfigSpec.ConfigValue<Integer> acceleriteHoeEffectDuration;
        public final ModConfigSpec.ConfigValue<Integer> acceleriteArmorEffectDuration;
        public final ModConfigSpec.ConfigValue<Integer> accelerationEnchantEffectDuration;
        public final ModConfigSpec.ConfigValue<Double> acceleriteSwordRepairSpeedRequirement;
        public final ModConfigSpec.ConfigValue<Double> acceleriteShovelRepairSpeedRequirement;
        public final ModConfigSpec.ConfigValue<Double> acceleritePickaxeRepairSpeedRequirement;
        public final ModConfigSpec.ConfigValue<Double> acceleriteAxeRepairSpeedRequirement;
        public final ModConfigSpec.ConfigValue<Double> acceleriteHoeRepairSpeedRequirement;
        public final ModConfigSpec.ConfigValue<Double> acceleriteArmorRepairSpeedRequirement;
        public final ModConfigSpec.ConfigValue<Double> accelerationEnchantRepairSpeedRequirement;

        public CategoryServer(ModConfigSpec.Builder builder) {
            this.outsideDimensionList = NexusConfig.stringListValue(builder, "outsideDimensionList", List.of("minecraft:overworld", "minecraft:the_nether", "minecraft:the_end"), "Used to prevent or allow certain dimensions from being used as an outside dimension for Nexus Portal Cores.", "Outside dimensions are destinations that entities end up at when using a Nexus Portal Core to teleport from the Nexus.", "Entries must be in resource location format (modname:dimension_name)", "Can be used as a blacklist or whitelist.");
            this.outsideDimensionBlacklist = NexusConfig.booleanValue(builder, "outsideDimensionBlacklist", false, "Changes the Outside Dimension List (above) to prevent all listed dimensions from use instead of allowing.");
            this.maxPortalSize = NexusConfig.intValue(builder, "maxPortalSize", 1024, 1, 4096, "The max size (in total blocks) a Nexus Portal can be.");
            this.portalTransitionTime = NexusConfig.intValue(builder, "portalTransitionTime", 80, 1, Integer.MAX_VALUE, "The time (in ticks) it takes for a player to stand in the portal to teleport.", "Set to 1 for instant teleport.", "If you are having a bug that's causing an infinite transition time, try dyeing the portal block to update it.");
            this.nexusPortalCoreCamo = NexusConfig.booleanValue(builder, "nexusPortalCoreCamo", true, "Enables the ability to camouflage a Nexus Portal Core with any full-block of your choosing.");
            this.nexusPortalCoreCoordinateScale = NexusConfig.portalCoreCoordinateScale(builder, "nexus", 1);
            this.ironPortalCoreCoordinateScale = NexusConfig.portalCoreCoordinateScale(builder, "iron", 8);
            this.goldPortalCoreCoordinateScale = NexusConfig.portalCoreCoordinateScale(builder, "gold", 16);
            this.diamondPortalCoreCoordinateScale = NexusConfig.portalCoreCoordinateScale(builder, "diamond", 32);
            this.netheritePortalCoreCoordinateScale = NexusConfig.portalCoreCoordinateScale(builder, "netherite", 64);
            this.starlightPortalCoreCoordinateScale = NexusConfig.portalCoreCoordinateScale(builder, "starlight", 128);
            this.roadBaseEffectStack = NexusConfig.intValue(builder, "roadBaseEffectStack", 2, 0, 256, "The base effect stack Roads grant.");
            this.roadSprintEffectStackAdd = NexusConfig.intValue(builder, "roadSprintEffectStackAdd", 2, 0, 256, "The added effect stack Roads grant when sprinting.");
            this.roadAcceleriteArmorEffectStackAdd = NexusConfig.intValue(builder, "roadAcceleriteArmorEffectStackAdd", 2, 0, 256, "The added effect stack Roads grant when wearing a full set of Accelerite Armor.");
            this.roadUpgradeEffectStackPerBlock = NexusConfig.intValue(builder, "roadUpgradeEffectStackPerBlock", 1, 0, 256, "The effect stack per Accelerite Block placed under Roads.", "Set to 0 to disable upgrading Roads.");
            this.jumpPadBaseEffectStack = NexusConfig.intValue(builder, "jumpPadBaseEffectStack", 4, 0, 256, "The base effect stack Jump Pads grant.");
            this.jumpPadUpgradeEffectStackPerBlock = NexusConfig.intValue(builder, "jumpPadUpgradeEffectStackPerBlock", 1, 0, 256, "The effect stack per Accelerite Block placed under Jump Pads.", "Set to 0 to disable upgrading Jump Pads.");
            this.acceleriteOreFromMovingWarpslateChance = NexusConfig.doubleValue(builder, "acceleriteOreFromMovingWarpslateChance", 0.001, 0.0, 1.0, "The chance when Warpslate is moved by a piston to convert into Accelerite Ore.");
            this.dormantAcceleriteIngotChargeSpeedRequirement = NexusConfig.doubleValue(builder, "dormantAcceleriteIngotChargeSpeedRequirement", 1.0, 0.001, Double.MAX_VALUE, "The player's speed requirement in order to charge a Dormant Accelerite Ingot.");
            this.maxAcceleriteSwordEffectStack = NexusConfig.maxAccelerationEffectStack(builder, "Sword", 10);
            this.maxAcceleriteShovelEffectStack = NexusConfig.maxAccelerationEffectStack(builder, "Shovel", 10);
            this.maxAcceleritePickaxeEffectStack = NexusConfig.maxAccelerationEffectStack(builder, "Pickaxe", 10);
            this.maxAcceleriteAxeEffectStack = NexusConfig.maxAccelerationEffectStack(builder, "Axe", 10);
            this.maxAcceleriteHoeEffectStack = NexusConfig.maxAccelerationEffectStack(builder, "Hoe", 10);
            this.maxAcceleriteArmorEffectStack = NexusConfig.maxAccelerationEffectStack(builder, "Armor", 10);
            this.maxAccelerationEnchantEffectStack = NexusConfig.intValue(builder, "maxAccelerationEnchantEffectStack", 10, 0, 256, "The maximum Acceleration effect stacks that can be obtained by items enchanted with Acceleration.", "Set to 0 to disable the enchantment's functionality.");
            this.acceleriteSwordEffectDuration = NexusConfig.accelerationEffectDuration(builder, "Sword", 100);
            this.acceleriteShovelEffectDuration = NexusConfig.accelerationEffectDuration(builder, "Shovel", 100);
            this.acceleritePickaxeEffectDuration = NexusConfig.accelerationEffectDuration(builder, "Pickaxe", 100);
            this.acceleriteAxeEffectDuration = NexusConfig.accelerationEffectDuration(builder, "Axe", 100);
            this.acceleriteHoeEffectDuration = NexusConfig.accelerationEffectDuration(builder, "Hoe", 100);
            this.acceleriteArmorEffectDuration = NexusConfig.accelerationEffectDuration(builder, "Armor", 100);
            this.accelerationEnchantEffectDuration = NexusConfig.intValue(builder, "accelerationEnchantEffectDuration", 100, 0, Integer.MAX_VALUE, "The duration of the Acceleration effect obtained by items enchanted with Acceleration.", "The duration value is multiplied by the stack of the Acceleration enchantment.", "Set to 0 to disable the enchantment's functionality.");
            this.acceleriteSwordRepairSpeedRequirement = NexusConfig.acceleriteRepairSpeedRequirement(builder, "Sword", 0.5);
            this.acceleriteShovelRepairSpeedRequirement = NexusConfig.acceleriteRepairSpeedRequirement(builder, "Shovel", 0.5);
            this.acceleritePickaxeRepairSpeedRequirement = NexusConfig.acceleriteRepairSpeedRequirement(builder, "Pickaxe", 0.5);
            this.acceleriteAxeRepairSpeedRequirement = NexusConfig.acceleriteRepairSpeedRequirement(builder, "Axe", 0.5);
            this.acceleriteHoeRepairSpeedRequirement = NexusConfig.acceleriteRepairSpeedRequirement(builder, "Hoe", 0.5);
            this.acceleriteArmorRepairSpeedRequirement = NexusConfig.acceleriteRepairSpeedRequirement(builder, "Armor", 0.5);
            this.accelerationEnchantRepairSpeedRequirement = NexusConfig.doubleValue(builder, "accelerationEnchantRepairSpeedRequirement", 0.5, 0.0, Double.MAX_VALUE, "The player's speed requirement in order to repair items enchanted with Acceleration.", "Set to 0 to disable the enchantment's functionality.");
        }
    }

    public static class CategoryClient {
        public final ModConfigSpec.ConfigValue<Boolean> portalCoreHUDOverlay;
        public final ModConfigSpec.ConfigValue<Boolean> portalCoreWorldOverlay;

        public CategoryClient(ModConfigSpec.Builder builder) {
            this.portalCoreHUDOverlay = NexusConfig.booleanValue(builder, "portalCoreHUDOverlay", true, "Enables the HUD overlay text above the action bar.", "This overlay shows the destination coordinates of the Nexus Portal Core if placed where standing.");
            this.portalCoreWorldOverlay = NexusConfig.booleanValue(builder, "portalCoreWorldOverlay", true, "Enables the HUD overlay text above the action bar.", "Enables the lines that show the bounds that are equivalent to a single block in the Nexus.");
        }
    }
}

