/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.datagen;

import com.calemi.ccore.api.block.family.CBlockFamily;
import com.calemi.nexus.block.NexusBlocks;
import com.calemi.nexus.block.family.NexusBlockFamilies;
import com.calemi.nexus.item.NexusItems;
import com.calemi.nexus.main.Nexus;
import com.calemi.nexus.util.NexusLists;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class NexusBlockLootTableProvider
extends BlockLootSubProvider {
    protected NexusBlockLootTableProvider(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    protected void generate() {
        Nexus.LOGGER.debug("Generating: Block Loot Tables - Start");
        NexusBlockFamilies.ALL.forEach(family -> {
            Nexus.LOGGER.debug("Generating: Block Family Loot Tables - Start");
            family.getMembers().forEach((type, member) -> {
                Nexus.LOGGER.debug("Generating block loot table for {}", (Object)member.getBlock());
                if (!member.genLootTable()) {
                    Nexus.LOGGER.debug(" - skip");
                    return;
                }
                if (type.equals((Object)CBlockFamily.MemberType.DOOR)) {
                    this.add(member.getBlock(), this.createDoorTable(member.getBlock()));
                    Nexus.LOGGER.debug(" - door drop");
                    return;
                }
                Nexus.LOGGER.debug(" - self drop");
                this.dropSelf(member.getBlock());
            });
            Nexus.LOGGER.debug("Generating: Block Family Loot Tables - End");
        });
        NexusLists.ALL_BLOCKS_BUT_FAMILIES.forEach(block -> {
            if (NexusLists.NEXUS_PORTAL_BLOCKS.contains(block)) {
                this.add((Block)block, NexusBlockLootTableProvider.noDrop());
                return;
            }
            Block chronowarpedGrass = (Block)NexusBlocks.CHRONOWARPED_GRASS.get();
            if (block.equals(chronowarpedGrass)) {
                this.add(chronowarpedGrass, this.createSingleItemTableWithSilkTouch(chronowarpedGrass, (ItemLike)NexusBlocks.CHRONOWARPED_DIRT.get()));
                return;
            }
            Block buddingChrono = (Block)NexusBlocks.BUDDING_CHRONO.get();
            if (block.equals(buddingChrono)) {
                this.add(buddingChrono, NexusBlockLootTableProvider.noDrop());
                return;
            }
            if (NexusLists.CHRONO_CLUSTER_BLOCKS.contains(block)) {
                Block chronoCluster = (Block)NexusBlocks.CHRONO_CLUSTER.get();
                if (block.equals(chronoCluster)) {
                    this.add(chronoCluster, this.createSingleItemTableWithSilkTouch(chronoCluster, (ItemLike)NexusItems.CHRONO_SHARD));
                    return;
                }
                this.add((Block)block, this.createSingleItemTableWithSilkTouch(chronoCluster, (ItemLike)NexusItems.CHRONO_SHARD_FRAGMENT));
                return;
            }
            Block warpslate = (Block)NexusBlocks.WARPSLATE.get();
            if (block.equals(warpslate)) {
                this.add(warpslate, this.createSingleItemTableWithSilkTouch(warpslate, (ItemLike)NexusBlocks.COBBLED_WARPSLATE.get()));
                return;
            }
            Block warpslateAcceleriteOre = (Block)NexusBlocks.WARPSLATE_ACCELERITE_ORE.get();
            if (block.equals(warpslateAcceleriteOre)) {
                this.add(warpslateAcceleriteOre, this.createOreDrop(warpslateAcceleriteOre, (Item)NexusItems.RAW_ACCELERITE.get()));
                return;
            }
            Block pottedWarpblossomSapling = (Block)NexusBlocks.POTTED_WARPBLOSSOM_SAPLING.get();
            if (block.equals(pottedWarpblossomSapling)) {
                this.add(pottedWarpblossomSapling, this.createPotFlowerItemTable((ItemLike)NexusBlocks.WARPBLOSSOM_SAPLING));
                return;
            }
            Block warpblossomLeaves = (Block)NexusBlocks.WARPBLOSSOM_LEAVES.get();
            if (block.equals(warpblossomLeaves)) {
                this.add(warpblossomLeaves, this.createLeavesDrops(warpblossomLeaves, (Block)NexusBlocks.WARPBLOSSOM_SAPLING.get(), NORMAL_LEAVES_SAPLING_CHANCES));
                return;
            }
            Block purplePetals = (Block)NexusBlocks.PURPLE_PETALS.get();
            if (block.equals(purplePetals)) {
                this.add(purplePetals, this.createPetalsDrops(purplePetals));
                return;
            }
            this.dropSelf((Block)block);
        });
        Nexus.LOGGER.debug("Generating: Block Loot Tables - End");
    }

    protected Iterable<Block> getKnownBlocks() {
        return NexusBlocks.BLOCKS.getEntries().stream().map(Holder::value)::iterator;
    }
}

