/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.datagen;

import com.calemi.ccore.api.block.family.CBlockFamily;
import com.calemi.ccore.api.block.family.CBlockFamilyMember;
import com.calemi.ccore.api.datagen.CBlockStateProvider;
import com.calemi.nexus.block.NexusBlocks;
import com.calemi.nexus.block.NexusPortalBlock;
import com.calemi.nexus.block.family.NexusBlockFamilies;
import com.calemi.nexus.util.NexusLists;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class NexusBlockStateProvider
extends CBlockStateProvider {
    public NexusBlockStateProvider(PackOutput output, ExistingFileHelper fileHelper) {
        super("nexus", output, fileHelper);
    }

    protected void registerStatesAndModels() {
        NexusBlockFamilies.ALL.forEach(family -> family.getMembers().forEach((type, member) -> this.family((CBlockFamily)family, (CBlockFamily.MemberType)type, (CBlockFamilyMember)member)));
        NexusLists.NEXUS_PORTAL_CORE_BLOCKS.forEach(this::nexusPortalCore);
        NexusLists.NEXUS_PORTAL_BLOCKS.forEach(this::nexusPortal);
        this.roadBlock((Block)NexusBlocks.ROAD.get());
        this.roadBlockSlab((Block)NexusBlocks.ROAD_SLAB.get(), (Block)NexusBlocks.ROAD.get());
        this.roadBlock((Block)NexusBlocks.JUMP_PAD.get());
        this.grass((Block)NexusBlocks.CHRONOWARPED_GRASS.get(), (Block)NexusBlocks.CHRONOWARPED_DIRT.get());
        this.all((Block)NexusBlocks.CHRONOWARPED_DIRT.get());
        this.all((Block)NexusBlocks.CHRONOWARPED_SAND.get());
        this.all((Block)NexusBlocks.CHRONO_BLOCK.get());
        this.all((Block)NexusBlocks.BUDDING_CHRONO.get());
        this.crystal((Block)NexusBlocks.SMALL_CHRONO_BUD.get());
        this.crystal((Block)NexusBlocks.MEDIUM_CHRONO_BUD.get());
        this.crystal((Block)NexusBlocks.LARGE_CHRONO_BUD.get());
        this.crystal((Block)NexusBlocks.CHRONO_CLUSTER.get());
        this.deepslate((RotatedPillarBlock)NexusBlocks.WARPSLATE.get());
        this.all((Block)NexusBlocks.WARPSLATE_ACCELERITE_ORE.get());
        this.all((Block)NexusBlocks.RAW_ACCELERITE_BLOCK.get());
        this.all((Block)NexusBlocks.DORMANT_ACCELERITE_BLOCK.get());
        this.all((Block)NexusBlocks.CHARGED_ACCELERITE_BLOCK.get());
        this.allCutout((Block)NexusBlocks.WARPBLOSSOM_LEAVES.get());
        this.sapling((Block)NexusBlocks.WARPBLOSSOM_SAPLING.get());
        this.flowerPot((Block)NexusBlocks.POTTED_WARPBLOSSOM_SAPLING.get(), (Block)NexusBlocks.WARPBLOSSOM_SAPLING.get());
        this.petal((Block)NexusBlocks.PURPLE_PETALS.get());
    }

    private void roadBlock(Block block) {
        String blockName = this.name(block);
        String blockPath = "block/" + blockName;
        ModelFile.UncheckedModelFile model = new ModelFile.UncheckedModelFile(this.rl(blockPath));
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        this.simpleBlockItem(block, (ModelFile)model);
    }

    private void roadBlockSlab(Block block, Block doubleSlabBlock) {
        String blockName = this.name(block);
        String doubleSlabBlockName = this.name(doubleSlabBlock);
        String blockPath = "block/" + blockName;
        String doubleSlabBlockPath = "block/" + doubleSlabBlockName;
        ModelFile.UncheckedModelFile bottomModel = new ModelFile.UncheckedModelFile(this.rl(blockPath));
        ModelFile.UncheckedModelFile topModel = new ModelFile.UncheckedModelFile(this.rl(blockPath + "_top"));
        ModelFile.UncheckedModelFile doubleModel = new ModelFile.UncheckedModelFile(this.rl(doubleSlabBlockPath));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.BOTTOM).modelForState().modelFile((ModelFile)bottomModel).addModel()).partialState().with((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.TOP).modelForState().modelFile((ModelFile)topModel).addModel()).partialState().with((Property)BlockStateProperties.SLAB_TYPE, (Comparable)SlabType.DOUBLE).modelForState().modelFile((ModelFile)doubleModel).addModel();
        this.simpleBlockItem(block, (ModelFile)bottomModel);
    }

    private void nexusPortalCore(Block block) {
        String blockName = this.name(block);
        ResourceLocation modelTextureSide = this.texture(block, "block/", "_side");
        ResourceLocation modelTextureTop = this.texture(block, "block/", "_top");
        ModelBuilder model = this.models().cubeTop(blockName, modelTextureSide, modelTextureTop);
        this.getVariantBuilder(block).forAllStates(arg_0 -> NexusBlockStateProvider.lambda$nexusPortalCore$2((ModelFile)model, arg_0));
        this.simpleBlockItem(block, (ModelFile)model);
    }

    private void nexusPortal(Block block) {
        String blockName = this.name(block);
        String modelParent = "nexus:block/nexus_portal";
        ResourceLocation modelTexture = this.texture(block, "block/");
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(blockName, modelParent)).texture("particle", modelTexture)).texture("portal", modelTexture)).renderType("translucent");
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with(NexusPortalBlock.AXIS, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)model).rotationX(90).rotationY(90).addModel()).partialState().with(NexusPortalBlock.AXIS, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)model).rotationX(90).addModel()).partialState().with(NexusPortalBlock.AXIS, (Comparable)Direction.Axis.Y).modelForState().modelFile((ModelFile)model).addModel();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$nexusPortalCore$2(ModelFile model, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
        return ConfiguredModel.builder().modelFile(model).rotationX(facing == Direction.DOWN ? 180 : (facing.getAxis().isHorizontal() ? 90 : 0)).rotationY(facing.getAxis().isVertical() ? (axis == Direction.Axis.Z ? 90 : 0) : ((int)facing.toYRot() + 180) % 360).build();
    }
}

