/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.datagen;

import com.calemi.ccore.api.block.family.CBlockFamily;
import com.calemi.ccore.api.list.ListHelper;
import com.calemi.nexus.block.NexusBlocks;
import com.calemi.nexus.block.family.NexusBlockFamilies;
import com.calemi.nexus.tag.NexusTags;
import com.calemi.nexus.util.NexusLists;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class NexusBlockTagProvider
extends BlockTagsProvider {
    public NexusBlockTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "nexus", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.tag(NexusTags.Blocks.DIRTLIKE).add((Object)((Block)NexusBlocks.CHRONOWARPED_GRASS.get())).add((Object)((Block)NexusBlocks.CHRONOWARPED_DIRT.get())).add((Object)((Block)NexusBlocks.CHRONOWARPED_SAND.get()));
        this.tag(NexusTags.Blocks.STONELIKE).add((Object)((Block)NexusBlocks.CHRONO_BLOCK.get())).add((Object)((Block)NexusBlocks.BUDDING_CHRONO.get())).add((Object)((Block)NexusBlocks.WARPSLATE.get())).add((Object)((Block)NexusBlocks.WARPSLATE_ACCELERITE_ORE.get())).addOptionalTag(NexusTags.Blocks.NEXUS_PORTAL_CORES).addOptionalTag(NexusTags.Blocks.ROADLIKE).addAll(ListHelper.toBlockResourceKeyList(NexusLists.CHRONO_CLUSTER_BLOCKS));
        this.tag(NexusTags.Blocks.WARPBLOSSOM_LOGS).add((Object)((Block)NexusBlocks.WARPBLOSSOM_LOG.get())).add((Object)((Block)NexusBlocks.WARPBLOSSOM_WOOD.get())).add((Object)((Block)NexusBlocks.STRIPPED_WARPBLOSSOM_LOG.get())).add((Object)((Block)NexusBlocks.STRIPPED_WARPBLOSSOM_WOOD.get()));
        this.tag(NexusTags.Blocks.WOODLIKE).addOptionalTag(NexusTags.Blocks.WARPBLOSSOM_LOGS);
        this.tag(NexusTags.Blocks.ROADLIKE).add((Object)((Block)NexusBlocks.ROAD.get())).add((Object)((Block)NexusBlocks.ROAD_SLAB.get())).add((Object)((Block)NexusBlocks.JUMP_PAD.get()));
        this.tag(NexusTags.Blocks.NEXUS_PORTAL_CORES).addAll(ListHelper.toBlockResourceKeyList(NexusLists.NEXUS_PORTAL_CORE_BLOCKS));
        this.tag(NexusTags.Blocks.NEXUS_PORTALS).addAll(ListHelper.toBlockResourceKeyList(NexusLists.NEXUS_PORTAL_BLOCKS));
        this.tag(NexusTags.Blocks.UPGRADES_ROAD_BLOCK).add((Object)((Block)NexusBlocks.CHARGED_ACCELERITE_BLOCK.get()));
        this.tag(NexusTags.Blocks.NEEDS_ACCELERITE_TOOL).addTag(BlockTags.NEEDS_IRON_TOOL);
        this.tag(NexusTags.Blocks.INCORRECT_FOR_ACCELERITE_TOOL).addTag(BlockTags.INCORRECT_FOR_IRON_TOOL).remove(NexusTags.Blocks.NEEDS_ACCELERITE_TOOL);
        NexusBlockFamilies.ALL.forEach(family -> family.getMembers().forEach((type, member) -> {
            if (!member.genBlockTags()) {
                return;
            }
            Block block = member.getBlock();
            if (family.getFamilyType().isStone()) {
                this.tag(NexusTags.Blocks.STONELIKE).add((Object)block);
            }
            if (family.getFamilyType() == CBlockFamily.FamilyType.PLANKS) {
                this.tag(NexusTags.Blocks.WOODLIKE).add((Object)block);
            }
            if (type.equals((Object)CBlockFamily.MemberType.BASE) && family.getFamilyType() == CBlockFamily.FamilyType.PLANKS) {
                this.tag(BlockTags.PLANKS).add((Object)block);
            }
            if (type.equals((Object)CBlockFamily.MemberType.LOG)) {
                this.tag(BlockTags.LOGS_THAT_BURN).add((Object)block);
            }
            if (type.equals((Object)CBlockFamily.MemberType.WOOD)) {
                this.tag(BlockTags.LOGS_THAT_BURN).add((Object)block);
            }
            if (type.equals((Object)CBlockFamily.MemberType.STRIPPED_LOG)) {
                this.tag(BlockTags.LOGS_THAT_BURN).add((Object)block);
                this.tag(Tags.Blocks.STRIPPED_LOGS).add((Object)block);
            }
            if (type.equals((Object)CBlockFamily.MemberType.STRIPPED_WOOD)) {
                this.tag(BlockTags.LOGS_THAT_BURN).add((Object)block);
                this.tag(Tags.Blocks.STRIPPED_WOODS).add((Object)block);
            }
            if (type.equals((Object)CBlockFamily.MemberType.STAIRS)) {
                this.tag(BlockTags.STAIRS).add((Object)block);
                if (family.getFamilyType() == CBlockFamily.FamilyType.PLANKS) {
                    this.tag(BlockTags.WOODEN_STAIRS).add((Object)block);
                }
            }
            if (type.equals((Object)CBlockFamily.MemberType.SLAB)) {
                this.tag(BlockTags.SLABS).add((Object)block);
                if (family.getFamilyType() == CBlockFamily.FamilyType.PLANKS) {
                    this.tag(BlockTags.WOODEN_SLABS).add((Object)block);
                }
            }
            if (type.equals((Object)CBlockFamily.MemberType.WALL)) {
                this.tag(BlockTags.WALLS).add((Object)block);
            }
            if (type.equals((Object)CBlockFamily.MemberType.FENCE)) {
                this.tag(BlockTags.FENCES).add((Object)block);
                this.tag(Tags.Blocks.FENCES).add((Object)block);
                if (family.getFamilyType() == CBlockFamily.FamilyType.PLANKS) {
                    this.tag(BlockTags.WOODEN_FENCES).add((Object)block);
                    this.tag(Tags.Blocks.FENCES_WOODEN).add((Object)block);
                }
            }
            if (type.equals((Object)CBlockFamily.MemberType.FENCE_GATE)) {
                this.tag(BlockTags.FENCE_GATES).add((Object)block);
                this.tag(Tags.Blocks.FENCE_GATES).add((Object)block);
                if (family.getFamilyType() == CBlockFamily.FamilyType.PLANKS) {
                    this.tag(Tags.Blocks.FENCE_GATES_WOODEN).add((Object)block);
                }
            }
            if (type.equals((Object)CBlockFamily.MemberType.DOOR)) {
                this.tag(BlockTags.DOORS).add((Object)block);
                if (family.getFamilyType() == CBlockFamily.FamilyType.PLANKS) {
                    this.tag(BlockTags.WOODEN_DOORS).add((Object)block);
                }
            }
            if (type.equals((Object)CBlockFamily.MemberType.TRAPDOOR)) {
                this.tag(BlockTags.TRAPDOORS).add((Object)block);
                if (family.getFamilyType() == CBlockFamily.FamilyType.PLANKS) {
                    this.tag(BlockTags.WOODEN_TRAPDOORS).add((Object)block);
                }
            }
            if (type.equals((Object)CBlockFamily.MemberType.PRESSURE_PLATE)) {
                this.tag(BlockTags.PRESSURE_PLATES).add((Object)block);
                if (family.getFamilyType() == CBlockFamily.FamilyType.PLANKS) {
                    this.tag(BlockTags.WOODEN_PRESSURE_PLATES).add((Object)block);
                }
            }
            if (type.equals((Object)CBlockFamily.MemberType.BUTTON)) {
                this.tag(BlockTags.BUTTONS).add((Object)block);
                if (family.getFamilyType() == CBlockFamily.FamilyType.PLANKS) {
                    this.tag(BlockTags.WOODEN_BUTTONS).add((Object)block);
                }
            }
            if (type.equals((Object)CBlockFamily.MemberType.SIGN)) {
                this.tag(BlockTags.STANDING_SIGNS).add((Object)block);
            }
            if (type.equals((Object)CBlockFamily.MemberType.WALL_SIGN)) {
                this.tag(BlockTags.WALL_SIGNS).add((Object)block);
            }
            if (type.equals((Object)CBlockFamily.MemberType.HANGING_SIGN)) {
                this.tag(BlockTags.CEILING_HANGING_SIGNS).add((Object)block);
            }
            if (type.equals((Object)CBlockFamily.MemberType.WALL_HANGING_SIGN)) {
                this.tag(BlockTags.WALL_HANGING_SIGNS).add((Object)block);
            }
        }));
        this.tag(BlockTags.MINEABLE_WITH_SHOVEL).addOptionalTag(NexusTags.Blocks.DIRTLIKE);
        this.tag(BlockTags.MINEABLE_WITH_PICKAXE).addOptionalTag(NexusTags.Blocks.STONELIKE);
        this.tag(BlockTags.MINEABLE_WITH_AXE).addOptionalTag(NexusTags.Blocks.WOODLIKE);
        this.tag(BlockTags.MINEABLE_WITH_HOE).add((Object)((Block)NexusBlocks.WARPBLOSSOM_LEAVES.get()));
        this.tag(BlockTags.SWORD_EFFICIENT).add((Object)((Block)NexusBlocks.PURPLE_PETALS.get()));
        this.tag(BlockTags.NEEDS_STONE_TOOL).addOptionalTag(NexusTags.Blocks.NEXUS_PORTAL_CORES);
        this.tag(BlockTags.NEEDS_IRON_TOOL).add((Object[])new Block[]{(Block)NexusBlocks.WARPSLATE_ACCELERITE_ORE.get(), (Block)NexusBlocks.RAW_ACCELERITE_BLOCK.get(), (Block)NexusBlocks.DORMANT_ACCELERITE_BLOCK.get(), (Block)NexusBlocks.CHARGED_ACCELERITE_BLOCK.get()});
        this.tag(BlockTags.DIRT).add((Object[])new Block[]{(Block)NexusBlocks.CHRONOWARPED_DIRT.get(), (Block)NexusBlocks.CHRONOWARPED_GRASS.get()});
        this.tag(BlockTags.SAND).add((Object)((Block)NexusBlocks.CHRONOWARPED_SAND.get()));
        this.tag(BlockTags.SMELTS_TO_GLASS).add((Object)((Block)NexusBlocks.CHRONOWARPED_SAND.get()));
        this.tag(Tags.Blocks.SANDS).add((Object)((Block)NexusBlocks.CHRONOWARPED_SAND.get()));
        this.tag(Tags.Blocks.ORES).add((Object)((Block)NexusBlocks.WARPSLATE_ACCELERITE_ORE.get()));
        this.tag(Tags.Blocks.STORAGE_BLOCKS).add((Object[])new Block[]{(Block)NexusBlocks.RAW_ACCELERITE_BLOCK.get(), (Block)NexusBlocks.DORMANT_ACCELERITE_BLOCK.get(), (Block)NexusBlocks.CHARGED_ACCELERITE_BLOCK.get()});
        this.tag(BlockTags.SCULK_REPLACEABLE).add((Object)((Block)NexusBlocks.CHRONOWARPED_SAND.get()));
        this.tag(BlockTags.SNIFFER_DIGGABLE_BLOCK).add((Object[])new Block[]{(Block)NexusBlocks.CHRONOWARPED_DIRT.get(), (Block)NexusBlocks.CHRONOWARPED_GRASS.get()});
        this.tag(BlockTags.ANIMALS_SPAWNABLE_ON).add((Object)((Block)NexusBlocks.CHRONOWARPED_GRASS.get()));
        this.tag(Tags.Blocks.COBBLESTONES_DEEPSLATE).add((Object)((Block)NexusBlocks.COBBLED_WARPSLATE.get()));
        this.tag(BlockTags.SNAPS_GOAT_HORN).add((Object)((Block)NexusBlocks.WARPBLOSSOM_LOG.get()));
        this.tag(BlockTags.LEAVES).add((Object)((Block)NexusBlocks.WARPBLOSSOM_LEAVES.get()));
        this.tag(BlockTags.FLOWERS).add((Object)((Block)NexusBlocks.PURPLE_PETALS.get()));
        this.tag(BlockTags.SAPLINGS).add((Object)((Block)NexusBlocks.WARPBLOSSOM_SAPLING.get()));
        this.tag(BlockTags.INSIDE_STEP_SOUND_BLOCKS).add((Object[])new Block[]{(Block)NexusBlocks.PURPLE_PETALS.get(), (Block)NexusBlocks.SMALL_CHRONO_BUD.get()});
        this.tag(BlockTags.MINEABLE_WITH_HOE).add((Object)((Block)NexusBlocks.PURPLE_PETALS.get()));
        this.tag(BlockTags.CRYSTAL_SOUND_BLOCKS).add((Object[])new Block[]{(Block)NexusBlocks.CHRONO_BLOCK.get(), (Block)NexusBlocks.BUDDING_CHRONO.get()});
        this.tag(Tags.Blocks.BUDDING_BLOCKS).add((Object)((Block)NexusBlocks.BUDDING_CHRONO.get()));
        this.tag(Tags.Blocks.BUDS).add((Object[])new Block[]{(Block)NexusBlocks.SMALL_CHRONO_BUD.get(), (Block)NexusBlocks.MEDIUM_CHRONO_BUD.get(), (Block)NexusBlocks.LARGE_CHRONO_BUD.get()});
        this.tag(Tags.Blocks.CLUSTERS).add((Object)((Block)NexusBlocks.CHRONO_CLUSTER.get()));
        this.tag(BlockTags.VIBRATION_RESONATORS).add((Object)((Block)NexusBlocks.CHRONO_BLOCK.get()));
    }
}

