/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.datagen;

import com.calemi.nexus.datagen.NexusBiomeTagProvider;
import com.calemi.nexus.datagen.NexusBlockLootTableProvider;
import com.calemi.nexus.datagen.NexusBlockStateProvider;
import com.calemi.nexus.datagen.NexusBlockTagProvider;
import com.calemi.nexus.datagen.NexusDataMapProvider;
import com.calemi.nexus.datagen.NexusDatapackProvider;
import com.calemi.nexus.datagen.NexusEnchantmentTagsProvider;
import com.calemi.nexus.datagen.NexusEnglishLanguageProvider;
import com.calemi.nexus.datagen.NexusFusionMetadataProvider;
import com.calemi.nexus.datagen.NexusFusionModelProvider;
import com.calemi.nexus.datagen.NexusGlobalLootModifierProvider;
import com.calemi.nexus.datagen.NexusItemModelProvider;
import com.calemi.nexus.datagen.NexusItemTagProvider;
import com.calemi.nexus.datagen.NexusParticleDescriptionProvider;
import com.calemi.nexus.datagen.NexusRecipeProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="nexus", bus=EventBusSubscriber.Bus.MOD)
public class NexusDataGen {
    @SubscribeEvent
    static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = event.getGenerator().getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new NexusEnglishLanguageProvider(output));
        generator.addProvider(event.includeClient(), (DataProvider)new NexusBlockStateProvider(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new NexusFusionModelProvider(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new NexusFusionMetadataProvider(output));
        generator.addProvider(event.includeClient(), (DataProvider)new NexusItemModelProvider(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new NexusParticleDescriptionProvider(output, existingFileHelper));
        NexusDatapackProvider datapackProvider = new NexusDatapackProvider(output, event.getLookupProvider());
        CompletableFuture lookupProvider = datapackProvider.getRegistryProvider();
        NexusBlockTagProvider blockTagProvider = new NexusBlockTagProvider(output, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)datapackProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new NexusDataMapProvider(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)blockTagProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new NexusBiomeTagProvider(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new NexusItemTagProvider(output, lookupProvider, blockTagProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new NexusEnchantmentTagsProvider(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new NexusGlobalLootModifierProvider(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(NexusBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new NexusRecipeProvider(output, lookupProvider));
    }
}

