/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.datagen;

import com.calemi.ccore.api.datagen.CLanguageProvider;
import com.calemi.nexus.block.NexusBlocks;
import com.calemi.nexus.item.NexusItems;
import com.calemi.nexus.main.Nexus;
import com.calemi.nexus.util.NexusLists;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class NexusEnglishLanguageProvider
extends CLanguageProvider {
    private final String CHRONO_UPGRADE = this.getPrefixedKey("item", "smithing_template.chrono_upgrade.");
    private final String ENCHANTMENT = this.getPrefixedKey("enchantment", "");
    private final String SCREEN = this.getPrefixedKey("screen", "");
    private final String SCREEN_NEXUS_PORTAL_CORE = this.SCREEN + "nexus_portal_core.";
    private final String SCREEN_NEXUS_PORTAL_CORE_TEXT = this.SCREEN_NEXUS_PORTAL_CORE + "text.";
    private final String SCREEN_NEXUS_PORTAL_CORE_BUTTON = this.SCREEN_NEXUS_PORTAL_CORE + "button.";
    private final String SCREEN_NEXUS_PORTAL_CORE_BUTTON_DIMENSION_SELECT = this.SCREEN_NEXUS_PORTAL_CORE_BUTTON + "dimension_select.";
    private final String SCREEN_NEXUS_PORTAL_CORE_BUTTON_TELEPORT = this.SCREEN_NEXUS_PORTAL_CORE_BUTTON + "teleport.";
    private final String SCREEN_NEXUS_PORTAL_CORE_BUTTON_FIND_LINK = this.SCREEN_NEXUS_PORTAL_CORE_BUTTON + "find_link.";
    private final String SCREEN_NEXUS_PORTAL_CORE_BUTTON_GENERATE_LINK = this.SCREEN_NEXUS_PORTAL_CORE_BUTTON + "generate_link.";
    private final String SCREEN_NEXUS_PORTAL_CORE_BUTTON_LIGHT_PORTAL = this.SCREEN_NEXUS_PORTAL_CORE_BUTTON + "light_portal.";
    private final String SCREEN_NEXUS_PORTAL_CORE_BUTTON_UNLINK = this.SCREEN_NEXUS_PORTAL_CORE_BUTTON + "unlink.";
    private final String SCREEN_NEXUS_PORTAL_CORE_BUTTON_CLOSE = this.SCREEN_NEXUS_PORTAL_CORE_BUTTON + "close.";
    private final String MESSAGE = this.getPrefixedKey("message", "");
    private final String MESSAGE_TELEPORT = this.MESSAGE + "teleport.";
    private final String MESSAGE_GENERATE_LINK = this.MESSAGE + "generate_link.";
    private final String MESSAGE_FIND_LINK = this.MESSAGE + "find_link.";
    private final String MESSAGE_LIGHT_PORTAL = this.MESSAGE + "light_portal.";
    private final String MESSAGE_UNLINK = this.MESSAGE + "unlink.";
    private final String JEI_DESCRIPTION = this.getPrefixedKey("description", "");
    private final String JADE = "config.jade.plugin_nexus.";

    public NexusEnglishLanguageProvider(PackOutput output) {
        super("nexus", output, "en_us");
    }

    protected void addTranslations() {
        NexusLists.ALL_BLOCKS.forEach(block -> {
            Nexus.LOGGER.debug("Generating en_us for {}", (Object)BuiltInRegistries.BLOCK.getKey(block).getPath());
            if (block.equals(NexusBlocks.WARPBLOSSOM_WALL_SIGN.get())) {
                return;
            }
            if (block.equals(NexusBlocks.WARPBLOSSOM_WALL_HANGING_SIGN.get())) {
                return;
            }
            this.addAutoBlock((Block)block);
        });
        NexusLists.ALL_ITEMS.forEach(item -> {
            if (item.equals(NexusItems.CHRONO_UPGRADE_SMITHING_TEMPLATE.asItem())) {
                this.add((Item)item, "Smithing Template");
                return;
            }
            this.addAutoItem((Item)item);
        });
        this.add(this.getPrefixedKey("upgrade", "smithing_upgrade"), "Chrono Upgrade");
        this.add(this.CHRONO_UPGRADE + "applies_to", "Amethyst Shard");
        this.add(this.CHRONO_UPGRADE + "ingredients", "Ender Pearl");
        this.add(this.CHRONO_UPGRADE + "base_slot_description", "Add Amethyst Shard");
        this.add(this.CHRONO_UPGRADE + "additions_slot_description", "Add Ender Pearl");
        this.add(this.getPrefixedKey("hover_text", "nexus_portal_core"), "Coordinate Scale");
        this.add(this.getPrefixedKey("hover_text", "fallbreakers_1"), "Fall Damage Immunity");
        this.add(this.getPrefixedKey("hover_text", "fallbreakers_2"), "Breaks on Impact");
        this.add(this.ENCHANTMENT + "acceleration", "Acceleration");
        this.add(this.ENCHANTMENT + "acceleration.desc", "Attacking, mining, or taking damage (for armor) applies a stacking effect that increases move, attack, and mining speed.");
        this.add(this.ENCHANTMENT + "speed_mending", "Speed Mending");
        this.add(this.ENCHANTMENT + "speed_mending.desc", "The item is slowly repaired when reaching a certain speed.");
        this.add(this.getPrefixedKey("itemGroup", "main"), "Nexus");
        this.add(this.SCREEN_NEXUS_PORTAL_CORE + "title", "Nexus Portal Core");
        this.add(this.SCREEN_NEXUS_PORTAL_CORE_TEXT + "no_destination", "No Destination");
        this.add(this.SCREEN_NEXUS_PORTAL_CORE_TEXT + "current_destination", "Current Destination");
        this.add(this.SCREEN_NEXUS_PORTAL_CORE_BUTTON_DIMENSION_SELECT + "title", "Target Dimension");
        this.add(this.SCREEN_NEXUS_PORTAL_CORE_BUTTON_DIMENSION_SELECT + "cant_set", "You can only change Target Dimension from The Nexus.");
        this.add(this.SCREEN_NEXUS_PORTAL_CORE_BUTTON_TELEPORT + "title", "Teleport");
        this.add(this.SCREEN_NEXUS_PORTAL_CORE_BUTTON_FIND_LINK + "title", "Find Link");
        this.add(this.SCREEN_NEXUS_PORTAL_CORE_BUTTON_FIND_LINK + "info", "Searches for another core in the target dimension.");
        this.add(this.SCREEN_NEXUS_PORTAL_CORE_BUTTON_GENERATE_LINK + "title", "Generate Link");
        this.add(this.SCREEN_NEXUS_PORTAL_CORE_BUTTON_GENERATE_LINK + "requires", "Requires");
        this.add(this.SCREEN_NEXUS_PORTAL_CORE_BUTTON_GENERATE_LINK + "info", "Creates a new link to the target dimension.");
        this.add(this.SCREEN_NEXUS_PORTAL_CORE_BUTTON_LIGHT_PORTAL + "light_info", "Light Portal");
        this.add(this.SCREEN_NEXUS_PORTAL_CORE_BUTTON_LIGHT_PORTAL + "destroy_info", "Unlight Portal");
        this.add(this.SCREEN_NEXUS_PORTAL_CORE_BUTTON_UNLINK + "info_1", "Unlink");
        this.add(this.SCREEN_NEXUS_PORTAL_CORE_BUTTON_UNLINK + "info_2", "Hold shift to take the linked Nexus Portal Core.");
        this.add(this.SCREEN_NEXUS_PORTAL_CORE_BUTTON_CLOSE + "title", "Close");
        this.add(this.getPrefixedKey("hud", "calculated_destination"), "Calculated Destination");
        this.add(this.getPrefixedKey("hud", "speed"), "Speed");
        this.add(this.getPrefixedKey("effect", "acceleration"), "Acceleration");
        this.add(this.getPrefixedKey("effect", "road"), "Road");
        this.add(this.getPrefixedKey("effect", "jump_pad"), "Jump Pad");
        this.add(this.getPrefixedKey("biome", "chronowarped_fields"), "Chronowarped Fields");
        this.add(this.MESSAGE + "unlock_dimension", "You can now travel to this dimension from The Nexus.");
        this.add(this.MESSAGE + "invalid_dimension", "Destination dimension could not be found!");
        this.add(this.MESSAGE + "invalid_destination", "Destination is outside the world border for that dimension! Removing invalid link...");
        this.add(this.MESSAGE + "no_core", "Destination Nexus Portal Core could not be found! Removing invalid link...");
        this.add(this.MESSAGE + "no_link", "Destination Nexus Portal Core is not linked to this one! Removing invalid link...");
        this.add(this.MESSAGE_TELEPORT + "prohibited_dimension", "You can't travel to this dimension. It is not allowed!");
        this.add(this.MESSAGE_TELEPORT + "locked_dimension", "You can't travel to this dimension. You haven't been there before!");
        this.add(this.MESSAGE_GENERATE_LINK + "no_core", "You do not have a Nexus Portal Core in your main-hand!");
        this.add(this.MESSAGE_GENERATE_LINK + "no_valid_spawn", "Could not find suitable y-level to generate Destination Nexus Portal Core!");
        this.add(this.MESSAGE_GENERATE_LINK + "success", "New link generated successfully!");
        this.add(this.MESSAGE_FIND_LINK + "searching", "Searching for similar Nexus Portal Core...");
        this.add(this.MESSAGE_FIND_LINK + "success", "Found similar Nexus Portal Core and successfully linked to it!");
        this.add(this.MESSAGE_FIND_LINK + "failure", "Could not find similar Nexus Portal Core!");
        this.add(this.MESSAGE_LIGHT_PORTAL + "success", "Successfully created portal!");
        this.add(this.MESSAGE_LIGHT_PORTAL + "obstructed", "The projection position is obstructed!");
        this.add(this.MESSAGE_LIGHT_PORTAL + "overflowing_frame", "The frame size is too large!");
        this.add(this.MESSAGE_LIGHT_PORTAL + "invalid_frame", "Invalid frame! Make sure no non-full blocks are inside or make up the frame!");
        this.add(this.MESSAGE_UNLINK + "success", "Successfully unlinked!");
        this.add(this.getPrefixedKey("networking", "unlocked_dimension_list_message.failed"), "Failed to synchronize unlocked dimension list! %s");
        this.addAutoConfig("portalCoreHUDOverlay");
        this.addAutoConfig("portalCoreWorldOverlay");
        this.addAutoConfig("outsideDimensionList");
        this.addAutoConfig("outsideDimensionBlacklist");
        this.addAutoConfig("maxPortalSize");
        this.addAutoConfig("portalTransitionTime");
        this.addAutoConfig("nexusPortalCoreCamo");
        this.addAutoConfig("nexusPortalCoreCoordinateScale");
        this.addAutoConfig("ironPortalCoreCoordinateScale");
        this.addAutoConfig("goldPortalCoreCoordinateScale");
        this.addAutoConfig("diamondPortalCoreCoordinateScale");
        this.addAutoConfig("netheritePortalCoreCoordinateScale");
        this.addAutoConfig("starlightPortalCoreCoordinateScale");
        this.addAutoConfig("roadBaseEffectStack");
        this.addAutoConfig("roadSprintEffectStackAdd");
        this.addAutoConfig("roadAcceleriteArmorEffectStackAdd");
        this.addAutoConfig("roadUpgradeEffectStackPerBlock");
        this.addAutoConfig("jumpPadBaseEffectStack");
        this.addAutoConfig("jumpPadUpgradeEffectStackPerBlock");
        this.addAutoConfig("acceleriteOreFromMovingWarpslateChance");
        this.addAutoConfig("dormantAcceleriteIngotChargeSpeedRequirement");
        this.addAutoConfig("maxAcceleriteSwordEffectStack");
        this.addAutoConfig("maxAcceleriteShovelEffectStack");
        this.addAutoConfig("maxAcceleritePickaxeEffectStack");
        this.addAutoConfig("maxAcceleriteAxeEffectStack");
        this.addAutoConfig("maxAcceleriteHoeEffectStack");
        this.addAutoConfig("maxAcceleriteArmorEffectStack");
        this.addAutoConfig("maxAccelerationEnchantEffectStack");
        this.addAutoConfig("acceleriteSwordEffectDuration");
        this.addAutoConfig("acceleriteShovelEffectDuration");
        this.addAutoConfig("acceleritePickaxeEffectDuration");
        this.addAutoConfig("acceleriteAxeEffectDuration");
        this.addAutoConfig("acceleriteHoeEffectDuration");
        this.addAutoConfig("acceleriteArmorEffectDuration");
        this.addAutoConfig("accelerationEnchantEffectDuration");
        this.addAutoConfig("acceleriteSwordRepairSpeedRequirement");
        this.addAutoConfig("acceleriteShovelRepairSpeedRequirement");
        this.addAutoConfig("acceleritePickaxeRepairSpeedRequirement");
        this.addAutoConfig("acceleriteAxeRepairSpeedRequirement");
        this.addAutoConfig("acceleriteHoeRepairSpeedRequirement");
        this.addAutoConfig("acceleriteArmorRepairSpeedRequirement");
        this.addAutoConfig("accelerationEnchantRepairSpeedRequirement");
        this.add(this.JEI_DESCRIPTION + "chrono_upgrade_smithing_template", "Used to craft Chrono Shards. Found in Trial Chamber Chest & Vaults.");
        this.add(this.JEI_DESCRIPTION + "nexus_portal_core", "Allows traversal to The Nexus. Each portal core has its own coordinate scale. The blocks traveled in The Nexus are multiplied by this scale when leaving the dimension. You can use it in an Anvil to give your portal a name when placed. You can also disguise this block as another by using with a held block.");
        this.add(this.JEI_DESCRIPTION + "accelerite_ore", "Accelerite Ore is found in Nexus Chasms. These chasms spawn in The Nexus dimension and are massive holes that reach down to the void.");
        this.add(this.JEI_DESCRIPTION + "accelerite_ore_from_warpslate", "Accelerite Ore can also be obtained moving Warpslate with a Piston. Config Value Chance: %s%%");
        this.add(this.JEI_DESCRIPTION + "accelerite_ingot", "To obtain a Charged Accelerite Ingot from a Dormant one, you must reach a certain speed while it is in your inventory.");
        this.add(this.JEI_DESCRIPTION + "accelerite_tools_acceleration", "Attacking or mining with Accelerite tools applies a stacking effect that increases move, attack, and mining speed.");
        this.add(this.JEI_DESCRIPTION + "accelerite_armor_acceleration", "Taking damage while wearing Accelerite armor has a chance to apply a stacking effect that increases move, attack, and mining speed. Each piece of armor grants +25% to the chance for a total of 100% for a full set.");
        this.add(this.JEI_DESCRIPTION + "accelerite_equipment_repair", "Accelerite equipment is slowly repaired when reaching a certain speed.");
        this.add(this.JEI_DESCRIPTION + "road", "Roads grant any entity walking on it a speed boost. Sprinting will greatly increase the effect.");
        this.add(this.JEI_DESCRIPTION + "road_armor", "Wearing a full set of Accelerite armor will increase the effect stacks of Roads by %s.");
        this.add(this.JEI_DESCRIPTION + "road_upgrade", "The effects from Roads & Jump Pads can be upgraded by placing a Charged Accelerite Block under it. Each blocks placed under will increase the effect by (%s for Roads, %s for Jump Pads)");
        this.add(this.JEI_DESCRIPTION + "jump_pad", "Jump Pads grant any entity walking on it a jump boost. Entities will also not take any damage when falling on them.");
        this.add("config.jade.plugin_nexus.nexus_portal_core", "Nexus Portal Core");
        this.add("config.jade.plugin_nexus.nexus_portal", "Nexus Portal");
    }
}

