/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.datagen;

import com.calemi.nexus.block.NexusBlocks;
import com.calemi.nexus.block.RoadBlock;
import com.calemi.nexus.block.RoadSlabBlock;
import com.calemi.nexus.main.NexusRef;
import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.api.model.ModelType;
import com.supermartijn642.fusion.api.model.data.ConnectingModelData;
import com.supermartijn642.fusion.api.model.data.ConnectingModelDataBuilder;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.predicate.DefaultConnectionPredicates;
import com.supermartijn642.fusion.api.provider.FusionModelProvider;
import com.supermartijn642.fusion.api.util.Pair;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class NexusFusionModelProvider
extends FusionModelProvider {
    public NexusFusionModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super("nexus", output, existingFileHelper);
    }

    protected void generate() {
        this.road((Block)NexusBlocks.ROAD.get(), "road");
        this.roadSlab("road_slab", "road", "road_slab", "road");
        this.road((Block)NexusBlocks.JUMP_PAD.get(), "jump_pad");
    }

    private void road(Block block, String blockName) {
        ConnectingModelData modelData = (ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelDataBuilder.builder().parent(ResourceLocation.withDefaultNamespace((String)"block/cube_all"))).texture("all", NexusRef.rl("block/" + blockName))).connection(DefaultConnectionPredicates.and((ConnectionPredicate[])new ConnectionPredicate[]{DefaultConnectionPredicates.isSameBlock(), DefaultConnectionPredicates.or((ConnectionPredicate[])new ConnectionPredicate[]{DefaultConnectionPredicates.isSameState(), DefaultConnectionPredicates.matchState((Block)block, (Pair[])new Pair[]{Pair.of((Object)RoadBlock.CHARGED, (Object)true)}), DefaultConnectionPredicates.matchState((Block)block, (Pair[])new Pair[]{Pair.of((Object)RoadBlock.CHARGED, (Object)false)})})})).build();
        ModelInstance modelInstance = ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)modelData);
        this.addModel(NexusRef.rl("block/" + blockName), modelInstance);
    }

    private void roadSlab(String blockName, String bottomTexture, String sideTexture, String topTexture) {
        ConnectingModelData bottomModelData = this.roadSlabModel((Block)NexusBlocks.ROAD_SLAB.get(), "slab", bottomTexture, sideTexture, topTexture, SlabType.BOTTOM);
        ConnectingModelData topModelData = this.roadSlabModel((Block)NexusBlocks.ROAD_SLAB.get(), "slab_top", bottomTexture, sideTexture, topTexture, SlabType.TOP);
        ModelInstance bottomModelInstance = ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)bottomModelData);
        ModelInstance topModelInstance = ModelInstance.of((ModelType)DefaultModelTypes.CONNECTING, (Object)topModelData);
        this.addModel(NexusRef.rl("block/" + blockName), bottomModelInstance);
        this.addModel(NexusRef.rl("block/" + blockName + "_top"), topModelInstance);
    }

    private ConnectingModelData roadSlabModel(Block block, String parentName, String bottomTexture, String sideTexture, String topTexture, SlabType type) {
        return (ConnectingModelData)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)((ConnectingModelDataBuilder)ConnectingModelDataBuilder.builder().parent(ResourceLocation.withDefaultNamespace((String)("block/" + parentName)))).texture("bottom", NexusRef.rl("block/" + bottomTexture))).texture("side", NexusRef.rl("block/" + sideTexture))).texture("top", NexusRef.rl("block/" + topTexture))).connection(DefaultConnectionPredicates.and((ConnectionPredicate[])new ConnectionPredicate[]{DefaultConnectionPredicates.isSameBlock(), DefaultConnectionPredicates.matchState((Block)block, (Pair[])new Pair[]{Pair.of((Object)RoadSlabBlock.TYPE, (Object)type)})})).build();
    }
}

