/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.datagen;

import com.calemi.nexus.item.AcceleriteArmorItem;
import com.calemi.nexus.item.FallbreakersItem;
import com.calemi.nexus.item.NexusItems;
import com.calemi.nexus.item.SpeedometerItem;
import com.calemi.nexus.main.NexusRef;
import com.calemi.nexus.util.NexusLists;
import java.util.Locale;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TieredItem;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class NexusItemModelProvider
extends ItemModelProvider {
    public NexusItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "nexus", existingFileHelper);
    }

    protected void registerModels() {
        NexusLists.ALL_ITEMS.forEach(item -> {
            ResourceLocation itemKeyLocation = BuiltInRegistries.ITEM.getKey(item);
            String itemName = itemKeyLocation.getPath();
            ResourceLocation itemModelLocation = NexusRef.rl("item/" + itemName);
            ModelFile.UncheckedModelFile vanillaBaseParent = new ModelFile.UncheckedModelFile("item/generated");
            ModelFile.UncheckedModelFile vanillaHandheldParent = new ModelFile.UncheckedModelFile("item/handheld");
            if (item instanceof SpeedometerItem) {
                SpeedometerItem speedometerItem = (SpeedometerItem)((Object)item);
                ItemModelBuilder speedometerBuilder = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.factory.apply(itemModelLocation)).parent((ModelFile)vanillaBaseParent)).texture("layer0", itemModelLocation.withSuffix("_00"));
                for (int i = 1; i < 16; ++i) {
                    ItemModelBuilder.OverrideBuilder override = speedometerBuilder.override();
                    override.predicate(NexusRef.rl("speed"), (float)i / 16.0f);
                    override.model((ModelFile)this.basicItem(itemKeyLocation.withSuffix(String.format(Locale.ROOT, "_%02d", i))));
                }
                this.generatedModels.put(itemKeyLocation, speedometerBuilder);
                return;
            }
            if (item instanceof FallbreakersItem) {
                FallbreakersItem fallbreakersItem = (FallbreakersItem)((Object)item);
                ItemModelBuilder fallbreakersBuilder = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.factory.apply(itemModelLocation)).parent((ModelFile)vanillaBaseParent)).texture("layer0", itemModelLocation);
                for (int i = 0; i < ItemModelGenerators.GENERATED_TRIM_MODELS.size(); ++i) {
                    String trimName;
                    ItemModelGenerators.TrimModelData trimData = (ItemModelGenerators.TrimModelData)ItemModelGenerators.GENERATED_TRIM_MODELS.get(i);
                    String parentTrimName = trimName + ((trimName = trimData.name()).equals("iron") ? "_darker" : "");
                    String finalTrimName = trimName + (trimName.equals("amethyst") ? "_darker" : "");
                    ItemModelBuilder trimModel = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("item/" + itemName + "_" + finalTrimName + "_trim")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/iron_boots_" + parentTrimName + "_trim"))).texture("layer0", itemModelLocation);
                    ItemModelBuilder.OverrideBuilder override = fallbreakersBuilder.override();
                    override.predicate(ResourceLocation.withDefaultNamespace((String)"trim_type"), trimData.itemModelIndex());
                    override.model((ModelFile)trimModel);
                }
                this.generatedModels.put(itemKeyLocation, fallbreakersBuilder);
                return;
            }
            if (item instanceof AcceleriteArmorItem) {
                AcceleriteArmorItem acceleriteArmorItem = (AcceleriteArmorItem)item;
                ItemModelBuilder acceleriteArmorBuilder = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.factory.apply(itemModelLocation)).parent((ModelFile)vanillaBaseParent)).texture("layer0", itemModelLocation);
                for (int i = 0; i < ItemModelGenerators.GENERATED_TRIM_MODELS.size(); ++i) {
                    String trimName;
                    ItemModelGenerators.TrimModelData trimData = (ItemModelGenerators.TrimModelData)ItemModelGenerators.GENERATED_TRIM_MODELS.get(i);
                    String parentTrimName = trimName + ((trimName = trimData.name()).equals("iron") ? "_darker" : "");
                    ItemModelBuilder trimModel = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("item/" + itemName + "_" + trimName + "_trim")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/iron_boots_" + parentTrimName + "_trim"))).texture("layer0", itemModelLocation);
                    ItemModelBuilder.OverrideBuilder override = acceleriteArmorBuilder.override();
                    override.predicate(ResourceLocation.withDefaultNamespace((String)"trim_type"), trimData.itemModelIndex());
                    override.model((ModelFile)trimModel);
                }
                this.generatedModels.put(itemKeyLocation, acceleriteArmorBuilder);
                return;
            }
            if (item instanceof TieredItem || item.equals(NexusItems.WARPBLOSSOM_STICK.get())) {
                ItemModelBuilder tieredItemModel = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.factory.apply(itemModelLocation)).parent((ModelFile)vanillaHandheldParent)).texture("layer0", itemModelLocation);
                this.generatedModels.put(itemKeyLocation, tieredItemModel);
                return;
            }
            this.basicItem((Item)item);
        });
    }
}

