/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.datagen;

import com.calemi.ccore.api.block.family.CBlockFamily;
import com.calemi.ccore.api.datagen.CRecipeProvider;
import com.calemi.nexus.block.NexusBlocks;
import com.calemi.nexus.block.family.NexusBlockFamilies;
import com.calemi.nexus.item.NexusItems;
import com.calemi.nexus.main.NexusRef;
import com.calemi.nexus.tag.NexusTags;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;

public class NexusRecipeProvider
extends CRecipeProvider {
    public NexusRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super("nexus", output, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        NexusBlockFamilies.ALL.forEach(set -> this.family((CBlockFamily)set, recipeOutput));
        this.portalCore((ItemLike)NexusBlocks.NEXUS_PORTAL_CORE, Ingredient.of((TagKey)Tags.Items.OBSIDIANS_NORMAL), Ingredient.of((TagKey)Tags.Items.COBBLESTONES_DEEPSLATE), Ingredient.of((ItemLike[])new ItemLike[]{Items.COMPASS}), recipeOutput);
        this.portalCore((ItemLike)NexusBlocks.IRON_NEXUS_PORTAL_CORE, Ingredient.of((ItemLike[])new ItemLike[]{NexusBlocks.NEXUS_PORTAL_CORE}), Ingredient.of((TagKey)Tags.Items.INGOTS_IRON), Ingredient.of((ItemLike[])new ItemLike[]{Items.POPPY}), recipeOutput);
        this.portalCore((ItemLike)NexusBlocks.GOLD_NEXUS_PORTAL_CORE, Ingredient.of((ItemLike[])new ItemLike[]{NexusBlocks.IRON_NEXUS_PORTAL_CORE}), Ingredient.of((TagKey)Tags.Items.INGOTS_GOLD), Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLDEN_APPLE}), recipeOutput);
        this.portalCore((ItemLike)NexusBlocks.DIAMOND_NEXUS_PORTAL_CORE, Ingredient.of((ItemLike[])new ItemLike[]{NexusBlocks.GOLD_NEXUS_PORTAL_CORE}), Ingredient.of((TagKey)Tags.Items.GEMS_DIAMOND), Ingredient.of((TagKey)Tags.Items.OBSIDIANS_NORMAL), recipeOutput);
        this.portalCore((ItemLike)NexusBlocks.NETHERITE_NEXUS_PORTAL_CORE, Ingredient.of((ItemLike[])new ItemLike[]{NexusBlocks.DIAMOND_NEXUS_PORTAL_CORE}), Ingredient.of((TagKey)Tags.Items.INGOTS_NETHERITE), Ingredient.of((ItemLike[])new ItemLike[]{Items.GHAST_TEAR}), recipeOutput);
        this.portalCore((ItemLike)NexusBlocks.STARLIGHT_NEXUS_PORTAL_CORE, Ingredient.of((ItemLike[])new ItemLike[]{NexusBlocks.NETHERITE_NEXUS_PORTAL_CORE}), Ingredient.of((ItemLike[])new ItemLike[]{Items.ECHO_SHARD}), Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHER_STAR}), recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, NexusBlocks.ROAD, (int)16).define(Character.valueOf('X'), NexusItems.CHARGED_ACCELERITE_INGOT).define(Character.valueOf('W'), NexusBlocks.COBBLED_WARPSLATE).pattern("XWX").pattern("WWW").pattern("XWX").unlockedBy("has_charged_accelerite_ingot", NexusRecipeProvider.has(NexusItems.CHARGED_ACCELERITE_INGOT)).save(recipeOutput);
        NexusRecipeProvider.slab((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.MISC, NexusBlocks.ROAD_SLAB, NexusBlocks.ROAD);
        this.stonecutter(recipeOutput, RecipeCategory.BUILDING_BLOCKS, (ItemLike)NexusBlocks.ROAD_SLAB, (ItemLike)NexusBlocks.ROAD, 2);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, NexusBlocks.JUMP_PAD, (int)1).define(Character.valueOf('X'), NexusItems.CHRONO_SHARD).define(Character.valueOf('W'), NexusBlocks.COBBLED_WARPSLATE).pattern("XWX").pattern("WWW").pattern("XWX").unlockedBy("has_chrono_shard", NexusRecipeProvider.has(NexusItems.CHRONO_SHARD)).save(recipeOutput);
        NexusRecipeProvider.threeByThreePacker((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.MISC, NexusItems.CHRONO_SHARD, NexusItems.CHRONO_SHARD_FRAGMENT);
        this.oneToOne(recipeOutput, (ItemLike)NexusItems.CHRONO_SHARD_FRAGMENT, (ItemLike)NexusItems.CHRONO_SHARD, null, 9);
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{NexusItems.CHRONO_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((TagKey)Tags.Items.GEMS_AMETHYST), (Ingredient)Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS), (RecipeCategory)RecipeCategory.MISC, (Item)((Item)NexusItems.CHRONO_SHARD.get())).unlocks("has_ender_pearl", NexusRecipeProvider.has((TagKey)Tags.Items.ENDER_PEARLS)).save(recipeOutput, NexusRef.rl("chrono_shard_from_smithing"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, NexusItems.CHRONO_UPGRADE_SMITHING_TEMPLATE, (int)2).define(Character.valueOf('T'), NexusItems.CHRONO_UPGRADE_SMITHING_TEMPLATE).define(Character.valueOf('M'), (ItemLike)Items.AMETHYST_SHARD).define(Character.valueOf('B'), (ItemLike)Blocks.CALCITE).pattern("MTM").pattern("MBM").pattern("MMM").unlockedBy("has_chrono_upgrade", NexusRecipeProvider.has(NexusItems.CHRONO_UPGRADE_SMITHING_TEMPLATE)).save(recipeOutput);
        NexusRecipeProvider.twoByTwoPacker((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.DECORATIONS, NexusBlocks.CHRONO_BLOCK, NexusItems.CHRONO_SHARD);
        NexusRecipeProvider.smeltingResultFromBase((RecipeOutput)recipeOutput, NexusBlocks.WARPSLATE, NexusBlocks.COBBLED_WARPSLATE);
        NexusRecipeProvider.oreSmelting((RecipeOutput)recipeOutput, List.of((ItemLike)NexusItems.RAW_ACCELERITE.get(), NexusBlocks.WARPSLATE_ACCELERITE_ORE.asItem()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NexusItems.DORMANT_ACCELERITE_INGOT.get()), (float)1.0f, (int)200, (String)"accelerite_ingot");
        NexusRecipeProvider.oreBlasting((RecipeOutput)recipeOutput, List.of((ItemLike)NexusItems.RAW_ACCELERITE.get(), NexusBlocks.WARPSLATE_ACCELERITE_ORE.asItem()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)NexusItems.DORMANT_ACCELERITE_INGOT.get()), (float)1.0f, (int)100, (String)"accelerite_ingot");
        NexusRecipeProvider.threeByThreePacker((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.MISC, NexusBlocks.RAW_ACCELERITE_BLOCK, NexusItems.RAW_ACCELERITE);
        this.oneToOne(recipeOutput, (ItemLike)NexusItems.RAW_ACCELERITE, (ItemLike)NexusBlocks.RAW_ACCELERITE_BLOCK, null, 9);
        NexusRecipeProvider.threeByThreePacker((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.MISC, NexusBlocks.DORMANT_ACCELERITE_BLOCK, NexusItems.DORMANT_ACCELERITE_INGOT);
        this.oneToOne(recipeOutput, (ItemLike)NexusItems.DORMANT_ACCELERITE_INGOT, (ItemLike)NexusBlocks.DORMANT_ACCELERITE_BLOCK, null, 9);
        NexusRecipeProvider.threeByThreePacker((RecipeOutput)recipeOutput, (RecipeCategory)RecipeCategory.MISC, NexusBlocks.CHARGED_ACCELERITE_BLOCK, NexusItems.CHARGED_ACCELERITE_INGOT);
        this.oneToOne(recipeOutput, (ItemLike)NexusItems.CHARGED_ACCELERITE_INGOT, (ItemLike)NexusBlocks.CHARGED_ACCELERITE_BLOCK, null, 9);
        this.oneByTwoVertical(recipeOutput, (ItemLike)NexusItems.WARPBLOSSOM_STICK, 4, (ItemLike)NexusBlocks.WARPBLOSSOM_PLANKS);
        this.sword(recipeOutput, (ItemLike)NexusItems.ACCELERITE_SWORD, (ItemLike)NexusItems.CHARGED_ACCELERITE_INGOT);
        this.shovel(recipeOutput, (ItemLike)NexusItems.ACCELERITE_SHOVEL, (ItemLike)NexusItems.CHARGED_ACCELERITE_INGOT);
        this.pickaxe(recipeOutput, (ItemLike)NexusItems.ACCELERITE_PICKAXE, (ItemLike)NexusItems.CHARGED_ACCELERITE_INGOT);
        this.axe(recipeOutput, (ItemLike)NexusItems.ACCELERITE_AXE, (ItemLike)NexusItems.CHARGED_ACCELERITE_INGOT);
        this.hoe(recipeOutput, (ItemLike)NexusItems.ACCELERITE_HOE, (ItemLike)NexusItems.CHARGED_ACCELERITE_INGOT);
        this.helmet(recipeOutput, (ItemLike)NexusItems.ACCELERITE_HELMET, (ItemLike)NexusItems.CHARGED_ACCELERITE_INGOT);
        this.chestplate(recipeOutput, (ItemLike)NexusItems.ACCELERITE_CHESTPLATE, (ItemLike)NexusItems.CHARGED_ACCELERITE_INGOT);
        this.leggings(recipeOutput, (ItemLike)NexusItems.ACCELERITE_LEGGINGS, (ItemLike)NexusItems.CHARGED_ACCELERITE_INGOT);
        this.boots(recipeOutput, (ItemLike)NexusItems.ACCELERITE_BOOTS, (ItemLike)NexusItems.CHARGED_ACCELERITE_INGOT);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, NexusItems.TOTEM_OF_WARPING, (int)1).define(Character.valueOf('C'), NexusItems.CHRONO_SHARD).define(Character.valueOf('T'), (ItemLike)Items.TOTEM_OF_UNDYING).pattern(" C ").pattern("CTC").pattern(" C ").unlockedBy("has_totem_of_undying", NexusRecipeProvider.has((ItemLike)Items.TOTEM_OF_UNDYING)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, NexusItems.SPEEDOMETER, (int)1).define(Character.valueOf('I'), NexusTags.Items.ACCELERITE_INGOTS).define(Character.valueOf('S'), (ItemLike)Items.AMETHYST_SHARD.asItem()).pattern(" I ").pattern("ISI").pattern(" I ").unlockedBy("has_accelerite", NexusRecipeProvider.has(NexusTags.Items.ACCELERITE_INGOTS)).save(recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, NexusItems.FALLBREAKERS, (int)1).define(Character.valueOf('S'), Tags.Items.GEMS_AMETHYST).define(Character.valueOf('W'), ItemTags.WOOL).pattern("S S").pattern("W W").unlockedBy("has_amethyst_shard", NexusRecipeProvider.has((TagKey)Tags.Items.GEMS_AMETHYST)).save(recipeOutput);
        NexusRecipeProvider.woodenBoat((RecipeOutput)recipeOutput, NexusItems.WARPBLOSSOM_BOAT, NexusBlocks.WARPBLOSSOM_PLANKS);
        NexusRecipeProvider.chestBoat((RecipeOutput)recipeOutput, NexusItems.WARPBLOSSOM_CHEST_BOAT, NexusItems.WARPBLOSSOM_BOAT);
        this.oneToOne(recipeOutput, (ItemLike)Items.PURPLE_DYE, (ItemLike)NexusBlocks.PURPLE_PETALS, "purple_dye", 1);
    }

    private void portalCore(ItemLike result, Ingredient prevPortalCore, Ingredient tier, Ingredient center, RecipeOutput recipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TRANSPORTATION, (ItemLike)result, (int)2).define(Character.valueOf('I'), NexusItems.CHRONO_SHARD).define(Character.valueOf('T'), tier).define(Character.valueOf('C'), prevPortalCore).define(Character.valueOf('S'), center).pattern("TCT").pattern("ISI").pattern("TCT").unlockedBy("has_chrono_shard", NexusRecipeProvider.has(NexusItems.CHRONO_SHARD)).save(recipeOutput, NexusRef.rl(NexusRecipeProvider.getItemName((ItemLike)result)));
    }
}

