/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.entity;

import com.calemi.ccore.api.location.BlockLocation;
import com.calemi.nexus.util.NexusSoundHelper;
import com.calemi.nexus.util.TeleportHelper;
import com.calemi.nexus.world.dimension.NexusDimensionHelper;
import com.calemi.nexus.world.dimension.NexusDimensions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class HoleTeleportAction {
    @SubscribeEvent
    public void onPlayerTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        Level level = entity.level();
        if (!level.isClientSide() && NexusDimensionHelper.isInNexus(entity)) {
            Player player;
            int nexusMinY = level.getServer().getLevel(NexusDimensions.NEXUS_LEVEL).getMinBuildHeight();
            int overworldHeight = level.getServer().getLevel(Level.OVERWORLD).getMaxBuildHeight();
            if (entity instanceof Player && ((player = (Player)entity).isCreative() || player.isSpectator())) {
                return;
            }
            if (entity.getBlockY() <= nexusMinY - 5) {
                NexusSoundHelper.playTeleportSound(new BlockLocation(entity));
                TeleportHelper.teleportToWorld(entity, entity.blockPosition().offset(0, overworldHeight + 128, 0), (ResourceKey<Level>)Level.OVERWORLD);
                NexusSoundHelper.playTeleportSound(new BlockLocation(entity));
            }
        }
    }
}

