/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.item;

import com.calemi.nexus.config.NexusConfig;
import com.calemi.nexus.item.AccelerationEffectItem;
import com.calemi.nexus.item.ChargeableBySpeedItem;
import com.calemi.nexus.item.NexusTiers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AcceleriteAxeItem
extends AxeItem
implements ChargeableBySpeedItem,
AccelerationEffectItem {
    public AcceleriteAxeItem(Item.Properties properties) {
        super(NexusTiers.ACCELERITE, properties);
    }

    @Override
    public void onSpeedRequirementMet(ServerPlayer player, ItemStack stack) {
        stack.setDamageValue(Math.clamp((long)(stack.getDamageValue() - 1), 0, stack.getMaxDamage()));
    }

    @Override
    public boolean canCharge(ServerPlayer player, ItemStack stack) {
        return stack.isDamaged();
    }

    @Override
    public double getRequiredSpeed() {
        return (Double)NexusConfig.server.acceleriteAxeRepairSpeedRequirement.get();
    }

    @Override
    public int getAccelerationEffectDuration() {
        return (Integer)NexusConfig.server.acceleriteAxeEffectDuration.get();
    }

    @Override
    public int getMaxAccelerationEffectStacks() {
        return (Integer)NexusConfig.server.maxAcceleriteAxeEffectStack.get() - 1;
    }
}

