/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.item;

import com.calemi.ccore.api.math.MathHelper;
import com.calemi.nexus.config.NexusConfig;
import com.calemi.nexus.item.AccelerationEffectItem;
import com.calemi.nexus.item.enchantment.NexusEnchantments;
import com.calemi.nexus.util.AccelerationMobEffectHelper;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class ItemAccelerationEffectAction {
    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent.Post event) {
        float chance = 0.0f;
        int effectDuration = 0;
        int effectMaxStacks = 0;
        for (ItemStack armorItemStack : event.getEntity().getArmorSlots()) {
            int enchantmentMaxStacks;
            Item item = armorItemStack.getItem();
            if (item instanceof AccelerationEffectItem) {
                AccelerationEffectItem accelerationEffectItem = (AccelerationEffectItem)item;
                chance += 0.25f;
                if (accelerationEffectItem.getAccelerationEffectDuration() > effectDuration) {
                    effectDuration = accelerationEffectItem.getAccelerationEffectDuration();
                }
                if (accelerationEffectItem.getMaxAccelerationEffectStacks() <= effectMaxStacks) continue;
                effectMaxStacks = accelerationEffectItem.getMaxAccelerationEffectStacks();
                continue;
            }
            int accelerationEnchantmentLevel = this.getAccelerationEnchantmentLevel(event.getEntity().level(), armorItemStack);
            if (accelerationEnchantmentLevel <= 0) continue;
            chance += 0.25f;
            int enchantmentDuration = accelerationEnchantmentLevel * (Integer)NexusConfig.server.accelerationEnchantEffectDuration.get();
            if (enchantmentDuration > effectDuration) {
                effectDuration = enchantmentDuration;
            }
            if ((enchantmentMaxStacks = (Integer)NexusConfig.server.maxAccelerationEnchantEffectStack.get() - 1) <= effectDuration) continue;
            effectMaxStacks = enchantmentMaxStacks;
        }
        if (MathHelper.rollChance((double)chance)) {
            AccelerationMobEffectHelper.applyAccelerationEffect(event.getEntity(), effectDuration, effectMaxStacks);
        }
    }

    @SubscribeEvent
    public void onAttackEntity(AttackEntityEvent event) {
        int accelerationEnchantmentLevel;
        if (event.getEntity().swinging) {
            return;
        }
        ItemStack heldStack = event.getEntity().getMainHandItem();
        Item item = heldStack.getItem();
        if (item instanceof AccelerationEffectItem) {
            AccelerationEffectItem accelerationEffectItem = (AccelerationEffectItem)item;
            AccelerationMobEffectHelper.applyAccelerationEffect((LivingEntity)event.getEntity(), accelerationEffectItem.getAccelerationEffectDuration(), accelerationEffectItem.getMaxAccelerationEffectStacks());
        }
        if ((accelerationEnchantmentLevel = this.getAccelerationEnchantmentLevel(event.getEntity().level(), heldStack)) > 0) {
            AccelerationMobEffectHelper.applyAccelerationEffect((LivingEntity)event.getEntity(), accelerationEnchantmentLevel * (Integer)NexusConfig.server.accelerationEnchantEffectDuration.get(), (Integer)NexusConfig.server.maxAccelerationEnchantEffectStack.get() - 1);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        int accelerationEnchantmentLevel;
        if (event.getState().getDestroySpeed((BlockGetter)event.getLevel(), event.getPos()) <= 0.0f) {
            return;
        }
        ItemStack heldStack = event.getPlayer().getMainHandItem();
        Item item = heldStack.getItem();
        if (item instanceof AccelerationEffectItem) {
            AccelerationEffectItem accelerationEffectItem = (AccelerationEffectItem)item;
            AccelerationMobEffectHelper.applyAccelerationEffect((LivingEntity)event.getPlayer(), accelerationEffectItem.getAccelerationEffectDuration(), accelerationEffectItem.getMaxAccelerationEffectStacks());
        }
        if ((accelerationEnchantmentLevel = this.getAccelerationEnchantmentLevel(event.getPlayer().level(), heldStack)) > 0) {
            AccelerationMobEffectHelper.applyAccelerationEffect((LivingEntity)event.getPlayer(), accelerationEnchantmentLevel * (Integer)NexusConfig.server.accelerationEnchantEffectDuration.get(), (Integer)NexusConfig.server.maxAccelerationEnchantEffectStack.get() - 1);
        }
    }

    private int getAccelerationEnchantmentLevel(Level level, ItemStack stack) {
        Holder enchantment = level.holder(NexusEnchantments.ACCELERATION).orElse(null);
        return EnchantmentHelper.getTagEnchantmentLevel((Holder)enchantment, (ItemStack)stack);
    }
}

