/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.item;

import com.calemi.ccore.api.message.OverlayMessageHelper;
import com.calemi.nexus.config.NexusConfig;
import com.calemi.nexus.item.ChargeableBySpeedItem;
import com.calemi.nexus.item.SpeedometerItem;
import com.calemi.nexus.item.enchantment.NexusEnchantments;
import java.text.DecimalFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class ItemSpeedChargeAction {
    private long lastGameTime = 0L;
    private long deltaTime = 0L;
    private double currentChargeCooldown = 0.0;

    @SubscribeEvent
    public void onPlayerTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        Level level = entity.level();
        if (level.isClientSide()) {
            return;
        }
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)entity;
        if (serverPlayer.isSpectator()) {
            return;
        }
        if (level.getGameTime() != this.lastGameTime) {
            if (this.lastGameTime != 0L) {
                this.deltaTime = level.getGameTime() - this.lastGameTime;
            }
            this.lastGameTime = level.getGameTime();
        }
        if (this.currentChargeCooldown > 0.0) {
            this.currentChargeCooldown -= (double)this.deltaTime;
        }
        double currentSpeed = serverPlayer.getKnownMovement().toVector3f().length();
        double currentPercentage = 0.0;
        ItemStack currentChargingStack = this.getPrioritizedChargeableItemStack(serverPlayer);
        if (!currentChargingStack.isEmpty()) {
            ChargeableBySpeedItem currentSpeedChargeItem;
            double requiredSpeed = (Double)NexusConfig.server.accelerationEnchantRepairSpeedRequirement.get();
            Item item = currentChargingStack.getItem();
            if (item instanceof ChargeableBySpeedItem) {
                currentSpeedChargeItem = (ChargeableBySpeedItem)item;
                requiredSpeed = currentSpeedChargeItem.getRequiredSpeed();
            }
            if ((currentPercentage = currentSpeed / requiredSpeed * 100.0) >= 100.0 && this.currentChargeCooldown <= 0.0) {
                item = currentChargingStack.getItem();
                if (item instanceof ChargeableBySpeedItem) {
                    currentSpeedChargeItem = (ChargeableBySpeedItem)item;
                    currentSpeedChargeItem.onSpeedRequirementMet(serverPlayer, currentChargingStack);
                } else {
                    currentChargingStack.setDamageValue(Math.clamp((long)(currentChargingStack.getDamageValue() - 1), 0, currentChargingStack.getMaxDamage()));
                }
                this.currentChargeCooldown = Mth.clamp((double)(10.0 - (currentSpeed - requiredSpeed) * 5.0), (double)5.0, (double)10.0);
            }
        }
        ItemStack heldSpeedometerItemStack = ItemStack.EMPTY;
        if (serverPlayer.getMainHandItem().getItem() instanceof SpeedometerItem) {
            heldSpeedometerItemStack = serverPlayer.getMainHandItem();
        } else if (serverPlayer.getOffhandItem().getItem() instanceof SpeedometerItem) {
            heldSpeedometerItemStack = serverPlayer.getOffhandItem();
        }
        if (!heldSpeedometerItemStack.isEmpty()) {
            DecimalFormat decimal = new DecimalFormat("0.00");
            DecimalFormat percentage = new DecimalFormat("0");
            MutableComponent overlayMessage = Component.translatable((String)"hud.nexus.speed").append(": " + String.valueOf(ChatFormatting.GOLD) + decimal.format(currentSpeed));
            if (!currentChargingStack.isEmpty()) {
                ChatFormatting color = ChatFormatting.GOLD;
                if (currentPercentage >= 100.0) {
                    color = ChatFormatting.GREEN;
                }
                overlayMessage = Component.literal((String)currentChargingStack.getHoverName().getString()).append(": " + String.valueOf(color) + percentage.format(currentPercentage) + "% ").append("(" + String.valueOf(ChatFormatting.GOLD) + decimal.format(currentSpeed)).append(")");
            }
            OverlayMessageHelper.displayMsg((MutableComponent)overlayMessage, (ServerPlayer)serverPlayer);
        }
    }

    private ItemStack getPrioritizedChargeableItemStack(ServerPlayer serverPlayer) {
        ItemStack mainHandItemStack = serverPlayer.getMainHandItem();
        if (this.isItemStackChargeable(serverPlayer, mainHandItemStack)) {
            return mainHandItemStack;
        }
        ItemStack offHandItemStack = serverPlayer.getOffhandItem();
        if (this.isItemStackChargeable(serverPlayer, offHandItemStack)) {
            return offHandItemStack;
        }
        for (ItemStack invStack : serverPlayer.getInventory().armor) {
            if (!this.isItemStackChargeable(serverPlayer, invStack)) continue;
            return invStack;
        }
        for (ItemStack invStack : serverPlayer.getInventory().items) {
            if (!this.isItemStackChargeable(serverPlayer, invStack)) continue;
            return invStack;
        }
        return ItemStack.EMPTY;
    }

    private boolean isItemStackChargeable(ServerPlayer player, ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ChargeableBySpeedItem) {
            ChargeableBySpeedItem speedChargeItem = (ChargeableBySpeedItem)item;
            return speedChargeItem.getRequiredSpeed() > 0.0 && speedChargeItem.canCharge(player, stack);
        }
        return (Double)NexusConfig.server.accelerationEnchantRepairSpeedRequirement.get() > 0.0 && this.getSpeedMendingEnchantmentLevel(player.level(), stack) > 0 && stack.isDamaged();
    }

    private int getSpeedMendingEnchantmentLevel(Level level, ItemStack stack) {
        Holder enchantment = level.holder(NexusEnchantments.SPEED_MENDING).orElse(null);
        return EnchantmentHelper.getTagEnchantmentLevel((Holder)enchantment, (ItemStack)stack);
    }
}

