/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.item;

import com.calemi.ccore.api.location.BlockLocation;
import com.calemi.nexus.item.NexusItems;
import com.calemi.nexus.packet.TotemOfWarpingPayload;
import com.calemi.nexus.util.NexusSoundHelper;
import com.calemi.nexus.util.TeleportHelper;
import com.calemi.nexus.world.dimension.NexusDimensionHelper;
import com.calemi.nexus.world.dimension.NexusDimensions;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.EffectCures;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class TotemOfWarpingImmunityAction {
    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.level();
        if (level.isClientSide()) {
            return;
        }
        if (entity.getHealth() - event.getNewDamage() <= 0.0f) {
            ItemStack totem = null;
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack heldStack = entity.getItemInHand(hand);
                if (!heldStack.is(NexusItems.TOTEM_OF_WARPING)) continue;
                totem = heldStack.copy();
                heldStack.shrink(1);
                break;
            }
            if (totem != null) {
                ServerLevel serverLevel;
                ServerLevel destinationLevel;
                int yLevel;
                if (!NexusDimensionHelper.isInNexus((Entity)entity) && level instanceof ServerLevel && (yLevel = NexusDimensionHelper.getSolidGroundLevel((Level)(destinationLevel = (serverLevel = (ServerLevel)level).getServer().getLevel(NexusDimensions.NEXUS_LEVEL)), entity.blockPosition())) != Integer.MAX_VALUE) {
                    NexusSoundHelper.playTeleportSound(new BlockLocation((Entity)entity));
                    TeleportHelper.teleportToWorld((Entity)entity, new BlockPos(entity.getBlockX(), yLevel, entity.getBlockZ()), NexusDimensions.NEXUS_LEVEL);
                    NexusSoundHelper.playTeleportSound(new BlockLocation((Entity)entity));
                }
                event.setNewDamage(0.0f);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)entity;
                    serverplayer.awardStat(Stats.ITEM_USED.get((Object)((Item)NexusItems.TOTEM_OF_WARPING.get())), 1);
                    CriteriaTriggers.USED_TOTEM.trigger(serverplayer, totem);
                    entity.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
                    serverplayer.connection.send((CustomPacketPayload)new TotemOfWarpingPayload());
                }
                entity.setHealth(1.0f);
                entity.removeEffectsCuredBy(EffectCures.PROTECTED_BY_TOTEM);
                entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
                entity.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
                entity.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
            }
        }
    }
}

