/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.main;

import com.calemi.nexus.block.DyeNexusPortalBlockAction;
import com.calemi.nexus.block.NexusBlocks;
import com.calemi.nexus.block.entity.BlockEntityTypeInjector;
import com.calemi.nexus.block.entity.NexusBlockEntities;
import com.calemi.nexus.capability.NexusAttachments;
import com.calemi.nexus.client.partclie.NexusParticles;
import com.calemi.nexus.client.render.RenderNexusPortalCoreHUDOverlay;
import com.calemi.nexus.client.render.RenderNexusPortalCoreWorldOverlay;
import com.calemi.nexus.compat.NexusCreateCompatibility;
import com.calemi.nexus.config.NexusConfig;
import com.calemi.nexus.effect.NexusMobEffects;
import com.calemi.nexus.entity.HoleTeleportAction;
import com.calemi.nexus.entity.NexusSheepSpawnColor;
import com.calemi.nexus.item.FallbreakersImmunityAction;
import com.calemi.nexus.item.FallbreakersTooltip;
import com.calemi.nexus.item.ItemAccelerationEffectAction;
import com.calemi.nexus.item.ItemSpeedChargeAction;
import com.calemi.nexus.item.NexusArmorMaterials;
import com.calemi.nexus.item.NexusItems;
import com.calemi.nexus.item.TotemOfWarpingImmunityAction;
import com.calemi.nexus.item.axe.NexusStrippables;
import com.calemi.nexus.item.property.NexusItemProperties;
import com.calemi.nexus.packet.NexusPackets;
import com.calemi.nexus.tab.CreativeTabInjector;
import com.calemi.nexus.tab.NexusCreativeModeTabs;
import com.calemi.nexus.world.feature.NexusFeatures;
import com.calemi.nexus.world.feature.tree.NexusFoliagePlacers;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="nexus")
public class Nexus {
    public static final IEventBus FORGE_EVENT_BUS = NeoForge.EVENT_BUS;
    public static IEventBus MOD_EVENT_BUS;
    public static ModContainer MOD_CONTAINER;
    public static final Logger LOGGER;

    public Nexus(IEventBus modEventBus, ModContainer modContainer) {
        LOGGER.info("Registering: Main - Start");
        MOD_EVENT_BUS = modEventBus;
        MOD_CONTAINER = modContainer;
        NexusConfig.init();
        NexusItems.init();
        NexusArmorMaterials.init();
        NexusBlockEntities.init();
        NexusBlocks.init();
        NexusCreativeModeTabs.init();
        NexusMobEffects.init();
        NexusAttachments.init();
        NexusFeatures.init();
        NexusFoliagePlacers.init();
        NexusParticles.init();
        MOD_EVENT_BUS.addListener(this::commonSetup);
        MOD_EVENT_BUS.addListener(this::clientSetup);
        MOD_EVENT_BUS.addListener(BlockEntityTypeInjector::addBlockEntityTypes);
        LOGGER.info("Registering: Main - End");
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Registering: Common - Start");
        NexusStrippables.init();
        MOD_EVENT_BUS.register((Object)new NexusPackets());
        MOD_EVENT_BUS.register((Object)new CreativeTabInjector());
        FORGE_EVENT_BUS.register((Object)new RenderNexusPortalCoreHUDOverlay());
        FORGE_EVENT_BUS.register((Object)new DyeNexusPortalBlockAction());
        FORGE_EVENT_BUS.register((Object)new HoleTeleportAction());
        FORGE_EVENT_BUS.register((Object)new ItemSpeedChargeAction());
        FORGE_EVENT_BUS.register((Object)new ItemAccelerationEffectAction());
        FORGE_EVENT_BUS.register((Object)new TotemOfWarpingImmunityAction());
        FORGE_EVENT_BUS.register((Object)new FallbreakersImmunityAction());
        FORGE_EVENT_BUS.register((Object)new NexusSheepSpawnColor());
        if (ModList.get().isLoaded("create")) {
            NexusCreateCompatibility.init();
        }
        LOGGER.info("Registering: Common - End");
    }

    public void clientSetup(FMLClientSetupEvent event) {
        LOGGER.info("Registering: Client - Start");
        NexusItemProperties.init();
        MOD_CONTAINER.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        FORGE_EVENT_BUS.register((Object)new RenderNexusPortalCoreWorldOverlay());
        FORGE_EVENT_BUS.register((Object)new FallbreakersTooltip());
        LOGGER.info("Registering: Client - End");
    }

    static {
        LOGGER = LogManager.getLogger((String)"Nexus");
    }
}

