/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.packet;

import com.calemi.nexus.block.entity.NexusPortalCoreBlockEntity;
import com.calemi.nexus.main.NexusRef;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record NexusPortalCoreDestinationDimensionSyncPayload(BlockPos portalCorePosition, ResourceLocation destinationDimension) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, NexusPortalCoreDestinationDimensionSyncPayload> CODEC = CustomPacketPayload.codec(NexusPortalCoreDestinationDimensionSyncPayload::write, NexusPortalCoreDestinationDimensionSyncPayload::new);
    public static final CustomPacketPayload.Type<NexusPortalCoreDestinationDimensionSyncPayload> TYPE = new CustomPacketPayload.Type(NexusRef.rl("nexus_portal_core_destination_dimension_sync"));

    public NexusPortalCoreDestinationDimensionSyncPayload(RegistryFriendlyByteBuf buf) {
        this(buf.readBlockPos(), buf.readResourceLocation());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.portalCorePosition);
        buf.writeResourceLocation(this.destinationDimension);
    }

    public static void handle(NexusPortalCoreDestinationDimensionSyncPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            BlockEntity patt0$temp = context.player().level().getBlockEntity(payload.portalCorePosition());
            if (patt0$temp instanceof NexusPortalCoreBlockEntity) {
                NexusPortalCoreBlockEntity portalCoreBlockEntity = (NexusPortalCoreBlockEntity)patt0$temp;
                if (portalCoreBlockEntity.getDestinationPos() != null) {
                    return;
                }
                portalCoreBlockEntity.setDestinationDimensionRL(payload.destinationDimension());
                portalCoreBlockEntity.setChanged();
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

