/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.packet;

import com.calemi.nexus.block.entity.NexusPortalCoreBlockEntity;
import com.calemi.nexus.client.screen.NexusPortalCoreScreen;
import com.calemi.nexus.main.NexusRef;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record NexusPortalCoreDestinationNameSyncPayload(BlockPos portalCorePosition, String destinationPOIName) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, NexusPortalCoreDestinationNameSyncPayload> CODEC = CustomPacketPayload.codec(NexusPortalCoreDestinationNameSyncPayload::write, NexusPortalCoreDestinationNameSyncPayload::new);
    public static final CustomPacketPayload.Type<NexusPortalCoreDestinationNameSyncPayload> TYPE = new CustomPacketPayload.Type(NexusRef.rl("nexus_portal_core_destination_name_sync"));

    public NexusPortalCoreDestinationNameSyncPayload(RegistryFriendlyByteBuf buf) {
        this(buf.readBlockPos(), buf.readUtf(50));
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.portalCorePosition);
        buf.writeUtf(this.destinationPOIName, 50);
    }

    public static void handle(NexusPortalCoreDestinationNameSyncPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ServerLevel originLevel = (ServerLevel)player.level();
                BlockEntity patt0$temp = originLevel.getBlockEntity(payload.portalCorePosition());
                if (!(patt0$temp instanceof NexusPortalCoreBlockEntity)) {
                    return;
                }
                NexusPortalCoreBlockEntity originBlockEntity = (NexusPortalCoreBlockEntity)patt0$temp;
                NexusPortalCoreBlockEntity destinationBlockEntity = originBlockEntity.getDestinationPortalCore();
                if (destinationBlockEntity == null) {
                    return;
                }
                Component destinationPOIName = destinationBlockEntity.getPoiName();
                if (destinationPOIName == null) {
                    return;
                }
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new NexusPortalCoreDestinationNameSyncPayload(payload.portalCorePosition(), destinationPOIName.getString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                Screen patt0$temp = Minecraft.getInstance().screen;
                if (patt0$temp instanceof NexusPortalCoreScreen) {
                    NexusPortalCoreScreen portalCoreScreen = (NexusPortalCoreScreen)patt0$temp;
                    portalCoreScreen.setDestinationName(payload.destinationPOIName());
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

