/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.packet;

import com.calemi.ccore.api.location.BlockLocation;
import com.calemi.nexus.block.NexusPortalCoreBlock;
import com.calemi.nexus.block.entity.NexusPortalCoreBlockEntity;
import com.calemi.nexus.main.NexusRef;
import com.calemi.nexus.util.NexusSoundHelper;
import com.calemi.nexus.util.message.NexusMessengers;
import com.calemi.nexus.world.dimension.NexusDimensionHelper;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record NexusPortalCoreFindLinkPayload(BlockPos portalCorePosition) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, NexusPortalCoreFindLinkPayload> CODEC = CustomPacketPayload.codec(NexusPortalCoreFindLinkPayload::write, NexusPortalCoreFindLinkPayload::new);
    public static final CustomPacketPayload.Type<NexusPortalCoreFindLinkPayload> TYPE = new CustomPacketPayload.Type(NexusRef.rl("nexus_portal_core_find_link"));

    public NexusPortalCoreFindLinkPayload(RegistryFriendlyByteBuf buf) {
        this(buf.readBlockPos());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.portalCorePosition);
    }

    public static void handle(NexusPortalCoreFindLinkPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            BlockPos destinationPos;
            NexusPortalCoreBlockEntity destinationBlockEntity;
            BlockPos originPos = payload.portalCorePosition();
            Player player = context.player();
            ServerLevel originLevel = (ServerLevel)player.level();
            BlockLocation originLocation = new BlockLocation((Level)originLevel, originPos);
            Block patt0$temp = originLevel.getBlockState(originPos).getBlock();
            if (!(patt0$temp instanceof NexusPortalCoreBlock)) {
                return;
            }
            NexusPortalCoreBlock originBlock = (NexusPortalCoreBlock)patt0$temp;
            BlockEntity patt1$temp = originLevel.getBlockEntity(originPos);
            if (!(patt1$temp instanceof NexusPortalCoreBlockEntity)) {
                return;
            }
            NexusPortalCoreBlockEntity originBlockEntity = (NexusPortalCoreBlockEntity)patt1$temp;
            Level destinationLevel = originBlockEntity.getDestinationLevel();
            if (destinationLevel == null) {
                NexusMessengers.NEXUS_PORTAL_CORE.send(Component.translatable((String)"message.nexus.invalid_dimension").withStyle(ChatFormatting.RED), new Entity[]{player});
                NexusSoundHelper.playErrorSound(originLocation);
                return;
            }
            int coordinateScale = originBlock.getCoordinateScale();
            BlockPos calcPos = NexusDimensionHelper.getDynamicBlockDestination((Level)originLevel, originPos, coordinateScale);
            if (!NexusDimensionHelper.isDestinationValid(destinationLevel, calcPos)) {
                NexusMessengers.NEXUS_PORTAL_CORE.send(Component.translatable((String)"message.nexus.invalid_destination").withStyle(ChatFormatting.RED), new Entity[]{player});
                NexusSoundHelper.playErrorSound(originLocation);
                return;
            }
            if (!NexusDimensionHelper.isInNexus((Level)originLevel)) {
                coordinateScale = 1;
            }
            NexusMessengers.NEXUS_PORTAL_CORE.send(Component.translatable((String)"message.nexus.find_link.searching").withStyle(ChatFormatting.GRAY), new Entity[]{player});
            ArrayList<BlockPos> collectedBlockEntityPositions = new ArrayList<BlockPos>();
            for (int x = 0; x < coordinateScale; x += 16) {
                for (int z = 0; z < coordinateScale; z += 16) {
                    ChunkAccess checkChunk = destinationLevel.getChunk(new BlockPos(calcPos.getX() + x, originPos.getY(), calcPos.getZ() + z));
                    collectedBlockEntityPositions.addAll(checkChunk.getBlockEntitiesPos());
                }
            }
            int finalCoordinateScale = coordinateScale;
            collectedBlockEntityPositions.removeIf(pos -> pos.getX() < calcPos.getX() || pos.getX() >= calcPos.getX() + finalCoordinateScale || pos.getZ() < calcPos.getZ() || pos.getZ() >= calcPos.getZ() + finalCoordinateScale);
            collectedBlockEntityPositions.removeIf(pos -> !destinationLevel.getBlockState(pos).getBlock().equals((Object)originBlock));
            collectedBlockEntityPositions.removeIf(pos -> !(destinationLevel.getBlockEntity(pos) instanceof NexusPortalCoreBlockEntity));
            if (!collectedBlockEntityPositions.isEmpty() && (destinationBlockEntity = (NexusPortalCoreBlockEntity)destinationLevel.getBlockEntity(destinationPos = (BlockPos)collectedBlockEntityPositions.getFirst())) != null) {
                originBlockEntity.setDestinationPos(destinationPos);
                originBlockEntity.setChanged();
                destinationBlockEntity.setDestinationDimensionRL(originLevel.dimension().location());
                destinationBlockEntity.setDestinationPos(originBlockEntity.getBlockPos());
                destinationBlockEntity.setChanged();
                NexusMessengers.NEXUS_PORTAL_CORE.send(Component.translatable((String)"message.nexus.find_link.success").withStyle(ChatFormatting.GREEN), new Entity[]{player});
                NexusSoundHelper.playSuccessSound(originLocation);
                return;
            }
            NexusMessengers.NEXUS_PORTAL_CORE.send(Component.translatable((String)"message.nexus.find_link.failure").withStyle(ChatFormatting.RED), new Entity[]{player});
            NexusSoundHelper.playErrorSound(originLocation);
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

