/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.packet;

import com.calemi.ccore.api.container.CContainerHelper;
import com.calemi.ccore.api.location.BlockLocation;
import com.calemi.nexus.block.NexusPortalCoreBlock;
import com.calemi.nexus.block.entity.NexusPortalCoreBlockEntity;
import com.calemi.nexus.main.NexusRef;
import com.calemi.nexus.util.NexusSoundHelper;
import com.calemi.nexus.util.message.NexusMessengers;
import com.calemi.nexus.world.dimension.NexusDimensionHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record NexusPortalCoreGenerateLinkPayload(BlockPos portalCorePosition) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, NexusPortalCoreGenerateLinkPayload> CODEC = CustomPacketPayload.codec(NexusPortalCoreGenerateLinkPayload::write, NexusPortalCoreGenerateLinkPayload::new);
    public static final CustomPacketPayload.Type<NexusPortalCoreGenerateLinkPayload> TYPE = new CustomPacketPayload.Type(NexusRef.rl("nexus_portal_core_generate_link"));

    public NexusPortalCoreGenerateLinkPayload(RegistryFriendlyByteBuf buf) {
        this(buf.readBlockPos());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.portalCorePosition);
    }

    public static void handle(NexusPortalCoreGenerateLinkPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            BlockPos originPos = payload.portalCorePosition();
            Player player = context.player();
            ServerLevel originLevel = (ServerLevel)player.level();
            BlockLocation originLocation = new BlockLocation((Level)originLevel, originPos);
            BlockEntity patt0$temp = originLevel.getBlockEntity(originPos);
            if (!(patt0$temp instanceof NexusPortalCoreBlockEntity)) {
                return;
            }
            NexusPortalCoreBlockEntity originBlockEntity = (NexusPortalCoreBlockEntity)patt0$temp;
            NexusPortalCoreBlock originBlock = (NexusPortalCoreBlock)originBlockEntity.getBlockState().getBlock();
            ItemStack heldStack = player.getMainHandItem();
            if (!heldStack.getItem().equals(originBlock.asItem()) && !player.isCreative()) {
                NexusMessengers.NEXUS_PORTAL_CORE.send(Component.translatable((String)"message.nexus.generate_link.no_core").withStyle(ChatFormatting.RED), new Entity[]{player});
                NexusSoundHelper.playErrorSound(originLocation);
                return;
            }
            Level destinationLevel = originBlockEntity.getDestinationLevel();
            if (destinationLevel == null) {
                NexusMessengers.NEXUS_PORTAL_CORE.send(Component.translatable((String)"message.nexus.invalid_dimension").withStyle(ChatFormatting.RED), new Entity[]{player});
                NexusSoundHelper.playErrorSound(originLocation);
                return;
            }
            BlockPos calcPos = NexusDimensionHelper.getDynamicBlockDestination(player.level(), originBlockEntity.getBlockPos(), originBlock.getCoordinateScale());
            if (!NexusDimensionHelper.isDestinationValid(destinationLevel, calcPos)) {
                NexusMessengers.NEXUS_PORTAL_CORE.send(Component.translatable((String)"message.nexus.invalid_destination").withStyle(ChatFormatting.RED), new Entity[]{player});
                NexusSoundHelper.playErrorSound(originLocation);
                return;
            }
            int yLevel = NexusDimensionHelper.getSolidGroundLevel(destinationLevel, calcPos);
            if (yLevel == Integer.MAX_VALUE) {
                NexusMessengers.NEXUS_PORTAL_CORE.send(Component.translatable((String)"message.nexus.generate_link.no_valid_spawn").withStyle(ChatFormatting.RED), new Entity[]{player});
                NexusSoundHelper.playErrorSound(originLocation);
                return;
            }
            BlockPos destinationPos = calcPos.atY(yLevel);
            originBlockEntity.setDestinationDimensionRL(destinationLevel.dimension().location());
            originBlockEntity.setDestinationPos(destinationPos);
            originBlockEntity.setChanged();
            destinationLevel.setBlockAndUpdate(destinationPos, originBlock.defaultBlockState());
            BlockEntity patt1$temp = destinationLevel.getBlockEntity(destinationPos);
            if (patt1$temp instanceof NexusPortalCoreBlockEntity) {
                NexusPortalCoreBlockEntity destinationBlockEntity = (NexusPortalCoreBlockEntity)patt1$temp;
                destinationBlockEntity.setDestinationDimensionRL(originLevel.dimension().location());
                destinationBlockEntity.setDestinationPos(originBlockEntity.getBlockPos());
                if (heldStack.has(DataComponents.CUSTOM_NAME)) {
                    destinationBlockEntity.setPoiName((Component)heldStack.get(DataComponents.CUSTOM_NAME));
                }
                destinationBlockEntity.setChanged();
            }
            if (!player.isCreative()) {
                CContainerHelper.consumeItems((Container)player.getInventory(), (Item)originBlock.asItem(), (int)1);
            }
            NexusMessengers.NEXUS_PORTAL_CORE.send(Component.translatable((String)"message.nexus.generate_link.success").withStyle(ChatFormatting.GREEN), new Entity[]{player});
            NexusSoundHelper.playSuccessSound(originLocation);
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

