/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.packet;

import com.calemi.ccore.api.message.OverlayMessageHelper;
import com.calemi.nexus.block.NexusPortalCoreBlock;
import com.calemi.nexus.main.NexusRef;
import com.calemi.nexus.world.dimension.NexusDimensionHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record NexusPortalCoreHUDOverlayPayload() implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, NexusPortalCoreHUDOverlayPayload> CODEC = CustomPacketPayload.codec(NexusPortalCoreHUDOverlayPayload::write, NexusPortalCoreHUDOverlayPayload::new);
    public static final CustomPacketPayload.Type<NexusPortalCoreHUDOverlayPayload> TYPE = new CustomPacketPayload.Type(NexusRef.rl("nexus_portal_core_hud_overlay"));

    public NexusPortalCoreHUDOverlayPayload(RegistryFriendlyByteBuf buf) {
        this();
    }

    public void write(FriendlyByteBuf buf) {
    }

    public static void handle(NexusPortalCoreHUDOverlayPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            BlockItem blockItem;
            Block patt1$temp;
            ServerPlayer player = (ServerPlayer)context.player();
            ServerLevel level = (ServerLevel)player.level();
            Item patt0$temp = player.getMainHandItem().getItem();
            if (patt0$temp instanceof BlockItem && (patt1$temp = (blockItem = (BlockItem)patt0$temp).getBlock()) instanceof NexusPortalCoreBlock) {
                NexusPortalCoreBlock originBlock = (NexusPortalCoreBlock)patt1$temp;
                BlockPos destinationPosition = NexusDimensionHelper.getDynamicBlockDestination(player.level(), player.blockPosition(), originBlock.getCoordinateScale());
                OverlayMessageHelper.displayMsg((MutableComponent)Component.translatable((String)"hud.nexus.calculated_destination").append(": [x").append(String.valueOf(ChatFormatting.GOLD) + destinationPosition.getX() + String.valueOf(ChatFormatting.WHITE) + " z" + String.valueOf(ChatFormatting.GOLD) + destinationPosition.getZ() + String.valueOf(ChatFormatting.WHITE) + "]"), (ServerPlayer)player);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

