/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.packet;

import com.calemi.nexus.block.entity.NexusPortalCoreBlockEntity;
import com.calemi.nexus.main.NexusRef;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record NexusPortalCoreLightPortalPayload(BlockPos portalCorePosition) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, NexusPortalCoreLightPortalPayload> CODEC = CustomPacketPayload.codec(NexusPortalCoreLightPortalPayload::write, NexusPortalCoreLightPortalPayload::new);
    public static final CustomPacketPayload.Type<NexusPortalCoreLightPortalPayload> TYPE = new CustomPacketPayload.Type(NexusRef.rl("nexus_portal_core_light_portal"));

    public NexusPortalCoreLightPortalPayload(RegistryFriendlyByteBuf buf) {
        this(buf.readBlockPos());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.portalCorePosition);
    }

    public static void handle(NexusPortalCoreLightPortalPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            ServerLevel originLevel = (ServerLevel)player.level();
            BlockEntity patt0$temp = originLevel.getBlockEntity(payload.portalCorePosition());
            if (!(patt0$temp instanceof NexusPortalCoreBlockEntity)) {
                return;
            }
            NexusPortalCoreBlockEntity portalCoreBlockEntity = (NexusPortalCoreBlockEntity)patt0$temp;
            portalCoreBlockEntity.togglePortal((Entity)player);
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

