/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.packet;

import com.calemi.nexus.block.entity.NexusPortalCoreBlockEntity;
import com.calemi.nexus.main.NexusRef;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record NexusPortalCoreTeleportPayload(BlockPos portalCorePosition) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, NexusPortalCoreTeleportPayload> CODEC = CustomPacketPayload.codec(NexusPortalCoreTeleportPayload::write, NexusPortalCoreTeleportPayload::new);
    public static final CustomPacketPayload.Type<NexusPortalCoreTeleportPayload> TYPE = new CustomPacketPayload.Type(NexusRef.rl("nexus_portal_core_teleport"));

    public NexusPortalCoreTeleportPayload(RegistryFriendlyByteBuf buf) {
        this(buf.readBlockPos());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.portalCorePosition);
    }

    public static void handle(NexusPortalCoreTeleportPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            ServerLevel originLevel = (ServerLevel)player.level();
            BlockPos originPos = payload.portalCorePosition();
            BlockState originState = originLevel.getBlockState(originPos);
            BlockEntity patt0$temp = originLevel.getBlockEntity(originPos);
            if (!(patt0$temp instanceof NexusPortalCoreBlockEntity)) {
                return;
            }
            NexusPortalCoreBlockEntity originPortalCore = (NexusPortalCoreBlockEntity)patt0$temp;
            NexusPortalCoreBlockEntity destinationPortalCore = originPortalCore.getDestinationPortalCore();
            if (destinationPortalCore != null && destinationPortalCore.isPortalActive()) {
                player.setPortalCooldown();
            }
            originPortalCore.teleportEntity((Entity)player);
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

