/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.packet;

import com.calemi.ccore.api.item.ItemHelper;
import com.calemi.ccore.api.location.BlockLocation;
import com.calemi.nexus.block.entity.NexusPortalCoreBlockEntity;
import com.calemi.nexus.main.NexusRef;
import com.calemi.nexus.util.NexusSoundHelper;
import com.calemi.nexus.util.message.NexusMessengers;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record NexusPortalCoreUnlinkPayload(BlockPos portalCorePosition, boolean takeLinkedPortalCore) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, NexusPortalCoreUnlinkPayload> CODEC = CustomPacketPayload.codec(NexusPortalCoreUnlinkPayload::write, NexusPortalCoreUnlinkPayload::new);
    public static final CustomPacketPayload.Type<NexusPortalCoreUnlinkPayload> TYPE = new CustomPacketPayload.Type(NexusRef.rl("nexus_portal_core_unlink"));

    public NexusPortalCoreUnlinkPayload(RegistryFriendlyByteBuf buf) {
        this(buf.readBlockPos(), buf.readBoolean());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.portalCorePosition);
        buf.writeBoolean(this.takeLinkedPortalCore);
    }

    public static void handle(NexusPortalCoreUnlinkPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Level destinationLevel;
            NexusPortalCoreBlockEntity destinationBlockEntity;
            Player player = context.player();
            ServerLevel originLevel = (ServerLevel)player.level();
            BlockPos originPos = payload.portalCorePosition();
            BlockPos abovePortalCorePosition = originPos.above();
            BlockLocation originLocation = new BlockLocation((Level)originLevel, originPos);
            BlockEntity patt0$temp = originLevel.getBlockEntity(originPos);
            if (!(patt0$temp instanceof NexusPortalCoreBlockEntity)) {
                return;
            }
            NexusPortalCoreBlockEntity originBlockEntity = (NexusPortalCoreBlockEntity)patt0$temp;
            if (payload.takeLinkedPortalCore() && (destinationBlockEntity = originBlockEntity.getDestinationPortalCore()) != null && (destinationLevel = destinationBlockEntity.getLevel()) != null) {
                ItemStack stackToGive = new ItemStack((ItemLike)destinationLevel.getBlockState(destinationBlockEntity.getBlockPos()).getBlock().asItem());
                Component destinationPOIName = destinationBlockEntity.getPoiName();
                if (destinationBlockEntity.getPoiName() != null) {
                    stackToGive.set(DataComponents.CUSTOM_NAME, (Object)destinationPOIName);
                }
                ItemHelper.giveItem((Player)player, (ItemStack)stackToGive);
                destinationLevel.setBlock(originBlockEntity.getDestinationPos(), Blocks.AIR.defaultBlockState(), 3);
            }
            originBlockEntity.setDestinationPos(null);
            originBlockEntity.setChanged();
            NexusMessengers.NEXUS_PORTAL_CORE.send(Component.translatable((String)"message.nexus.unlink.success").withStyle(ChatFormatting.GREEN), new Entity[]{player});
            NexusSoundHelper.playErrorSound(originLocation);
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

