/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.packet;

import com.calemi.nexus.capability.UnlockedDimensionsList;
import com.calemi.nexus.main.NexusRef;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UnlockedDimensionsListSyncPayload(CompoundTag capabilityNBT) implements CustomPacketPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, UnlockedDimensionsListSyncPayload> CODEC = CustomPacketPayload.codec(UnlockedDimensionsListSyncPayload::write, UnlockedDimensionsListSyncPayload::new);
    public static final CustomPacketPayload.Type<UnlockedDimensionsListSyncPayload> TYPE = new CustomPacketPayload.Type(NexusRef.rl("unlocked_dimensions_list_sync"));

    public UnlockedDimensionsListSyncPayload(UnlockedDimensionsList foodList, HolderLookup.Provider provider) {
        this(foodList.serializeNBT(provider));
    }

    public UnlockedDimensionsListSyncPayload(FriendlyByteBuf buffer) {
        this(buffer.readNbt());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeNbt((Tag)this.capabilityNBT);
    }

    public static void handle(UnlockedDimensionsListSyncPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            UnlockedDimensionsList.get(player).deserializeNBT((HolderLookup.Provider)player.registryAccess(), payload.capabilityNBT());
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"networking.nexus.unlocked_dimension_list_message.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

