/*
 * Decompiled with CFR 0.152.
 */
package com.calemi.nexus.util;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TeleportHelper {
    public static Vec3 getEntityTeleportDestination(BlockPos destination) {
        double x = destination.getX();
        double y = destination.getY();
        double z = destination.getZ();
        return new Vec3(x += 0.5, y, z += 0.5);
    }

    public static void teleportToWorld(Entity entity, BlockPos destination, ResourceKey<Level> dimensionKey) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ServerLevel destLevel = level2.getServer().getLevel(dimensionKey);
            if (destLevel == null) {
                return;
            }
            Vec3 teleportDestination = TeleportHelper.getEntityTeleportDestination(destination);
            entity.teleportTo(destLevel, teleportDestination.x, teleportDestination.y, teleportDestination.z, EnumSet.noneOf(RelativeMovement.class), entity.getYRot(), entity.getXRot());
        }
    }
}

